/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2012 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 2398 $
//
//  $LastChangedDate: 2010-10-05 14:54:37 -0700 (Tue, 05 Oct 2010) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#ifndef __cmtkImageInterpolator_h_included_
#define __cmtkImageInterpolator_h_included_

#include <cmtkconfig.h>

#include <Base/cmtkImageInterpolatorBase.h>
#include <Base/cmtkVector3D.h>
#include <Base/cmtkImage.h>

#include <System/cmtkSmartPtr.h>

namespace
cmtk
{

/** \addtogroup Base */
//@{
/** Class template for kernel-based volume interpolators.
 *
 * This class is templated over the image type and the interpolation function, e.g., linear, cubic, or sinc.
 *
 *\see LinearInterpolator
 *\see CubicInterpolator
 *\see SincInterpolator
 *\see NearestNeighborInterpolator
 */
template<class TImageType,class TInterpolationFunction>
class ImageInterpolator
{
public:
  /// This class type.
  typedef ImageInterpolator<TImageType,TInterpolationFunction> Self;

  /// Image type.
  typedef TImageType ImageType;

  /// Smart pointer to this class.
  typedef SmartPointer<Self> SmartPtr;

  /// Constructor.
  ImageInterpolator( const ImageType::SmartPtr& image )
    : m_Image( image )
  {
  }
  
  /** Get data at location.
   *
   * This function performs interpolation of one value from m_Volume at location
   * v using the interpolation function given as the class template parameter.
   *
   * This function should return true if a value can be interpolated from
   * m_Volume at v, and it should return false if v is outside the range
   * where a value can be interpolated (i.e., outside the volume boundaries).
   */
  typename ImageType::PixelType GetDataAt( const Vector3D& v ) const;

  typename ImageType::PixelType GetDataDirect( const int* imageGridPoint, const Types::Coordinate* insidePixel ) const;

private:
  /// The image we interpolate from.
  Self::ImageType::SmartPtr m_Image;
{

};

//@}

} // namespace cmtk

#include "cmtkImageInterpolator.txx"

#endif // #ifndef __cmtkImageInterpolator_h_included_

