#include <stdlib.h>
#include <stdio.h>
#include "turng.h"

#ifndef __CMIX
#define __CMIX(X)
#endif

int instrs; /* number of instructions in current program */

Instruction instruction[MAXINSTRS] /* = { */
  /* 0  { IfGoto, '0', 3 },*/
  /* 1  { Right          },*/
  /* 2  { Goto, '-', 0   },*/ 
  /* 3  { Write, '1'     },*/
  /* 4  { Stop           }}*/;

char* turing(char tape[], int tapelen) {
  int i;
  int p;
  i = 0; p = 0;
  while (instruction[i].tag != Stop) {
    printstatus("i=%d ", i);
    printstatus("p=%d\n", p);
    switch (instruction[i].tag) {
    case Left     : if (p > 0) p--; break;
    case Right    :
      if (p < tapelen - 2) {
	p++;
	if (tape[p] == '\0') {
	  tape[p + 1] = '\0';
	  tape[p] = ' ';
	}
      }
      break;
    case Write    : tape[p] = instruction[i].a; break;
    case Goto     : i = instruction[i].i; continue;
    case IfGoto   : 
      if (tape[p] == instruction[i].a) {
	i = instruction[i].i; continue;
      }
      break;
    case ReadGoto :

      /*****************************************************/
      /************* EXERCISE: CODE THIS UP ****************/
      printstatus("ReadGoto not implemented\n", 0);
      __CMIX(pure)exit(-1);
      /*****************************************************/

    case Stop     : printstatus("interpreter error\n", 0);
    }
    i++;
  }
  printstatus("\n", 0);
  return tape + p;
}

char* loadAndRunTuring(char* filename, char tape[], int tapelen) {
  readTuringProgram(filename);
  return turing(tape, tapelen);
}
