;;; cmail-use-nickname.el --- Use nickname in summary buffer.

;; Author: Keisuke ICHIHASHI <ksuke@tky2.3web.ne.jp>
;; Keywords: mail
;; Create date: 2000-08-09
;; $Id: cmail-use-nickname.el,v 1.3 2002/10/04 11:50:42 tmp Exp $

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:
;; Installation:
;;	o When `cmail-nickname-file' is used as a database.
;;	Put this line in your ~/.emacs
;;		(setq cmail-use-nickname 'file)
;;	o When bbdb is used as a database.
;;	Put this line in your ~/.emacs
;;		(setq cmail-use-nickname 'bbdb)
;;
;; Customization:
;;	%e in `cmail-summarize-format' corresponds to nickname.
;;
;; Usage:
;;   o cmail-nickname-register
;;	This function registers/removes a nickname.
;;	If a nickname you sets is empty string, remove it from a database.
;;	This function has to be called in *cmail-summary-buffer.

;;; Code:
(require 'path-util)
(require 'alist)
(eval-when-compile (require 'cmail-vars))

;;;
(defun cmail-set-nickname (symbol value)
  (setq cmail-use-nickname value)
  (cond ((and (eq cmail-use-nickname 'bbdb) (module-installed-p 'bbdb))
	 (setq cmail-summary-fp-value-private-function-alist
	       (put-alist ?e 'cmail-nicknameb cmail-summary-fp-value-private-function-alist))
	 (load "cmail-nicknameb"))
	((eq cmail-use-nickname 'file)
	 (setq cmail-summary-fp-value-private-function-alist
	       (put-alist ?e 'cmail-nicknamef cmail-summary-fp-value-private-function-alist))
	 (load "cmail-nicknamef"))
	(t
	 (setq cmail-use-nickname nil)
	 (setq cmail-summary-fp-value-private-function-alist
	       (del-alist ?e cmail-summary-fp-value-private-function-alist)))))

;;;
(cmail-i18n-defgroup cmail-use-nickname-group nil
  ((ja_JP . "$B%5%^%j%P%C%U%!$G%K%C%/%M!<%`$r;HMQ$9$k$?$a$N@_Dj!#(B")
   (en_US . "Setting about using nickname in summary buffer."))
  :group 'cmail-other-features)

(cmail-i18n-defcustom cmail-summary-fp-value-private-function-alist nil
  ((ja_JP . "*cmail-summarize-format $B$G;H$o$l$kJ8;z$H8F$S=P$5$l$k4X?t$N(B alist$B!#(B
$B4X?t$O!"J8;zNs$rJV$9$b$N$r;XDj$9$k$3$H!#(B

$BNc(B)
'((?e . cmail-nicknameb) ...)")
   (en_US . "*An assoc list are pairs of a character and a function.
A function must return strings.

Example)
'((?e . cmail-nicknameb) ...)"))
  :type '(choice (const nil)
		 (repeat (cons integer sexp)))
  :group 'cmail-all-variables
  :group 'cmail-use-nickname-group)

(cmail-i18n-defcustom cmail-use-nickname nil
  ((ja_JP . "*$B%K%C%/%M!<%`$r%5%^%j%P%C%U%!$GMQ$$$k$+$I$&$+!#(B

$BCM$,(B nil $B$N;~$O!"%K%C%/%M!<%`$r;HMQ$7$J$$!#(B
'file $B$N;~$O!"(B `cmail-nickname-file' $B$rMxMQ$9$k!#(B
'bbdb $B$N;~$O!"(B BBDB $B$rMxMQ$9$k!#(B BBDB $B$,I,MW!#(B")
   (en_US . "*Whether to use a nickname in summary buffer.

If this value is nil, do not use nickname.
If that is 'file, use nickname with `cma1il-nickname-file'.
If that is 'bbdb, use nickname with BBDB. BBDB is required."))
  :type '(choice (const :tag "Don't Use Nickname" nil)
		 (const :tag "Use Nickname With File" file)
		 (const :tag "Use Nickname With BBDB" bbdb))
  :set 'cmail-set-nickname
  :group 'cmail-all-variables
  :group 'cmail-use-nickname-group)
(cmail-custom-add-init 'cmail-set-nickname 'cmail-use-nickname)

(cmail-i18n-defcustom cmail-use-nickname-load-hook nil
  ((ja_JP . "*cmail-use-nickname $B$,%m!<%I$5$l$?$H$-$K<B9T$5$l$k%U%C%/!#(B")
   (en_US . "*A hook called when load cmail-use-nickname."))
  :type 'hook
  :group 'cmail-all-variables
  :group 'cmail-use-nickname-group)

(defadvice cmail-summary-fp-value (around add-private-function (chr) activate)
  (store-match-data *cmail-match-data)
  (if *cmail-match-data
      (cond
       ((assoc chr cmail-summary-fp-value-private-function-alist)
	(progn
	  (setq ad-return-value (funcall (cdr (assoc chr cmail-summary-fp-value-private-function-alist))))
	  ad-return-value))
       (t
	ad-do-it))))

;;;
(run-hooks 'cmail-use-nickname-load-hook)
(provide 'cmail-use-nickname)

;;; cmail-use-nickname.el ends here
