;;;
;;;  cmail-digest.el -
;;;
;;;  $Author: tmp $
;;;  created at: Wed Oct 20 14:23:24 JST 1993
;;;
;;;  Copyright (C) 1992-1996 Yukihiro Matsumoto.

;; This file is not part of GNU Emacs but obeys its copyright notice.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(defvar cmail-delete-after-bursting t
  "*non nil$B$N;~(Bdigest$B$rE83+$7$?8e(B, $B85%a%$%k$r:o=|$9$k(B.
$BE83+@h$,2>A[%U%)%k%@$G$"$l$P:o=|$7$J$$(B.")
(defvar cmail-burst-folder "/digest"
  "*$BE83+$7$?(Bdigest$B$rDI2C$9$k%U%)%k%@(B($B%G%U%)%k%H$O2>A[%U%)%k%@(B`/digest')")

;; $B>e5-$NJQ?t$r(B
;;   (setq cmail-burst-folder cmail-inbox-folder)
;; $B$H$9$k$N$b0l$D$N<j$G$"$k(B. $B1?MQ$K$h$C$F;H$$J,$1$FM_$7$$(B.

(defvar cmail-burst-border "^-$\\|^-----"
  "digest$B$N6h@Z$j$r<($9@55,I=8=(B. $B$3$l$GNI$$$N$@$m$&$+(B?")

(defun cmail-rfc934-char-stuff-region (start end)
  (save-excursion
    (goto-char start)
    (while (and (< (point) end) (re-search-forward "^-" end t))
      (replace-match "- -" t t))))

(defun cmail-rfc934-char-unstuff-region (start end)
  (save-excursion
    (goto-char start)
    (while (and (< (point) end) (re-search-forward "^- "  end t))
      (replace-match "" t t)
      (forward-char))))

(defun cmail-burst-digest (fp)
  "digest$B$5$l$?%a%$%k$r8DJL$N%a%$%k$KJ,3d$9$k(B.
\\[universal-argument]$B$,M?$($i$l$?>l9g(B, $BDI2C$9$k%U%)%k%@$rF~NO$G$-$k(B.
$B%G%U%)%k%H$OJQ?t(Bcmail-burst-folder$B$G;XDj$5$l$?%U%)%k%@(B."
  (interactive "P")
  (let (burst-folder)
    (setq burst-folder
	  (if fp
	      (cmail-complete-foldername "Append bursted mails to")
	    cmail-burst-folder))
    (cmail-message-resource 'burst-digest-1)
    (if (cmail-virtual-folder-p burst-folder)
	(save-excursion
	  (cmail-kill-folder burst-folder t)))
    (cmail-exec '(lambda (page) (cmail-burst-internal page burst-folder)))
    (if (not (cmail-virtual-folder-p burst-folder))
	(cmail-save-folder burst-folder))
    (cmail-save-curpos)
    (cmail-visit-folder burst-folder t)
    (sit-for 0)
    (cmail-message-resource 'burst-digest-2)))

(defun cmail-burst-internal (page folder)
  "PAGE$B$N%a%$%k$r(BFOLDER$B$K%"%Z%s%I$9$k(B."
  (let (inbuf beg end max next buf)
    (setq inbuf (get-buffer-create *cmail-new-arrivals-buffer))
    (set-buffer inbuf)
    (erase-buffer)
    (cmail-get-folder)
    (cmail-n-page page)
    (append-to-buffer inbuf (point) (cmail-page-max))
    (set-buffer inbuf)
    ;; $B%X%C%@ItJ,$r(Bskip
    (goto-char (point-min))
    (setq max (point-max))
    (if (and cmail-use-mime (featurep 'mmbuffer)
	     (= 0 (cmail-mime-burst-internal nil folder)))
	(if (not (re-search-forward cmail-burst-border max t))
	    (cmail-error-resource 'burst-internal-1)
	  (forward-line 1)
	  (skip-chars-forward "\n")
	  (setq buf (get-buffer-create *cmail-arrived-mail-buffer))
	  (cmail-skip-From_)
	  (setq beg (point))
	  (while (re-search-forward cmail-burst-border max t)
	    (goto-char (match-beginning 0))
	    (setq next (point))
	    (skip-chars-backward "\n")	; skip back blank lines
	    (forward-char 1)			; save last newline
	    (setq end (point))
	    (set-buffer buf)
	    (widen)
	    (erase-buffer)
	    (cmail-insert-buffer-substring inbuf beg end)
	    (cmail-rfc934-char-unstuff-region (point-min) (point-max))
	    (goto-char (point-min))
	    (cmail-set-mail-status '("Unread") '("Active"))
	    (goto-char (point-max))
	    (insert *cmail-borderline)
	    (cmail-append-mail-to-folder buf folder)
	    (set-buffer inbuf)
	    (goto-char next)
	    (forward-line 1)
	    (skip-chars-forward "\n")
	    (setq beg (point)))))
    (set-buffer *cmail-summary-buffer)
    (and cmail-delete-after-bursting
	 (null (cmail-virtual-folder-p folder))
	 (save-excursion
	   (cmail-get-folder)
	   (setq *cmail-deleted t))
	 (cmail-put-mark page "D" "D"))))

(defun cmail-send-digest (&optional user)
  "$B%a%$%k$N(Bdigest$B$rAw$k(B.
$B%+!<%=%k9T$N%a%$%k$K%^!<%/$,$D$$$F$$$l$P(B, $B%^!<%/$N$D$$$?%a%$%kA4$F$r(B,
$B$D$$$F$$$J$1$l$P%U%)%k%@Fb$NA4$F$N%a%$%k$r(Bdigest$B$9$k(B."
  (interactive)
  (let ((subject (cmail-format-resource1 'send-digest-1 cmail-current-folder))
	(marked (save-excursion
		  (set-buffer *cmail-summary-buffer)
		  (beginning-of-line)
		  (looking-at "^[ +]*[0-9]+\\^")))
	mbuf obuf)
    (if marked
	(progn
	  (set-buffer *cmail-summary-buffer)
	  (setq marked nil)
	  (goto-char (point-max))
	  (while (re-search-backward "^[ +]*[0-9]+\\^" (point-min) t)
	    (setq marked
		  (cons (save-excursion (cmail-get-page-number-from-summary))
			marked)))))
    (cmail-mail user subject 'forward)
    (setq mbuf (get-buffer "*mail*"))
    (cmail-message-resource 'send-digest-2)
    (set-buffer mbuf)
    (let ((point (save-excursion
		   (beginning-of-line)
		   (re-search-forward mail-header-separator nil t))))
      (if (not point)
	  (beginning-of-line)
	(goto-char point)
	(while (and (search-forward "\n" nil 1)
		    (invisible-p (point)))
	  (next-visible-point (point)))))
    (setq top (point))
    (cmail-get-folder)
    (setq obuf (current-buffer))
    (if (and cmail-use-mime cmail-mime-forwarding)
	(cmail-send-mime-digest-internal marked mbuf top obuf)
      (cmail-send-digest-internal marked mbuf top obuf))
    (cmail-select-buffer *cmail-mail-buffer)
    (switch-to-buffer "*mail*")
    (cmail-message-resource 'send-digest-3)))

(defun cmail-send-digest-internal (marked mbuf top obuf)
  (let (beg end last)
    (if marked
	(while marked
	  (set-buffer obuf)
	  (cmail-n-page (car marked))
	  (cmail-skip-From_)
	  (setq beg (point))
	  (setq end (cmail-page-max))
	  (set-buffer mbuf)
	  (setq last (point))
	  (cmail-insert-buffer-substring obuf beg end)
	  (cmail-rfc934-char-stuff-region last (point))
	  (let ((code (detect-coding-region last (point))))
	    (if (listp code) (setq code (car code)))
	    (decode-coding-region last (point) code))
	  (save-restriction
	    (narrow-to-region last (point))
	    (run-hooks 'cmail-digest-prepare-hook))
	  (insert "\n------------------------------\n\n")
	  (setq marked (cdr marked)))
      (cmail-n-page 1)
      (setq beg (point))
      (setq end (point-max))
      (set-buffer mbuf)
      (setq last (point))
      (cmail-insert-buffer-substring obuf beg end)
      (cmail-rfc934-char-stuff-region top (point))
      (let ((code (detect-coding-region last (point))))
	(if (listp code) (setq code (car code)))
	(decode-coding-region last (point) code))
      (goto-char top)
      (while (re-search-forward *cmail-re-bdr nil t)
	(replace-match "\n------------------------------\n" t nil)))
    ;; $B:G8e$N%;%Q%l!<%?$r>C$9(B.
    (if marked (forward-line 1))
    (setq end (point))
    (forward-line -3)
    (delete-region (point) end)
    (insert "------- End of digest -------\n")
    (goto-char top)
    (insert "------- Start of digest -------\n")
    (goto-char top)))
