# Copyright 2019 Objectif Libre
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#
import datetime
import decimal
import functools
import json

from cloudkitty import utils as ck_utils


class CloudkittyJSONEncoder(json.JSONEncoder):
    """Cloudkitty custom json encoder."""

    def default(self, obj):
        if isinstance(obj, decimal.Decimal):
            return float(obj)
        elif isinstance(obj, datetime.datetime):
            return ck_utils.dt2iso(obj)
        return super(CloudkittyJSONEncoder, self).default(obj)


dumps = functools.partial(json.dumps, cls=CloudkittyJSONEncoder)
loads = json.loads
