/*
 * Copyright 2013 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CLICKMANAGER_H
#define CLICKMANAGER_H

#include <QQuickItem>
#include <QHash>
#include <QList>
#include <QVariant>
#include <QVariantList>
#include "application.h"

#ifdef TESTS
#include "fakeprocess.h"
#include "fakenetwork.h"
#include "fakedownloader.h"
#include "testclickmanager.h"
#else
#include <QProcess>
#include "network/network.h"
#include "download/downloader.h"
#endif

class ClickManager : public QQuickItem
{
    Q_OBJECT
    Q_DISABLE_COPY(ClickManager)
    Q_PROPERTY(bool updatesAvailable READ updatesAvailable NOTIFY updatesAvailableChanged)
    Q_PROPERTY(QVariantList model READ model NOTIFY modelChanged)

#ifdef TESTS
    friend class TestClickManager;
#endif

signals:
    void updatesAvailableChanged();
    void modelChanged();
    void updatesNotFound();
    
public:
    ClickManager(QQuickItem *parent = 0);
    ~ClickManager();

    Q_INVOKABLE void checkUpdates();
    Q_INVOKABLE void startDownload(QString packagename);

    bool updatesAvailable() { return this->m_updatesAvailable; }
    QVariantList model() const { return this->m_model; }

private slots:
    void processOutput();
    void processUpdates();
    void downloadUrlObtained(QString packagename, QString url);
    void downloadCreated(QString packagename, QString dbuspath);

private:
    bool m_updatesAvailable;
    QHash<QString, Application*> m_apps;
    QVariantList m_model;
#ifdef TESTS
    FakeNetwork network;
    FakeDownloader downloader;
    FakeProcess m_process;
#else
    QProcess m_process;
    Network network;
    Downloader downloader;
#endif

    void checkForUpdates();
};

QML_DECLARE_TYPE(ClickManager)

#endif // CLICKMANAGER_H

