/*
 * Copyright 2013 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef APPLICATION_H
#define APPLICATION_H

#include <QQuickItem>
#include <QString>

class Application : public QQuickItem
{
    Q_OBJECT
    Q_DISABLE_COPY(Application)
    Q_PROPERTY(QString packageName READ getPackageName)
    Q_PROPERTY(QString title READ getTitle NOTIFY titleChanged)
    Q_PROPERTY(QString localVersion READ getLocalVersion NOTIFY localVersionChanged)
    Q_PROPERTY(QString remoteVersion READ getRemoteVersion NOTIFY remoteVersionChanged)
    Q_PROPERTY(QString toUpdate READ updateRequired)
    Q_PROPERTY(QString iconUrl READ iconUrl NOTIFY iconUrlChanged)
    Q_PROPERTY(int binaryFilesize READ binaryFilesize NOTIFY binaryFilesizeChanged)
    Q_PROPERTY(bool updateState READ updateState WRITE setUpdateState NOTIFY updatesStateChanged)
    Q_PROPERTY(bool selected READ selected WRITE setSelected NOTIFY selectedChanged)
    Q_PROPERTY(QString dbusPath READ dbusPath NOTIFY dbusPathChanged)

signals:
    void titleChanged();
    void binaryFilesizeChanged();
    void iconUrlChanged();
    void localVersionChanged();
    void remoteVersionChanged();
    void updatesStateChanged();
    void selectedChanged();
    void dbusPathChanged();

public:
    Application(QQuickItem *parent = 0);

    QString getPackageName() { return this->m_packagename; }
    QString getTitle() { return this->m_title; }
    QString getLocalVersion() { return this->m_local_version; }
    QString getRemoteVersion() { return this->m_remote_version; }
    QString dbusPath() { return this->m_dbuspath; }
    QString iconUrl() { return this->m_icon_url; }
    int binaryFilesize() { return this->m_binary_filesize; }
    bool updateRequired() { return this->m_update; }
    bool updateState() { return this->m_update_state; }
    bool selected() { return this->m_selected; }

    void initializeApplication(QString packagename, QString title, QString version);
    void setRemoteVersion(QString& version);
    void setUpdateState(bool state) { this->m_update_state = state; emit this->updatesStateChanged(); }
    void setSelected(bool value) { this->m_selected = value; emit this->selectedChanged(); }
    void setDbusPath(QString dbuspath) { this->m_dbuspath = dbuspath; emit this->dbusPathChanged(); }
    void setBinaryFilesize(int size) { this->m_binary_filesize = size; emit this->binaryFilesizeChanged(); }
    void setIconUrl(QString icon) { this->m_icon_url = icon; emit this->iconUrlChanged(); }

private:
    QString m_packagename;
    QString m_title;
    QString m_local_version;
    QString m_remote_version;
    QString m_dbuspath;
    QString m_icon_url;
    int m_binary_filesize;
    bool m_update;
    bool m_update_state;
    bool m_selected;
};

QML_DECLARE_TYPE(Application)

#endif // APPLICATION_H
