import QtQuick 2.0
import QtTest 1.0
import Ubuntu.Components 0.1
import "../../Components"
import "unit_test.js" as UT

// See more details @ http://qt-project.org/doc/qt-5.0/qtquick/qml-testcase.html

// Execute tests with:
//   qmltestrunner

Item {
    // The objects

    QtObject {
        id: modelItem1
        property string packageName: "com.canonical.package1"
        property string title: "My App1"
        property string localVersion: "1.0"
        property string remoteVersion: "1.1"
        property bool toUpdate: true
        property string iconUrl: ""
        property int binaryFilesize: 5000
        property bool updateState: false
        property bool selected: false
        property string dbusPath: ""
        property string error: ""
    }
    QtObject {
        id: modelItem2
        property string packageName: "com.canonical.package2"
        property string title: "My App2"
        property string localVersion: "2.0"
        property string remoteVersion: "2.1"
        property bool toUpdate: true
        property string iconUrl: ""
        property int binaryFilesize: 5000
        property bool updateState: false
        property bool selected: false
        property string dbusPath: ""
        property string error: ""
    }
    QtObject {
        id: modelItem3
        property string packageName: "com.canonical.package3"
        property string title: "My App3"
        property string localVersion: "3.0"
        property string remoteVersion: "3.1"
        property bool toUpdate: true
        property string iconUrl: ""
        property int binaryFilesize: 5000
        property bool updateState: false
        property bool selected: false
        property string dbusPath: ""
        property string error: ""
    }

    property var fakeModel: [modelItem1, modelItem2, modelItem3]

    PageUpdate {
        id: pageUpdate
    }
    
    TestCase {
        name: "PageUpdate"

        function cleanup() {
            for(var i=0; i < fakeModel.length; i++) {
                fakeModel[i].error = "";
            }
        }

        function test_updatelist_items() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            compare(updatelist.count, 3, "expected 3 items in the list");
        }

        function test_model_0_items() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = [];
            pageUpdate.updates = 0;
            var clickManager = UT.findChild(pageUpdate, "clickManager");
            clickManager.updatesNotFound();
            var retryButton = UT.findChild(pageUpdate, "retryButton");
            var labelMessage = UT.findChild(pageUpdate, "labelMessage");
            var installAllButton = UT.findChild(pageUpdate, "installAllButton");
            compare(retryButton.visible, true, "Retry button should be visible");
            compare(labelMessage.visible, true, "Label Message button should be visible");
            compare(installAllButton.visible, false, "Install All button should not be visible");
        }

        function test_model_1_item() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            var clickManager = UT.findChild(pageUpdate, "clickManager");
            clickManager.modelChanged();
            updatelist.model = [modelItem1];
            pageUpdate.updates = 1;
            var retryButton = UT.findChild(pageUpdate, "retryButton");
            var labelMessage = UT.findChild(pageUpdate, "labelMessage");
            var installAllButton = UT.findChild(pageUpdate, "installAllButton");
            compare(retryButton.visible, false, "Retry button should not be visible");
            compare(labelMessage.visible, false, "Label Message button should not be visible");
            compare(installAllButton.visible, false, "Install All button should not be visible");
        }

        function test_model_n_items() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            var clickManager = UT.findChild(pageUpdate, "clickManager");
            clickManager.modelChanged();
            updatelist.model = fakeModel;
            pageUpdate.updates = 3;
            var retryButton = UT.findChild(pageUpdate, "retryButton");
            var labelMessage = UT.findChild(pageUpdate, "labelMessage");
            var installAllButton = UT.findChild(pageUpdate, "installAllButton");
            compare(retryButton.visible, false, "Retry button should not be visible");
            compare(labelMessage.visible, false, "Label Message button should not be visible");
            compare(installAllButton.visible, true, "Install All button should be visible");
        }

        function test_label_message_updates_not_found() {
            var clickManager = UT.findChild(pageUpdate, "clickManager");
            clickManager.updatesNotFound();
            var labelMessage = UT.findChild(pageUpdate, "labelMessage");
            var installAllButton = UT.findChild(pageUpdate, "installAllButton");
            var loadingIndicator = UT.findChild(pageUpdate, "loadingIndicator");
            compare(labelMessage.visible, true, "labelMessage should be visible if there isn't a model");
            compare(installAllButton.visible, false, "installAllButton should not be visible if there isn't a model");
            compare(loadingIndicator.visible, false, "loadingIndicator should not be visible if there isn't a model");
            compare(labelMessage.text, i18n.tr("No Updates Found"), "labelMessage text doesn't match");
        }

        function test_label_message_credentials_not_found() {
            var clickManager = UT.findChild(pageUpdate, "clickManager");
            clickManager.credentialsNotFound();
            var labelMessage = UT.findChild(pageUpdate, "labelMessage");
            var installAllButton = UT.findChild(pageUpdate, "installAllButton");
            var loadingIndicator = UT.findChild(pageUpdate, "loadingIndicator");
            compare(labelMessage.visible, true, "labelMessage should be visible if there isn't a model");
            compare(installAllButton.visible, false, "installAllButton should not be visible if there isn't a model");
            compare(loadingIndicator.visible, false, "loadingIndicator should not be visible if there isn't a model");
            compare(labelMessage.text, i18n.tr("Please log into your Ubuntu One account in System Settings."), "labelMessage text doesn't match");
        }

        function test_check_children() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                updatelist.currentIndex = i;
                var obj = UT.findChild(updatelist.currentItem, "textArea");
                compare(updatelist.currentItem.enabled, true, "Should be enabled");
                var colLeft = UT.findChild(obj, "colLeft");
                compare(colLeft.children[0].color, "#ffffff", "Should be an enabled color");
                compare(colLeft.children[1].visible, true, "Should be visible");
                compare(colLeft.children[1].text, "Version: " + fakeModel[i].remoteVersion, "Remote versions don't match");
                var colRight = UT.findChild(obj, "colRight");
                var mbvalue = parseFloat((fakeModel[i].binaryFilesize / 1024) / 1024).toFixed(2) + " Mb";
                compare(colRight.children[1].text, mbvalue, "Other Mb size expected");
            }
        }

        function test_check_children_on_update() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                fakeModel[i].updateState = true;
                updatelist.currentIndex = i;
                var obj = UT.findChild(updatelist.currentItem, "textArea");
                compare(updatelist.currentItem.enabled, false, "Should not be enabled");
                var colLeft = UT.findChild(obj, "colLeft");
                compare(colLeft.children[0].color, "#808080", "Should not be an enabled color");
                compare(colLeft.children[1].visible, false, "Should not be visible");
            }
        }

        function test_check_children_tracker_error() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                fakeModel[i].updateState = true;
                updatelist.currentIndex = i;
                var textArea = UT.findChild(updatelist.currentItem, "textArea");
                var progress = UT.findChild(updatelist.currentItem, "progress");
                var tracker = UT.findChild(progress, "tracker");
                tracker.error(i18n.tr("network error"));
                compare(updatelist.currentItem.enabled, true, "Should be enabled");
                var colLeft = UT.findChild(textArea, "colLeft");
                compare(colLeft.children[0].color, "#ffffff", "Should be an enabled color");
                compare(colLeft.children[1].visible, true, "Should be visible");
                compare(colLeft.children[1].text, i18n.tr("network error"), "Error message doesn't match");
            }
        }

        function test_check_children_tracker_finished() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                fakeModel[i].updateState = true;
                updatelist.currentIndex = i;
                var textArea = UT.findChild(updatelist.currentItem, "textArea");
                var progress = UT.findChild(updatelist.currentItem, "progress");
                var tracker = UT.findChild(progress, "tracker");
                tracker.finished("/path");
                compare(updatelist.currentItem.enabled, true, "Should be enabled");
                var colLeft = UT.findChild(textArea, "colLeft");
                compare(colLeft.children[0].color, "#ffffff", "Should be an enabled color");
                compare(colLeft.children[1].visible, true, "Should be visible");
                compare(colLeft.children[1].text, i18n.tr("Installed"), "Error message doesn't match");
            }
        }

        function test_check_children_app_error() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                fakeModel[i].updateState = true;
                fakeModel[i].error = "download error";
                updatelist.currentIndex = i;
                var textArea = UT.findChild(updatelist.currentItem, "textArea");
                compare(updatelist.currentItem.enabled, true, "Should be enabled");
                compare(fakeModel[i].updateState, false, "UpdateState should be false");
                var colLeft = UT.findChild(textArea, "colLeft");
                compare(colLeft.children[0].color, "#ffffff", "Should be an enabled color");
                compare(colLeft.children[1].visible, true, "Should be visible");
                compare(colLeft.children[1].text, "download error", "Error message doesn't match");
                var colRight = UT.findChild(textArea, "colRight");
                compare(colRight.children[0].text, i18n.tr("Retry"), "Button text should be: Retry");
            }
        }
    }
}
