import QtQuick 2.0
import QtTest 1.0
import Ubuntu.Components 0.1
import "../../Components"
import "unit_test.js" as UT

// See more details @ http://qt-project.org/doc/qt-5.0/qtquick/qml-testcase.html

// Execute tests with:
//   qmltestrunner

Item {
    // The objects

    QtObject {
        id: modelItem1
        property string packageName: "com.canonical.package1"
        property string title: "My App1"
        property string localVersion: "1.0"
        property string remoteVersion: "1.1"
        property bool toUpdate: true
        property string iconUrl: ""
        property int binaryFilesize: 5000
        property bool updateState: false
        property bool selected: false
        property string dbusPath: ""
    }
    QtObject {
        id: modelItem2
        property string packageName: "com.canonical.package2"
        property string title: "My App2"
        property string localVersion: "2.0"
        property string remoteVersion: "2.1"
        property bool toUpdate: true
        property string iconUrl: ""
        property int binaryFilesize: 5000
        property bool updateState: false
        property bool selected: false
        property string dbusPath: ""
    }
    QtObject {
        id: modelItem3
        property string packageName: "com.canonical.package3"
        property string title: "My App3"
        property string localVersion: "3.0"
        property string remoteVersion: "3.1"
        property bool toUpdate: true
        property string iconUrl: ""
        property int binaryFilesize: 5000
        property bool updateState: false
        property bool selected: false
        property string dbusPath: ""
    }

    property var fakeModel: [modelItem1, modelItem2, modelItem3]

    PageUpdate {
        id: pageUpdate
    }
    
    TestCase {
        name: "PageUpdate"

        function test_updatelist_items() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            compare(updatelist.count, 3, "expected 3 items in the list");
        }

        function test_check_children() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                updatelist.currentIndex = i;
                var obj = UT.findChild(updatelist.currentItem, "textArea");
                compare(updatelist.currentItem.enabled, true, "Should be enabled");
                var colLeft = UT.findChild(obj, "colLeft");
                compare(colLeft.children[0].color, "#ffffff", "Should be an enabled color");
                compare(colLeft.children[1].visible, true, "Should be visible");
                compare(colLeft.children[1].text, "Version: " + fakeModel[i].remoteVersion, "Remote versions don't match");
                var colRight = UT.findChild(obj, "colRight");
                var mbvalue = parseFloat((fakeModel[i].binaryFilesize / 1024) / 1024).toFixed(2) + " Mb";
                compare(colRight.children[1].text, mbvalue, "Other Mb size expected");
            }
        }

        function test_check_children_on_update() {
            var updatelist = UT.findChild(pageUpdate, "updateList");
            updatelist.model = fakeModel;
            for(var i=0; i < fakeModel.length; i++) {
                fakeModel[i].updateState = true;
                updatelist.currentIndex = i;
                var obj = UT.findChild(updatelist.currentItem, "textArea");
                compare(updatelist.currentItem.enabled, false, "Should not be enabled");
                var colLeft = UT.findChild(obj, "colLeft");
                compare(colLeft.children[0].color, "#808080", "Should not be an enabled color");
                compare(colLeft.children[1].visible, false, "Should not be visible");
            }
        }
    }
}
