# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-

"""Tests for PageUpdate"""

import os

from autopilot.matchers import Eventually
from textwrap import dedent
from testtools.matchers import Is, Not, Equals
from testtools import skip

from UpdateManager import UbuntuTouchAppTestCase


class PageUpdateTests(UbuntuTouchAppTestCase):
    """Page Update Tests."""

    test_qml_file = "%s/%s.qml" % (os.path.dirname(os.path.realpath(__file__)),"../../../../updatemanager")

    def test_UI_is_loaded(self):
        """Must be able to see the mainview."""

        mainView = self.get_mainview()
        self.assertThat(mainView.visible, Eventually(Equals(True)))


    def test_loading_disappear(self):
        """Check the loading indicator disappears"""

        loading = self.get_object(objectName="loadingIndicator")
        self.assertThat(loading.visible, Eventually(Equals(False)))
