/* ************************************************************************
 * Copyright 2013 Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ************************************************************************/


#pragma once
#if !defined( AMD_CLFFT_generator_H )
#define AMD_CLFFT_generator_H

//	Enum to help provide descriptive names to array indices, when indexing into our various vectors
enum clfftGenerators
{
    Stockham, // Using the Stockham autosort frameworks
    Transpose_VLIW,
    Transpose_GCN,
    Transpose_SQUARE,
    Copy,
    ENDGENERATORS			///< This value will always be last, and marks the length of clfftGenerators
};

#endif
