use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

toggle Language::INTERCAL 'bug=100';

print "1..5\n";

my $prog = '
	@K@L`@{
	@@@KK{
M]	@K@L`@KJ{{J{
	@@
';

compile Language::INTERCAL 'prog', $prog;
eval { prog(0, 0) };
print $@ =~ /774 COMPILER ERROR/ ? "" : "not ", "ok 1\n";

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
eval { prog_q(0, 0) };
print $@ =~ /774 COMPILER ERROR/ ? "" : "not ", "ok 2\n";

compile Language::INTERCAL 'prog_p', $prog, 'post';
eval { prog_p(0, 0) };
print $@ =~ /774 COMPILER ERROR/ ? "" : "not ", "ok 3\n";

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
eval { prog_qp(0, 0) };
print $@ =~ /774 COMPILER ERROR/ ? "" : "not ", "ok 4\n";

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
_run_db(prog_d(0, 0));
print $@ =~ /774 COMPILER ERROR/ ? "" : "not ", "ok 5\n";

