#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Notebook and Icon Layout for the Main Widget)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################


import fcntl,  os, os.path, signal, sys
import gtk, pygtk
import tab

class create:
	def __init__(self):
		'''This function creates the main notebook that holds the icon layouts'''
		self.pages = {}
		self.main_notebook = gtk.Notebook()
		self.main_notebook.set_scrollable(True)
		if len(sys.argv) > 1:
			for location in sys.argv[1:]:
				page = self.newNotebookPage(location)
		else:
				page = self.newNotebookPage(os.getcwd())

	def newNotebookPage(self, location=None):
		'''This function adds a new page to the notebook'''
		page = tab.create(self, location)
		return page

	def addInfoBar(self, info_bar):
		self.info_bar = info_bar

	def _populate_(self, directory):
		'''This function (re)populates an icon view'''
		for page in self.pages:
			 if page.scroll == self.main_notebook.get_children()[self.main_notebook.get_current_page()]:
				page.__populate__(directory)

	def toggleView(self):
		'''This function is called by the list view toggle button to
		toggle the current view to the other view'''
		for page in self.pages:
			 if page.scroll == self.main_notebook.get_children()[self.main_notebook.get_current_page()]:
				page._toggleView_()		

	def setPreferences(self):
		'''This function resets the preferences for all the tabs'''
		for page in self.pages:
			page.__setPreferences__()


	def __destroyPage__(self, page):
		'''This function destroys a page'''
		self.main_notebook.disconnect(self.pages[page])
		selected_page = self.main_notebook.page_num(page.scroll)
		self.main_notebook.remove_page(selected_page)
		del self.pages[page]
