#!/usr/bin/env python

########################################################################
# Chris's Lame Filebrowser 4 (Creates the Toolbar for the Main Widget)
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import os, os.path, string, commands, glob
import pygtk, gtk
import message, find_dialog
from xml.dom import minidom

class create:
	def __init__(self, Notebook):
		'''This class creates an addressbar for the main widget and handles the 
		associated callbacks'''
		self.Notebook = Notebook

		# Create a handle box and some formatting boxes
		self.handle_box = gtk.HandleBox()
		packing_box = gtk.HBox(False)
		entry_box = gtk.HBox(True, True)
		button_box = gtk.HBox(False, True)
		packing_box.pack_start(entry_box, True, True)
		packing_box.pack_start(button_box, False, True)
		self.handle_box.add(packing_box)

		# Create an entry completion and add it to the entry box
		entry = gtk.Entry()
		self.entry_completion = gtk.EntryCompletion()
		entry.set_completion(self.entry_completion)
		entry_box.pack_start(entry)

		# Create the model for the entry completion and add it to then entry completion
		self.list_store = gtk.ListStore(str)
		self.entry_completion.set_model(self.list_store)
		self.entry_completion.set_text_column(0)

		# Create the buttons for the address bar
		go_button = gtk.Button("Go")
		go_button.connect("clicked", self.go)
		
		filter_button = gtk.Button("Filter")
		filter_button.connect("clicked", self.filterFiles)
		
		find_button = gtk.Button("Find")
		find_button.connect("clicked", self.find)
		
		button_box.pack_start(go_button)
		button_box.pack_start(filter_button)
		button_box.pack_start(find_button)

		# Connect the entry to some signals
		entry.connect("activate", self.go) 
		entry.connect( "key_press_event", self.textInserted)

		# Add the current directory to the completion list
		self._populate_(os.getcwd())

	def textInserted(self, entry, string):
		if os.path.isdir(entry.get_text()):
			self._populate_(entry.get_text())


	def go(self, button):
		'''This is the callback for the Go button'''
		entry = self.entry_completion.get_entry().get_text()

		# See if this is a directory to load
		if os.path.isdir(entry):
			new_location = entry
			if os.path.isdir(new_location) and os.access(new_location, os.R_OK):
				self.Notebook._populate_(os.path.realpath(new_location))

		# See if this is a command
		elif commands.getstatusoutput("which " + string.split(entry)[0])[0] in [0, "0"]:
			message.show_command_output(entry)


	def filterFiles(self, button):
		''' This function filters the files in the current directory based on the glob in the entry'''
		
		# Get the search text and the glob results
		entry = self.entry_completion.get_entry().get_text()
		results = glob.glob(os.getcwd() + "/" + entry)

		# Get the notebook page instance
		page_number = self.Notebook.main_notebook.get_current_page()
		page = self.Notebook.main_notebook.get_nth_page(page_number)
		
		# Find the matching page
		for page in self.Notebook.pages:
			if page.scroll == self.Notebook.main_notebook.get_children()[self.Notebook.main_notebook.get_current_page()]:

				# Remove all non-matching files
				for location in os.listdir(os.getcwd()):
					if os.getcwd() + "/" + location  not in results and not location.startswith("."):
						location = os.getcwd() + "/" + location
						page.main_layout.remove(page.icons[location])
						page.main_layout.remove(page.labels[location])
						del page.icons[location]
						del page.labels[location]
						#page.__deleteIcon__([location])


	def find(self, button):
		'''This function finds files using the locate command'''
		find_dialog.create(self.Notebook, self.entry_completion.get_entry().get_text())	


	def _populate_(self, directory):
		'''This function adds the directorys in the current directory to the entry completion list'''
		self.list_store.clear()

		directory = string.rstrip(directory, "/")
		directory = os.path.normpath(directory)
		for afile in os.listdir(directory):
			if os.path.isdir(directory + "/" +afile):
				self.list_store.append([directory + "/" + afile])
