builds := llvm

BUILDDEPS	:= ocaml-nox (>= 3.11.2), ocaml-best-compilers | ocaml-nox, \
		   dh-ocaml (>= 0.9.1)

PF		:= /usr/lib/llvm-snapshot

include /usr/share/ocaml/ocamlvars.mk

llvm_packages := llvm-snapshot

# assertions are not disabled for snapshot builds
llvm_confargs := $(confargs) \
	--prefix=$(PF) \
	--enable-optimized --with-optimize-option=' $(opt_flags)' --enable-pic --enable-libffi \
	--with-ocaml-libdir=$(OCAML_STDLIB_DIR)/llvm-$(UVERSION)

llvm_MAKEOPTS := $(MAKEOPTS) \
	VERBOSE=1 \
	DebianOpts="-DLLVM_DEBIAN_INFO='\" ($(OS) $(VERSION))\"'"

# run testsuite
llvm_check := yes

llvm_MAKECHECKOPTS := $(MAKEOPTS) \
	VERBOSE=1 \
	PATH="$(D)/build-llvm/Release/bin:$(srcdir)/test/Scripts:/usr/bin:/bin"

define llvm-snapshot_extra_binary
	if test "x$*" = "xllvm-snapshot" ; then \
		sed -r 's/^(my\s+\$$LLVM_SRC_ROOT\s+=\s+q)\{(.*)\}\;$$/\1\{$(subst /,\/,$(PF))\/build\}\;/' \
			-i $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/bin/llvm-config ; \
		sed -r 's/^(my\s+\$$LLVM_OBJ_ROOT\s+=\s+q)\{(.*)\}\;$$/\1\{$(subst /,\/,$(PF))\/build\}\;/' \
			-i $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/bin/llvm-config ; \
		sed -r 's/^(LLVM_SRC_ROOT\s+\:\=\s+\$$\(shell cd).*\; \$$\(PWD\)\)$$/\1 $(subst /,\/,$(PF))\/build \; \$$\(PWD\)\)/' \
			-i $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/build/Makefile.config ; \
		sed -r 's/^(LLVM_OBJ_ROOT\s+\:\=\s+\$$\(shell cd).*\; \$$\(PWD\)\)$$/\1 $(subst /,\/,$(PF))\/build \; \$$\(PWD\)\)/' \
			-i $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/build/Makefile.config ; \
		sed -r "s/^(ac_pwd\=)'.*'$$/\1'$(subst /,\/,$(PF))\/build'/" \
			-i $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/build/config.status ; \
		find $(D)/debian/$(strip $(call pkgname,$*)) -type f -name "LICENSE.TXT" | xargs $(RM) ; \
		if test "x$(llvm_check)" = "xyes" ; then \
			install -m 0644 $(D)/build-llvm/test/testrun.sum \
			$(D)/debian/$(strip $(call pkgname,$*))/usr/share/doc/$(strip $(call pkgname,$*))/ ; \
			echo >> $(D)/debian/$(strip $(call pkgname,$*))/usr/share/doc/$(strip $(call pkgname,$*))/testrun.sum ; \
			echo "Compiler version: $(shell $(DEB_HOST_GNU_TYPE)-gcc -dumpversion) (GCC)" \
			  >> $(D)/debian/$(strip $(call pkgname,$*))/usr/share/doc/$(strip $(call pkgname,$*))/testrun.sum ; \
			echo "Platform: $(DEB_HOST_GNU_TYPE)" \
			  >> $(D)/debian/$(strip $(call pkgname,$*))/usr/share/doc/$(strip $(call pkgname,$*))/testrun.sum ; \
			echo "configure flags: $(llvm_confargs)" \
			  >> $(D)/debian/$(strip $(call pkgname,$*))/usr/share/doc/$(strip $(call pkgname,$*))/testrun.sum ; \
			gzip -9nf $(D)/debian/$(strip $(call pkgname,$*))/usr/share/doc/$(strip $(call pkgname,$*))/testrun.sum ; \
		fi ; \
	fi
endef

