;;; -*- Mode: Lisp -*-
;;; Simple example of TCLink usage, along the lines of tctest.c
;;; Copyright 2002 Matthew Danish <mrd@debian.org>
;;; Distributed under the terms of the LLGPL.
;;; See LICENSE file for more details.

;;; Make certain to load CL-TCLINK before compiling this file

(defpackage #:TCTEST
  (:use #:COMMON-LISP)
  (:export #:RUN))

(in-package #:TCTEST)

;; A small macro to iterate over association lists cleanly
(defmacro do-alist ((keyvar valvar alist &optional retval) &body body)
  `(loop
    for ((,keyvar . ,valvar)) on ,alist
    do (progn ,@body)
    finally (return ,retval)))

(defun run ()
  (format t "~&Using TCLink version: ~A~%" (tclink:get-version))
  
  (let ((params '(("custid" . "TestMerchant")
		  ("password" . "password")
		  ("action" . "sale")
		  ("amount" . "100")
		  ("cc" . "4111111111111111")
		  ("exp" . "0404"))))

    (format t "~&~%Sending:~%~%")
    
    (do-alist (name value params)
      (format t "~&~A~10T=~10T~A~%" name value)) ; 10 char spacing

    (format t "~&~%Received:~%~%")

    ;; Omitting the handle means that a handle should be temporarily
    ;; created for this use.
    (do-alist (name value (tclink:send-with-parameters params))
      (format t "~&~A~10T=~10T~A~%" name value))

    (values))) ; Return no values
