      SUBROUTINE SETUP0
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8FINT.INC'
      INTEGER I,J,NUSER
      PARAMETER (NUSER=4)
      DOUBLE PRECISION XST0(NUSER)
      DATA (XST0(I),I=1,NUSER) /
     F  1.4d0, 1.4d0, 0.055d0, 0.0105d0
C   REMARK:   IT MAY BE BETTER TO INDRODUCE (TW-0.01)/100 (TW=X(4))
C   AS A NEW VARIABLE
     F       /
C   NAME IS IDENT OF THE EXAMPLE/USER AND CAN BE SET AT USERS WILL
C   THE FIRST CHARACTER MUST BE ALPHABETIC.  40 CHARACTERS MAXIMUM
       NAME='GIRDERDESIGN'
C   X IS INITIAL GUESS AND ALSO HOLDS THE CURRENT SOLUTION
C   PROBLEM DIMENSION N=DIM(X), NH=DIM(H), NG=DIM(G)
      N=NUSER
      NH=0
      NG=14
      ANALYT=.FALSE.
      EPSFCN=1.1D-16
      DIFFTYPE=3
      TAUBND=0.005D0
      COLD=.TRUE.
      SILENT=.FALSE.
      EPSDIF=1.d-14
      PROU=10
      MEU=20
C   DEL0 AND TAU0: SEE BELOW
      DEL0=0.0005d0
      TAU0=1.D0
      DO I=1,N
	X(I)=XST0(I)
      ENDDO
C    GUNIT-ARRAY, SEE DONLP2DOC.TXT
      DO J=0,6
	GUNIT(1,J)=-1
	GUNIT(2,J)=0
	GUNIT(3,J)=0
      ENDDO
      DO J=7,10
        GUNIT(1,J)=1
        GUNIT(2,J)=J-6
        GUNIT(3,J)=1
      ENDDO
      DO J=11,14
        GUNIT(1,J)=1
        GUNIT(2,J)=J-10
        GUNIT(3,J)=-1
      ENDDO
C  GCONST-ARRAY:
      DO J=0,6
        GCONST(J)=.FALSE.
C  IF THE J-TH FUNCTION IS AFFINE LINEAR
      ENDDO
      RETURN
      END

C     OBJECTIVE FUNCTION
      SUBROUTINE EF(X,FX)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),FX
      DOUBLE PRECISION L
      PARAMETER (L=25.D0)
      ICF=ICF+1
      FX=L*(X(1)*X(4)+2.D0*X(2)*X(3))
      RETURN
      END
C     GRADIENT OF OBJECTIVE FUNCTION
      SUBROUTINE EGRADF(X,GRADF)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),GRADF(*)
C     USER DECLARATIONS, IF ANY ,FOLLOW
C WE HAVE ANALYT=.FALSE.
      RETURN
      END

C  COMPUTE THE I-TH EQUALITY CONSTAINT, VALUE IS HXI
      SUBROUTINE EH(I,X,HXI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),HXI
      INTEGER I
C THERE ARE NO EQUALITY CONSTRAINTS
      RETURN
      END
C  COMPUTE THE GRADIENT OF THE I-TH EQUALITY CONSTRAINT
      SUBROUTINE EGRADH(I,X,GRADHI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),GRADHI(*)
      INTEGER I
C THERE ARE NO EQUALITY CONSTRAINTS
      RETURN
      END

C COMPUTE THE I-TH INEQUALITY CONSTAINT, BOUNDS INCLUDED

      SUBROUTINE EG(I,X,GXI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),GXI
      INTEGER I
C******** LOCAL VARIABLES
      DOUBLE PRECISION L,E,SY,SA,TA,ST,DA,PM,PS,LLIMP,A,
     *   IN,W,M,SS,SF,SW,LS,D,T,OG(4),UG(4)
C**** TECHNICAL PARAMETERS
      PARAMETER (L=25.D0,E=210.D0,SY=262.D0,SA=0.55D0*SY,
     *    TA=0.33D0*SY, ST=255.D0,DA=L/800.D0, PM=105.D0,
     *    PS=155.D0,LLIMP=1.D0+50.D0/(L+125.D0))
C**** BOUNDS ON THE VARIABLES
C
C     H=X(1), B=X(2) , TF=X(3) , TW=X(4)
C
      DATA UG/0.3D0,0.3D0,0.01D0,0.01D0/,
     *     OG/2.5D0,2.5D0,0.1D0,0.0115D0/
      IF ( GUNIT(1,I+NH) .EQ. -1 ) CRES(I+NH)=CRES(I+NH)+1
      IF ( I .GE. 7 ) GOTO 700
C     CROSS SECTION
      A=X(1)*X(4)+2.D0*X(2)*X(3)
C     INERTIA
      IN=X(4)*X(1)**3/12.D0+X(2)*X(3)**3*2.D0/3.D0
     *   +0.5D0*X(1)*X(2)*X(3)*(X(1)+2.D0*X(3))
C     UNIFORM LOAD
      W=19.D0+77.D0*A
C     BENDING MOMENT
      M=L*(2.D0*PM+W*L)/8.D0
C     BENDING STRESS
      SS=M*(X(1)*0.5D0+X(3))/(1000.D0*IN)
C     FLANGE BUCKLING STRESS LIMIT
      SF=72845.D0*(X(3)/X(2))**2
C     WEB CRIBBLING STRESS
      SW=3648276.D0*(X(4)/X(1))**2
C     SHEAR FORCE
      LS=(PS+W*L)*0.5D0
C     DEFLECTION
      D=L**3*((8.D0*PM+5.D0*W*L)/(384.D0*E*I*1.D6))
C     AVERAGE SHEAR STRESS
      T=LS/(1.D3*X(1)*X(4))
      GOTO (100,200,300,400,500,600), I
  100 CONTINUE
      GXI=SA-SS
      RETURN
  200 CONTINUE
      GXI=SF-SS
      RETURN
  300 CONTINUE
      GXI=SW-SS
      RETURN
  400 CONTINUE
      GXI=TA-T
      RETURN
  500 CONTINUE
      GXI=DA-D
      RETURN
  600 CONTINUE
      GXI=ST*0.5D0-SS
      RETURN
  700 CONTINUE
      IF ( I .GE. 11 ) THEN
        GXI=OG(I-10)-X(I-10)
      ELSE
        GXI=X(I-6)-UG(I-6)
      ENDIF
      RETURN
      END
C COMPUTE THE GRADIENT OF THE I-TH INEQUALITY CONSTRAINT
C NOT NECESSARY FOR BOUNDS, BUT CONSTANT GRADIENTS MUST BE SET
C HERE E.G. USING DCOPY FROM A DATA-FIELD
      SUBROUTINE EGRADG(I,X,GRADGI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*) ,GRADGI(*)
      INTEGER I
      RETURN
      END
      SUBROUTINE SETUP
      INCLUDE 'O8COMM.INC'
C     CHANGE TERMINATION CRITERION
      EPSX=1.d-7
C     CHANGE I/O-CONTROL
      TE0=.TRUE.
C*** NOW YOU GET FOR EVERY STEP A ONE-LINE-OUTPUT ON STDOUT
      RETURN
      END
