C   CONDITIONS OF USE:
C
C1. DONLP2 IS UNDER THE EXCLUSIVE COPYRIGHT OF  P. SPELLUCCI
C   (E-MAIL:SPELLUCCI@MATHEMATIK.TU-DARMSTADT.DE)
C   "DONLP2" IS A RESERVED NAME
C2. DONLP2 AND ITS CONSTITUENT PARTS COME WITH NO WARRANTY, WHETHER EX-
C   PRESSED OR IMPLIED, THAT IT IS FREE OF ERRORS ORE SUITABLE FOR ANY
C   SPECIFIC PURPOSE.
C   IT MUST NOT BE USED TO SOLVE ANY PROBLEM, WHOSE INCORRECT SOLUTION
C   COULD RESULT IN INJURY TO A PERSON , INSTITUTION OR PROPERTY.
C   IT IS AT THE USERS OWN RISK TO USE DONLP2 OR PARTS OF IT AND THE
C   AUTHOR DISCLAIMS ALL LIABILITY FOR SUCH USE.
C3. DONLP2 IS DISTRIBUTED "AS IS". IN PARTICULAR, NO MAINTENANCE,
C   SUPPORT
C   OR TROUBLE-SHOOTING OR SUBSEQUENT UPGRADE IS IMPLIED.
C4. THE USE OF DONLP2 MUST BE ACKNOWLEDGED, IN ANY PUBLICATION
C   WHICH CONTAINS
C   RESULTS OBTAINED WITH IT OR PARTS OF IT. CITATION OF THE
c   AUTHORS NAME
C   AND NETLIB-SOURCE IS SUITABLE.
C5. THE FREE USE OF DONLP2 AND PARTS OF IT IS RESTRICTED FOR
C   RESEARCH PURPOSES.
C   COMMERCIAL USES REQUIRE PERMISSION AND LICENSING FROM P. SPELLUCCI.
C     D O N L P  2
C   VERSION 09/07/99
C   TAUQP DEPENDENT ON SCALRES ONLY
C   WEIGHTS COMPUTED IN A MODIFIED VERSION IN THE SINGULAR CASE
C   SOME COMPARISONS RELATIVE TO ZERO CHANGED
C   ERROR-RETURN FOR FUNCTION EVALUATION AS ADDED FEATURE
C   TERMINATION OF QP-SOLVER CHANGED (D NOT SET TO ZERO)
C   NEW VERSION OF BFGS: IF NR = 0 TAKE POWELL'S UPDATE
C   NO SUPPRESSION OF UPDATE BEFOREHAND (WITH EXCEPTION DG=0)
C   PLUS SOME MINOR CORRECTIONS
C
C   FOR CONSISTENCY REASONS VARIABLE NAMES CF AND CGF CHANGED INTO
C   ICF AND ICGF
C   NEW USER VARIABLES EPSPHI and NUMSM introduced for user control of
C   TERMINATION DUE TO SMALL PROGRESS IN OBJECTIVE FUNCTION VALUE
C
C   ADDED FEATURE NUMERICAL DIFFERENTIATION OF ORDER 1,2,6
C   REQUIRES NEW PARAMETERS EPSFCN, TAUBND, DIFFTYPE
C
C   ADDED FEATURE OF EXTERNAL BLOCKWISE EVALUATION OF FUNCTIONS
C   RATHER THAN INDIVIDUAL EVALUATION
C   REQUIRES NEW PARAMETER BLOC
C
C   NEW FEATURE OF USER-SUPPLIED SCALING OF X
C
C   CALLING O8ST IMMEDIATELY AFTER SETUP0 (CORRECTION)
C
C   CORRECTION CONCERNING COMPUTATION OF DD
C   (SECOND ORDER CORRECTION OF X)
C   IN CASE OF BOUND VIOLATION: VIOBND ADDED
C
C   CORRECTION FOR FEASIBLE OPTIMAL POINT IN ITSTEP 2 (O8QPDU)
C   CHANGED TERMINATION CRITERION, ADDED SETTINGS AFTER L2000
C*******************************************************************
      SUBROUTINE DONLP2
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8FINT.INC'
      INCLUDE 'O8CONS.INC'
      DOUBLE PRECISION YY(NX),O8VECN
      INTEGER I,J,IDUM
      REAL O8CPU
      SAVE
C  DEFAULT SETTINGS OF NEW PARAMETERS
      BLOC=.FALSE.
      ANALYT=.TRUE.
      VALID=.FALSE.
      EPSFCN=1.D-16
      DIFFTYPE=3
      TAUBND=1.D0
      DO I=1,NX
        XSC(I)=ONE
        XTR(I)=ZERO
      ENDDO
      EPSDIF=TM8
      DO I=0,NRESM
C*** PRESENTLY, THE TEST-CASES IN THE TESTENVIRONMENT DO
C    NOT DIFFERENTIATE
C    BETWEEN LINEAR AND
C*** NONLINEAR CONSTRAINTS. FOR LATER EXTENSIONS OR USERS
C*** FUNCTIONS THIS:
        GCONST(I)=.FALSE.
        VAL(I)=.FALSE.
        IF ( I .GT. 0 ) GRESN(I)=ONE
      ENDDO
      DO I=1,NRESM
        CFUERR(I)=.FALSE.
C*** THE ERROR INDICATOR OF THE FUNCTION EVALUATION
      ENDDO
      FFUERR=.FALSE.

C
C     SOME STANDARD INITIALIZATION WHICH MAY BE OVERWRITTEN BY
C     SETUP0 OR SETUP
C
      INX=.FALSE.
      SILENT=.FALSE.
C***** THE INTERACTIVE INPUT FEATURE IS NO LONGER SUPPORTED HERE.
C***** FOR THE SAKE
C***** OF EASY REVISION THE VARIABLE IS SUPPLIED HERE HOWEVER
C***** IF INTAKT IS SET TRUE, OUTPUT TO PROTOCOL FILE IS COPIED TO
C***** STDOUT IN ADDITION
      INTAKT=.FALSE.
      TE0=.FALSE.
      TE1=.FALSE.
      TE2=.FALSE.
      TE3=.FALSE.
      COLD=.TRUE.
      PROU=10
      MEU=20
C***  SETUP0 MUST INITIALIZE  ANALYT, EPSDIF, DEL0, TAU0 , N , NH ,
C     NG , GUNIT
C     GCONST , EPSFCN , TAUBND , ANALYT , BLOC , DIFFTYPE
C     AND THE INITIAL VALUE FOR X
C     (MIGHT BE ALSO DONE IN BLOCK DATA OF COURSE)
C     MAY ALSO CHANGE SETTINGS OF ALL VARIABLES INITIALIZED ABOVE
C     OR VIA BLOCKDATA
C***
      CALL SETUP0
C
      CALL O8ST
C
C***
C***
C***  THE DEFAULT FOR NUMSM
      NUMSM=MAX(N,10)
      DO I=1,N
        XST(I)=X(I)
        IF ( XSC(I) .EQ. ZERO ) THEN
          WRITE(*,*)  'SCALING VARIABLE ',I,' IS ZERO'
          STOP
        ENDIF
        X(I)=X(I)/XSC(I)
      ENDDO
      NRESET=N
C     DEFAULT FOR EPSPHI
      EPSPHI=TP3*EPSMAC
C***  SETUP MAY CHANGE STANDARD SETTTINGS OF PARAMETERS
C     AND ADD SOME COMPUTATIONS
C     IN THE USER ENVIRONMENT
C
      DO I=1,N
C**** UG AND OG HAVE BEEN EVALUTED FOR THE ORIGINAL VARIABLES
C**** HERE WE USE THEM INTERNALLY FOR THE SCALED ONES
        IF ( LLOW(I) ) UG(I)=UG(I)/XSC(I)
        IF ( LUP(I) ) OG(I)=OG(I)/XSC(I)
      ENDDO
      CALL SETUP
C*** PREEVALUATION OF GRADIENTS OF LINEAR FUNCTIONS
C    DONE ONLY ONCE
C
      DO I=0,NRES
        IF ( GUNIT(1,I) .NE. 1 .AND. GCONST(I) ) THEN
C****** EVALUATE GRADIENT ONCE
          IF ( I .EQ. 0 ) THEN
            VAL(0)=.TRUE.
            CALL ESGRADF(X,GRADF)
          ELSE
            VAL(I)=.TRUE.
            IF ( I .LE. NH ) THEN
              CALL ESGRADH(I,X,YY)
            ELSE
              CALL ESGRADG(I-NH,X,YY)
            ENDIF
            DO J=1,N
              GRES(J,I)=YY(J)
            ENDDO
            GRESN(I)=MAX(ONE,O8VECN(1,N,YY))
          ENDIF
        ENDIF
      ENDDO
      IDUM=0
      RUNTIM=O8CPU(IDUM)
C***** CALL THE OPTIMIZER
      CALL O8OPTI
      RUNTIM=O8CPU(IDUM)-RUNTIM
C*****
C***** DO FINAL SOLUTION CHECK AND OUTPUT
      CALL O8FIN
      RETURN
      END
