      SUBROUTINE RHOJAC(A,LAMBDA,X,V,K,PAR,IPAR)
      DOUBLE PRECISION A(*),LAMBDA,X(*),V(*),PAR(*)
      INTEGER IPAR(*),K
C
C PAR(1:*) AND IPAR(1:*) ARE ARRAYS FOR (OPTIONAL) USER PARAMETERS,
C    WHICH ARE SIMPLY PASSED THROUGH TO THE USER WRITTEN SUBROUTINES
C    RHO, RHOJAC.
C
C RETURN IN THE VECTOR  V  THE KTH COLUMN OF THE JACOBIAN
C MATRIX [D RHO/D LAMBDA, D RHO/DX] EVALUATED AT THE POINT
C (A, LAMBDA, X).
C
C THE FOLLOWING CODE IS SPECIFICALLY FOR THE POLYNOMIAL SYSTEM DRIVER
C  POLSYS , AND SHOULD BE USED VERBATUM WITH  POLSYS .  IF THE USER IS
C CALLING  FIXP??  OR   STEP??  DIRECTLY, HE MUST SUPPLY APPROPRIATE
C REPLACEMENT CODE HERE.
      INTEGER J,N,N2
      N=IPAR(1)
      N2=2*N
      IF (K .EQ. 1) THEN
C FORCE PREDICTED POINT TO HAVE  LAMBDA .GE. 0  .
        IF (LAMBDA .LT. 0.0) LAMBDA=0.0
        CALL HFUNP(A,LAMBDA,X,PAR,IPAR)
        DO 10 J=1,N2
          V(J)=PAR(IPAR(3 + (6-1)) + (J-1))
   10   CONTINUE
        RETURN
      ELSE
        DO 20 J=1,N2
          V(J)=PAR(IPAR(3 + (5-1)) + (J-1) + N2*(K-2))
   20   CONTINUE
      ENDIF
C
      RETURN
      END
