(use-package #+allegro :mop
             #+clisp :clos
             #+cmu :clos-mop
             #+lispworks :clos
             #+mcl-common-mop-subset :ccl
             #+sbcl :sb-mop)

(defvar *preliminary-modified-classes* (make-hash-table :test #'equal))

(defun initialize-class-metaobject
       (call-next class metaclass required-superclass
                  &rest initargs
                  &key direct-superclasses
                  &allow-other-keys)
  (declare (dynamic-extent initargs))
  (let ((direct-superclasses (remove required-superclass direct-superclasses))
        (class-key (list class metaclass)))
    (remhash class-key *preliminary-modified-classes*)
    (if (some (lambda (direct-superclass)
                (typep direct-superclass metaclass))
              direct-superclasses)
        (apply call-next class
               :direct-superclasses direct-superclasses
               initargs)
      (progn
        (when (some (lambda (direct-superclass)
                      #-clisp (typep direct-superclass 'forward-referenced-class)
                      #+clisp (symbolp direct-superclass))
                    direct-superclasses)
          (setf (gethash class-key *preliminary-modified-classes*)
                direct-superclasses))
        (apply call-next class
               :direct-superclasses
               (append (remove (find-class 'standard-object)
                               direct-superclasses :test #'eq)
                       (list required-superclass))
               initargs)))))

(defun reinitialize-class-metaobject
       (call-next class metaclass required-superclass
                  &rest initargs
                  &key (direct-superclasses nil direct-superclasses-p)
                  &allow-other-keys)
  (declare (dynamic-extent initargs)
           (ignore direct-superclasses))
  (if direct-superclasses-p
      (apply #'initialize-class-metaobject call-next
             class metaclass required-superclass initargs)
    (let* ((class-key (list class metaclass))
           (org-direct-superclasses (gethash class-key *preliminary-modified-classes*)))
      (if org-direct-superclasses
          (apply #'initialize-class-metaobject call-next
                 class metaclass required-superclass
                 :direct-superclasses org-direct-superclasses initargs)
        (apply call-next class initargs)))))

(defclass myobject (standard-object) ())
(defclass myclass (standard-class) ())

(defmethod validate-superclass ((class myclass) (superclass standard-class)) t)

(defmethod initialize-instance :around
  ((class myclass) &rest args)
  (declare (dynamic-extent args))
  (prog1
      (apply #'initialize-class-metaobject #'call-next-method
             class (find-class 'myclass) (find-class 'myobject)
             args)
    #+clisp (mapc #'reinitialize-instance (class-direct-subclasses class))))

(defmethod reinitialize-instance :around
  ((class myclass) &rest args)
  (declare (dynamic-extent args))
  (prog1
      (apply #'reinitialize-class-metaobject #'call-next-method
             class (find-class 'myclass) (find-class 'myobject)
             args)
    (mapc #'reinitialize-instance (class-direct-subclasses class))))

(defparameter *test-p* t)

(when *test-p*
  (setf (find-class 'test6) nil)
  (setf (find-class 'forward) nil)

  (defclass test1 ()
    ()
    (:metaclass myclass))

  (defclass test2 (test1)
    ()
    (:metaclass myclass))

  (defclass test3 (myobject)
    ()
    (:metaclass myclass))

  (defclass test4 (standard-object)
    ()
    (:metaclass myclass))

  (defclass non-forward () ())

  (defclass test5 (non-forward)
    ()
    (:metaclass myclass))

  (defclass test6 (forward)
    ()
    (:metaclass myclass))

  (defclass forward ()
    ()
    (:metaclass myclass))

  (assert (every (lambda (class-name)
                   (finalize-inheritance (find-class class-name))
                   (typep (class-prototype (find-class class-name))
                          'myobject))
                 '(test1 test2 test3 test4 test5 test6)))

  (assert (every (lambda (class-name-list)
                   (equal (class-direct-superclasses (find-class (car class-name-list)))
                          (mapcar #'find-class (cdr class-name-list))))
                 '((test1 myobject)
                   (test2 test1)
                   (test3 myobject)
                   (test4 myobject)
                   (test5 non-forward myobject)
                   (test6 forward))))

  (print :done))
