;;;;
;;;; AspectL
;;;;
;;;; Copyright (c) 2005 Pascal Costanza
;;;;
;;;; Permission is hereby granted, free of charge, to any person
;;;; obtaining a copy of this software and associated documentation
;;;; files (the "Software"), to deal in the Software without
;;;; restriction, including without limitation the rights to use,
;;;; copy, modify, merge, publish, distribute, sublicense, and/or
;;;; sell copies of the Software, and to permit persons to whom the
;;;; Software is furnished to do so, subject to the following
;;;; conditions:
;;;;
;;;; The above copyright notice and this permission notice shall be
;;;; included in all copies or substantial portions of the Software.
;;;;
;;;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;;;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
;;;; OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;;;; NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
;;;; HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;;;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;;;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;;;; OTHER DEALINGS IN THE SOFTWARE.
;;;;

;;; System definition for LispWorks

(in-package #:cl-user)

(defsystem aspectl ()
  :members ("al-packages" "al-clos-mop" "al-pointcuts" "al-mixins" "al-dynascope"
                          "al-special-class" "al-special-function")
  :rules ((:in-order-to :compile
           ("al-clos-mop" "al-pointcuts" "al-mixins" "al-dynascope"
                          "al-special-class" "al-special-function")
           (:requires (:load "al-packages")))
          (:in-order-to :compile ("al-pointcuts")
           (:requires (:load "al-clos-mop")))
          (:in-order-to :compile ("al-mixins")
           (:requires (:load "al-clos-mop" "al-pointcuts")))
          (:in-order-to :compile ("al-special-class")
           (:requires (:load "al-mixins")))
          (:in-order-to :compile ("al-special-class" "al-special-function")
           (:requires (:load "al-clos-mop" "al-dynascope")))))
