# CiviCRM 4.7.28

Released December 6, 2017

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                     |         |
|:----------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                               |   no    |
| **Change the database schema?**                             | **yes** |
| **Alter the API?**                                          | **yes** |
| Require attention to configuration options?                 |   no    |
| Fix problems installing or upgrading to a previous version? |   no    |
| **Introduce features?**                                     | **yes** |
| **Fix bugs?**                                               | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-16243](https://issues.civicrm.org/jira/browse/CRM-16243) Dependency
  management for extensions
  ([11173](https://github.com/civicrm/civicrm-core/pull/11173) and
  [11101](https://github.com/civicrm/civicrm-core/pull/11101))**

  Extensions can now specify other extensions they depend on.  When enabling an
  extension, the requisite extensions will be automatically enabled first.
  However, for now at least, this does not automatically download those
  extensions.

- **[CRM-20769](https://issues.civicrm.org/jira/browse/CRM-20769) Allow for
  Button Text on profiles to be overriden in settings
  ([10557](https://github.com/civicrm/civicrm-core/pull/10557))**

  You can now enter custom labels for the Save and Cancel buttons on profiles in
  Create or Edit modes.

- **[CRM-21322](https://issues.civicrm.org/jira/browse/CRM-21322) create hook to
  modify entityRef fields
  ([11192](https://github.com/civicrm/civicrm-core/pull/11192))**

  A [new
  hook](https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_alterEntityRefParams/)
  allows extension developers to modify the parameters for entity reference
  fields that appear in a form.

- **[CRM-21195](https://issues.civicrm.org/jira/browse/CRM-21195) Adding the
  ability to add icons to menu items
  ([11054](https://github.com/civicrm/civicrm-core/pull/11054)) (follow-up work)**

  This offers a slight adjustment to the markup for menu item icons.

- **[CRM-21262](https://issues.civicrm.org/jira/browse/CRM-21262) Add a check
  for incorrect Resource URL
  ([11067](https://github.com/civicrm/civicrm-core/pull/11067))**

  A message will now appear on the Status Report if a site's CiviCRM Resource
  URL is set incorrectly.

- **[CRM-20903](https://issues.civicrm.org/jira/browse/CRM-20903) Improve
  ordering of dedupe rules
  ([11109](https://github.com/civicrm/civicrm-core/pull/11109) and
  [11098](https://github.com/civicrm/civicrm-core/pull/11098))**

  Duplicate matching rules are now displayed in a consistent order: first the
  supervised and unsupervised rules, and then the general use rules in
  alphabetical order by title.

- **[CRM-20304](https://issues.civicrm.org/jira/browse/CRM-20304) Add option to
  alphabetize option values
  ([11045](https://github.com/civicrm/civicrm-core/pull/11045))**

  Custom field options can now be alphabetized in one click.

- **[CRM-21179](https://issues.civicrm.org/jira/browse/CRM-21179) Dashlet -
  Charts ([11005](https://github.com/civicrm/civicrm-core/pull/11005))
  (preliminary work)**

  CiviCRM now ships with the dc.js, d3.js, and crossfilter.js libraries.  These
  historically have been provided by the Civisualize extension, but they are now
  available for report developers who don't want the full set of Civisualize
  features.

- **[CRM-21122](https://issues.civicrm.org/jira/browse/CRM-21122) Support
  selection of smart groups on Contact Dashboard
  ([10925](https://github.com/civicrm/civicrm-core/pull/10925))**

  Smart Groups with Public Pages visibility are now available for users to join
  them through the User Dashboard.

- **[CRM-21379](https://issues.civicrm.org/jira/browse/CRM-21379) Fix Activity
  dashlet issues ([11221](https://github.com/civicrm/civicrm-core/pull/11221))**

  The Activities dashlet now has the option to display all activities regardless
  of status.  The default is the legacy behavior of only displaying scheduled
  activities.  Legacy users should note that the default order is reversed, with
  the newest activities displayed first.

- **Hw 390 fixed iframe popup
  ([11075](https://github.com/civicrm/civicrm-core/pull/11075))**

  iframe popups on AngularJS pages now have a default height.

### CiviCase

- **[CRM-20078](https://issues.civicrm.org/jira/browse/CRM-20078) Activity card -
  General ([11159](https://github.com/civicrm/civicrm-core/pull/11159))**

  The "File on case" button is improved so that it does not appear when an
  activity is being viewed in the context of a case.  In addition, when using
  "File on case", the case defaults to an open case for the activity target
  contact if one is available.

### CiviContribute

- **[CRM-20868](https://issues.civicrm.org/jira/browse/CRM-20868),
  [CRM-21480](https://issues.civicrm.org/jira/browse/CRM-21480), and
  [CRM-21479](https://issues.civicrm.org/jira/browse/CRM-21479) set
  invoice_number at contribution->create, not invoice creation
  ([10681](https://github.com/civicrm/civicrm-core/pull/10681),
  [11341](https://github.com/civicrm/civicrm-core/pull/11341), and
  [11321](https://github.com/civicrm/civicrm-core/pull/11321))**

  Every contribution now comes with an invoice number regardless of whether an
  invoice has been generated.

- **[CRM-21354](https://issues.civicrm.org/jira/browse/CRM-21354) Allow
  "Advanced Search" to search for recurring contribution status
  ([11080](https://github.com/civicrm/civicrm-core/pull/11080))**

  Recurring contribution status is now searchable in Advanced Search.

- **[CRM-21346](https://issues.civicrm.org/jira/browse/CRM-21346) Make pledge
  installment count & amount exportable
  ([11194](https://github.com/civicrm/civicrm-core/pull/11194))**

  The number of installments and original installment amount fields for pledges
  are now exportable from the pledge search.

- **[CRM-21287](https://issues.civicrm.org/jira/browse/CRM-21287) Add Financial
  Type to "Contributions by Household" report
  ([11106](https://github.com/civicrm/civicrm-core/pull/11106))**

  The "Contributions by Household" report now has the option to display and/or
  filter by financial type.

### CiviMail

- **[CRM-20919](https://issues.civicrm.org/jira/browse/CRM-20919) Adjust
  Mailing.create api for creating Completed mailings
  ([10707](https://github.com/civicrm/civicrm-core/pull/10707))**

  Completed mailings can now be imported via the API.

- **[CRM-21231](https://issues.civicrm.org/jira/browse/CRM-21231) On CiviMail
  screen make 'Review and Schedule' tab active if required fields are filled
  ([11035](https://github.com/civicrm/civicrm-core/pull/11035))**

  When composing a message in CiviMail, the second tab, "Review and Schedule",
  is disabled at first.  Now, the tab link becomes active when the first tab is
  complete.

- **[CRM-21282](https://issues.civicrm.org/jira/browse/CRM-21282) Improve
  ordering of CiviMail click reporting
  ([11099](https://github.com/civicrm/civicrm-core/pull/11099))**

  The click report summary now orders links by the descending number of clicks.

### Drupal Integration

- **[CRM-21297](https://issues.civicrm.org/jira/browse/CRM-21297) Automatically
  fill database details in installer for Drupal
  ([11113](https://github.com/civicrm/civicrm-core/pull/11113))**

  The database connection fields when installing CiviCRM on Drupal now default
  to the CMS database connection details.  This matches the process on
  WordPress.

### WordPress Integration

- **[CRM-18754](https://issues.civicrm.org/jira/browse/CRM-18754) Process
  extension parameters in shortcodes
  ([112](https://github.com/civicrm/civicrm-wordpress/pull/112))**

  Extensions and WordPress plugins can now process custom parameters in the
  `civicrm` shortcode.

- **[CRM-21212](https://issues.civicrm.org/jira/browse/CRM-21212) Get E2E Tests
  working on wordpress
  ([11017](https://github.com/civicrm/civicrm-core/pull/11017)) (preliminary
  work)**

  A new function retrives the WordPress user ID from a user name.

## <a name="bugs"></a>Bugs resolved

### CiviMail

- **[CRM-21335](https://issues.civicrm.org/jira/browse/CRM-21335) CiviMail
  recipient field isn't marked as required
  ([11185](https://github.com/civicrm/civicrm-core/pull/11185))**

- **[CRM-21508](https://issues.civicrm.org/jira/browse/CRM-21508)
  civicrm_mailing.created_date information passed to Doctor When is incorrect
  ([11361](https://github.com/civicrm/civicrm-core/pull/11361))**

  The mailing date would default to the current timestamp when null.

- **[CRM-21411](https://issues.civicrm.org/jira/browse/CRM-21411) When Sending a
  CiviMail from an advanced search no unsubscribe group field shows
  ([11258](https://github.com/civicrm/civicrm-core/pull/11258))**

- **[CRM-21284](https://issues.civicrm.org/jira/browse/CRM-21284) Outdated link
  to mail setup documentation
  ([11104](https://github.com/civicrm/civicrm-core/pull/11104))**

- **[CRM-20892](https://issues.civicrm.org/jira/browse/CRM-20892) Same mailing
  open in two windows can overwrite data on scheduled mailings
  ([10965](https://github.com/civicrm/civicrm-core/pull/10965))**

- **[CRM-21362](https://issues.civicrm.org/jira/browse/CRM-21362) Mailing
  summary report group by MySQL 5.7 error
  ([11206](https://github.com/civicrm/civicrm-core/pull/11206))**

- **[CRM-20397](https://issues.civicrm.org/jira/browse/CRM-20397) CiviMail send
  immediately date/time check too sensitive
  ([11093](https://github.com/civicrm/civicrm-core/pull/11093) and
  [11092](https://github.com/civicrm/civicrm-core/pull/11092))**

  Users would get errors that they were attempting to schedule mailings in the
  past.

### Core CiviCRM

- **[CRM-21275](https://issues.civicrm.org/jira/browse/CRM-21275) Fatal error
  without message should recommend bug-reporting page, instead of deprecated
  forum ([11084](https://github.com/civicrm/civicrm-core/pull/11084))**

- **[CRM-21336](https://issues.civicrm.org/jira/browse/CRM-21336) Custom file
  fields should display file name without hash
  ([11166](https://github.com/civicrm/civicrm-core/pull/11166))**

- **[CRM-21268](https://issues.civicrm.org/jira/browse/CRM-21268) Missing French
  overseas departments.
  ([11076](https://github.com/civicrm/civicrm-core/pull/11076))**

  The French overseas departments Wallis-et-Futuna and Nouvelle-Calédonie are
  now available in the State/Province list.

- **[CRM-21481](https://issues.civicrm.org/jira/browse/CRM-21481) 4.7.28-rc:
  needs to call rebuildMultilingualSchema()
  ([11322](https://github.com/civicrm/civicrm-core/pull/11322))**

  The introduction of multilingual columns means that the multilingual schema
  must be rebuilt.  Otherwise, multilingual sites will encounter an error when
  upgrading.

- **[CRM-21363](https://issues.civicrm.org/jira/browse/CRM-21363) and
  [CRM-21455](https://issues.civicrm.org/jira/browse/CRM-21455) Ensure that
  tests run using ONLY_FULL_GROUP_BY sql_mode for mysql 5.7
  ([11249](https://github.com/civicrm/civicrm-core/pull/11249),
  [10934](https://github.com/civicrm/civicrm-core/pull/10934),
  [11339](https://github.com/civicrm/civicrm-core/pull/11339), and
  [11346](https://github.com/civicrm/civicrm-core/pull/11346))**

- **[CRM-21364](https://issues.civicrm.org/jira/browse/CRM-21364) Fix Tests
  which fail on ONLY_FULL_GROUP_BY
  ([11229](https://github.com/civicrm/civicrm-core/pull/11229),
  [11219](https://github.com/civicrm/civicrm-core/pull/11219), and
  [11209](https://github.com/civicrm/civicrm-core/pull/11209))**

  This resolves a variety of problems that may occur if the MySQL `sql_mode` is
  set to `ONLY_FULL_GROUP_BY`.

- **[CRM-21388](https://issues.civicrm.org/jira/browse/CRM-21388) Extension Page
  should only throw exception if key is set
  ([11234](https://github.com/civicrm/civicrm-core/pull/11234))**

  When checking that an extension's key follows the expected standard, the
  extension page should not throw an exception if the key is blank or missing.

- **[CRM-20934](https://issues.civicrm.org/jira/browse/CRM-20934) Child groups
  not present in group list selector
  ([10717](https://github.com/civicrm/civicrm-core/pull/10717))**

  This resolves a problem where having a disabled parent group would prevent a
  group from appearing in a group selection field even if another parent group
  is active.

- **[CRM-21351](https://issues.civicrm.org/jira/browse/CRM-21351) Contact
  deceased date does not respect the localisation date format
  ([11200](https://github.com/civicrm/civicrm-core/pull/11200))**

- **[CRM-21306](https://issues.civicrm.org/jira/browse/CRM-21306) DoctorWhen
  extension looses the comments from columns when converting
  ([11129](https://github.com/civicrm/civicrm-core/pull/11129))**

  When replacing columns to resolve date fields, Doctor When now restores the
  field comments to the database.

- **[CRM-21337](https://issues.civicrm.org/jira/browse/CRM-21337) ISO compliance
  for Romanian and Bulgarian counties
  ([11168](https://github.com/civicrm/civicrm-core/pull/11168))**

  This fixes the spelling of a Bulgarian province and a number of Romanian
  counties in the state/province list.

- **[CRM-21283](https://issues.civicrm.org/jira/browse/CRM-21283) Incorporate
  Barbados and Antigua and Barbuda Parishes into States list
  ([11100](https://github.com/civicrm/civicrm-core/pull/11100))**

  This adds parishes of Barbados and Antigua and Barbuda to the state/province
  list.

- **[CRM-21267](https://issues.civicrm.org/jira/browse/CRM-21267) Error 500 -
  Call to undefined method CRM_Contact_Import_Parser::formatCustomDate
  ([11124](https://github.com/civicrm/civicrm-core/pull/11124))**

  Some code reorganization resulted in a method being called from within the
  wrong class during import of custom date fields, resulting in a fatal error.
  This calls it correctly.

- **Navigation - Fix serialization error
  ([11107](https://github.com/civicrm/civicrm-core/pull/11107))**

- **[CRM-19346](https://issues.civicrm.org/jira/browse/CRM-19346) gender_id
  uniqueness not enforced on option groups edit form
  ([11089](https://github.com/civicrm/civicrm-core/pull/11089))**

  Now each value in an option group must be unique.

- **[CRM-21214](https://issues.civicrm.org/jira/browse/CRM-21214) Chaining
  shared addresses doesn't work correctly
  ([11019](https://github.com/civicrm/civicrm-core/pull/11019))**

  This prevents complex address inheritance cases such as second-degree address
  sharing and recursive address sharing.

- **[CRM-20779](https://issues.civicrm.org/jira/browse/CRM-20779) Incorrect
  files showing in Tab for custom field
  ([11082](https://github.com/civicrm/civicrm-core/pull/11082))**

  On file custom fields in multiple-entry custom data sets, the first entry's
  file would display for all entries.

- **[CRM-20468](https://issues.civicrm.org/jira/browse/CRM-20468)
  Attachment.create API HTML escapes the uploaded content
  ([10876](https://github.com/civicrm/civicrm-core/pull/10876))**

- **[CRM-19620](https://issues.civicrm.org/jira/browse/CRM-19620) importing
  record with external_identifier that matches with a deleted contact results in
  traceback ([11133](https://github.com/civicrm/civicrm-core/pull/11133))**

  Now the External ID value is stripped from the contact in the trash and a new
  contact is created.

- **[CRM-20545](https://issues.civicrm.org/jira/browse/CRM-20545) contact report
  lists contacts that have been 'soft' deleted (placed in Trash)
  ([11136](https://github.com/civicrm/civicrm-core/pull/11136))**

- **[CRM-21303](https://issues.civicrm.org/jira/browse/CRM-21303) Dedupe
  datatable incorrectly calculates rows
  ([11121](https://github.com/civicrm/civicrm-core/pull/11121))**

  This fixes a problem where no more than 25 rows would display on the conflicts
  screen.

- **[CRM-21294](https://issues.civicrm.org/jira/browse/CRM-21294) js error when
  selecting & unselecting merge contacts
  ([11117](https://github.com/civicrm/civicrm-core/pull/11117))**

- **[CRM-21246](https://issues.civicrm.org/jira/browse/CRM-21246) Problem
  'double chaining', e.g. Contact.get - Relationship.get - Contact.get
  ([11056](https://github.com/civicrm/civicrm-core/pull/11056))**

  This fixes problems due to ambiguity of the `value` syntax when using API
  chaining inside another chained API call.

- **[CRM-21258](https://issues.civicrm.org/jira/browse/CRM-21258) Display name
  fatal error if names are too long
  ([11063](https://github.com/civicrm/civicrm-core/pull/11063))**

  Display name and sort name will now be truncated rather than cause a fatal
  error if the length is too long.

### CiviMember

- **[CRM-21321](https://issues.civicrm.org/jira/browse/CRM-21321) Membership
  fields not loading in 'On behalf of' profile
  ([11148](https://github.com/civicrm/civicrm-core/pull/11148))**

  You can now add membership fields to the profile for contributions on behalf
  of an organization, and they will display in the on-behalf section of the
  contribution page.

- **[CRM-20227](https://issues.civicrm.org/jira/browse/CRM-20227) Regression -
  Membership status override gets 'stuck'
  ([11188](https://github.com/civicrm/civicrm-core/pull/11188))**

  This resolves a bug that would keep the membership status set by a status
  override when the override was disabled.

- **[CRM-20955](https://issues.civicrm.org/jira/browse/CRM-20955) Contact's
  second membership fails to inherit when created in back end using price set
  ([11184](https://github.com/civicrm/civicrm-core/pull/11184)) (follow-up)**

  Test coverage was added.

- **[CRM-19998](https://issues.civicrm.org/jira/browse/CRM-19998) Membership
  start / end date have no effect in Search Builder
  ([11134](https://github.com/civicrm/civicrm-core/pull/11134))**

- **[CRM-20432](https://issues.civicrm.org/jira/browse/CRM-20432) Pending
  Contributions which have a Payment recorded and are Completed do not trigger
  the related Membership to become current, status remains pending
  ([11125](https://github.com/civicrm/civicrm-core/pull/11125))**

- **[CRM-19060](https://issues.civicrm.org/jira/browse/CRM-19060) Membership
  Detailed Report Payment Amount (most recent) not reporting correct
  contribution ([8837](https://github.com/civicrm/civicrm-core/pull/8837))**

### CiviCase

- **[CRM-21367](https://issues.civicrm.org/jira/browse/CRM-21367) Get help
  section out of container
  ([11096](https://github.com/civicrm/civicrm-core/pull/11096),
  [11156](https://github.com/civicrm/civicrm-core/pull/11156), and
  [11220](https://github.com/civicrm/civicrm-core/pull/11220))**

  Help text on the case types screens is now outside of the CiviCRM content
  block.

- **[CRM-21373](https://issues.civicrm.org/jira/browse/CRM-21373) Notice error
  on creating cases
  ([11217](https://github.com/civicrm/civicrm-core/pull/11217))**

  This resolves a PHP notice that would appear upon creating a case.

- **[CRM-21255](https://issues.civicrm.org/jira/browse/CRM-21255) Error when
  downloading document from case activity
  ([11186](https://github.com/civicrm/civicrm-core/pull/11186))**

  This resolves a bug in CiviCase 5.0 (org.civicrm.civicase) when printing a
  case document.

- **HW-380: Remove spacer div
  ([11071](https://github.com/civicrm/civicrm-core/pull/11071))**

  This makes a slight adjustment to the case type editing form.

### CiviContribute

- **[CRM-21062](https://issues.civicrm.org/jira/browse/CRM-21062) Remove Tax
  Rate trailing zeros for display in Confirm / Thankyou forms
  ([10856](https://github.com/civicrm/civicrm-core/pull/10856))**

  This resolves a bug where tax rates would always display 8 decimal places on
  contribution page confirmation and thank-you pages.

- **[CRM-21436](https://issues.civicrm.org/jira/browse/CRM-21436) Fatal error on
  contribution page with only pay later enabled.
  ([11286](https://github.com/civicrm/civicrm-core/pull/11286))**

- **Fix Recurring contribution sql so that it doesen't use group by as there
  doesn't appear to be a reason to do so given that we have a where id = x
  clause and we were grouping on the same field
  ([11231](https://github.com/civicrm/civicrm-core/pull/11231))**

  This resolves a test failure on retrieving the related contact for a recurring
  contribution.

- **[CRM-21340](https://issues.civicrm.org/jira/browse/CRM-21340) make "view my
  invoices" permission cms agnostic
  ([11172](https://github.com/civicrm/civicrm-core/pull/11172))**

  This removes the use of a Drupal-specific global when checking permissions to
  download an invoice.

- **[CRM-21305](https://issues.civicrm.org/jira/browse/CRM-21305) Sorting not
  working on Batch listing page
  ([11127](https://github.com/civicrm/civicrm-core/pull/11127))**

- **[CRM-21281](https://issues.civicrm.org/jira/browse/CRM-21281) Post Hook for
  LineItem does not receive entity_id and entity_table
  ([11108](https://github.com/civicrm/civicrm-core/pull/11108) and
  [11097](https://github.com/civicrm/civicrm-core/pull/11097))**

  When editing a line item, `hook_civicrm_post` now specifies the ID and table
  of the line item that was modified.

- **[CRM-20772](https://issues.civicrm.org/jira/browse/CRM-20772) Price set
  calculation precision when sales tax enabled
  ([11016](https://github.com/civicrm/civicrm-core/pull/11016)) (initial work)**

  This adds additional decimal places for a price field value's amount field and
  a membership type's minimum fee field in order to accommodate future changes.

- **[CRM-20572](https://issues.civicrm.org/jira/browse/CRM-20572) Remove
  jcalendar from Contrib Sybunt custom Search
  ([10355](https://github.com/civicrm/civicrm-core/pull/10355))**

  This removes a deprecated library.

- **[CRM-21319](https://issues.civicrm.org/jira/browse/CRM-21319) Total Amount
  not translated on Contribution Page
  ([11147](https://github.com/civicrm/civicrm-core/pull/11147))**

### CiviEvent

- **[CRM-21149](https://issues.civicrm.org/jira/browse/CRM-21149) On Event
  Registration Form, cannot target the text "(including yourself)" using word
  replacement because the parenthesis is outside the ts markers
  ([10942](https://github.com/civicrm/civicrm-core/pull/10942))**

- **[CRM-21339](https://issues.civicrm.org/jira/browse/CRM-21339) Fix fatal js
  error on cart checkout when pay later not enabled
  ([11170](https://github.com/civicrm/civicrm-core/pull/11170))**

- **[CRM-21009](https://issues.civicrm.org/jira/browse/CRM-21009) Removing event
  selection from participant does not free up capacity
  ([10805](https://github.com/civicrm/civicrm-core/pull/10805))**

- **[CRM-21327](https://issues.civicrm.org/jira/browse/CRM-21327) Not able to
  change Payment Processor in event fees
  ([11153](https://github.com/civicrm/civicrm-core/pull/11153))**

  The field to choose payment processors on events was different from the
  corresponding setting for contribution pages.  This makes the two consistent,
  including handling permissions accurately.

### Drupal Integration Modules

- **[CRM-21374](https://issues.civicrm.org/jira/browse/CRM-21374) D8 footer
  resources get added to the header
  ([11218](https://github.com/civicrm/civicrm-core/pull/11218))**

  Items added to the `page-footer` region would appear in the header in Drupal 8
  sites.

- **[CRM-21371](https://issues.civicrm.org/jira/browse/CRM-21371) An api error
  when calling drush cvapi should be treated as a drush error
  ([503](https://github.com/civicrm/civicrm-drupal/pull/503))**

- **[CRM-21132](https://issues.civicrm.org/jira/browse/CRM-21132) Member Role
  Sync: civicrm_member_roles produces a Fatal "unknown error" when one hits
  Manually Synchronize
  ([494](https://github.com/civicrm/civicrm-drupal/pull/494))**

- **[CRM-21272](https://issues.civicrm.org/jira/browse/CRM-21272) CMSUser has
  Drupal 6/7 code that breaks when using with Drupal 8
  ([11145](https://github.com/civicrm/civicrm-core/pull/11145),
  [11139](https://github.com/civicrm/civicrm-core/pull/11139), and
  [11079](https://github.com/civicrm/civicrm-core/pull/11079))**

  Code to determine if user registration is permitted is now handled in the
  `CRM_Utils_System` classes.

- **[CRM-19995](https://issues.civicrm.org/jira/browse/CRM-19995) Notice :
  Undefined offset: 5 dans _civicrm_member_roles_sync()
  ([500](https://github.com/civicrm/civicrm-drupal/pull/500))**

  This fixes a typo in the member role sync module that led to a PHP notice.

### Joomla Integration

- **[CRM-21203](https://issues.civicrm.org/jira/browse/CRM-21203) cli.php PHP
  error prevents cron jobs from running
  ([11062](https://github.com/civicrm/civicrm-core/pull/11062))**

  Changes in Joomla 3.8--along with difficulties in detecting the Joomla
  version--prevented cron from executing on many Joomla sites.

## <a name="misc"></a>Miscellany

- **[CRM-20710](https://issues.civicrm.org/jira/browse/CRM-20710) Add function
  to return all valid types
  ([10486](https://github.com/civicrm/civicrm-core/pull/10486))**

- **[CRM-21291](https://issues.civicrm.org/jira/browse/CRM-21291) Confirm this
  code is not used & remove
  ([11116](https://github.com/civicrm/civicrm-core/pull/11116))**

- **[CRM-21249](https://issues.civicrm.org/jira/browse/CRM-21249) Google Geocode
  limit breaks Jenkins test
  ([11058](https://github.com/civicrm/civicrm-core/pull/11058))**

- **[CRM-12167](https://issues.civicrm.org/jira/browse/CRM-12167) Add support
  for admin-only fee / price field value options
  ([11073](https://github.com/civicrm/civicrm-core/pull/11073)) (related
  cleanup)**

  This change regenerates the DAO checksum.

- **[nfc] Fix missing comma for phpcs
  ([11119](https://github.com/civicrm/civicrm-core/pull/11119))**

- **(NFC) Add in test of current practice in updating multiselect custom data
  ([11081](https://github.com/civicrm/civicrm-core/pull/11081))**

- **Civilint views components files
  ([482](https://github.com/civicrm/civicrm-drupal/pull/482))**

- **Civilint 2nd half of civicrm_handler_field files
  ([486](https://github.com/civicrm/civicrm-drupal/pull/486))**

- **Run civilint against civicrm_handler_filter_state_multi.inc
  ([488](https://github.com/civicrm/civicrm-drupal/pull/488))**

- **Run Civilint against civicrm_engage module
  ([493](https://github.com/civicrm/civicrm-drupal/pull/493))**

- **Run Civilint against the rest of views_handler and views plugin files
  ([487](https://github.com/civicrm/civicrm-drupal/pull/487))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Alok Patel, Justin
Freeman; Australian Greens - Seamus Lee; Christian Wach; Circle Interactive -
Dave Jenkins; CiviCoop - Klaas Eikelboom; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Nicolas Ganivet, Yashodha Chaku; CiviFirst - John Kirk; Community IT
Academy - William Mortada; CompuCorp - Michael Devery, Mukesh Ram, Omar Abu
Hussein; Coop SymbioTIC - Mathieu Lutfy; Daniël van Vuuren; Deepak Srivastava;
Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; JMA
Consulting - Edsel Lopez, Monish Deb, Pradeep Nayak; John Kingsnorth; Joinery -
Allen Shaw; Lemniscus - Noah Miller; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Olivier Hertrich; Pawel Nowak; PowDevel -
Beto Aveiga; Progressive Technology Project - Jamie McClelland; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton, Maggie
Epps

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Adam Zilkie; AGH Strategies - Josh Corlew; Agileware - Agileware Team; Andrew
Thompson; Blackfly Solutions - Alan Dixon; British Humanist Association -
William Gordon; CiviDesk - Sunil Pawar; CompuCorp - Anna Kovalova, Guanhuan
Chen, Mirela Stanila; DevMate - Adam Kwiatkowski; Effy Elden; Electronic
Frontier Foundation - Mark Burdett; Ginkgo Street Labs - Frank Gómez; JMA
Consulting - Joe Murray; Joanne Chester; Johan Vervloet; Jonathan Richardson;
Korlon - Stuart Gaston; Left Join Labs - Sean Madsen; Levity - Kevin Levie;
Lighthouse Design and Consulting - Brian Shaughnessy; Lorenzo Ardizzone; MC3 -
Graham Mitchell; Marcello Gribaudo; Mohamed Ziada; myDropWizard - David Snopek;
Neil Zampella; Nicol Wistreich; Responsive Development Technologies - Thomas
Nilefalk; Richard Edgar; Semper IT - Karin Gerritsen; SEN Magazine - Jeremy
Nicholls; Skvare - Mark Hanna; small biz; Spry Digital - Ellen Hendricks;
Squiffle Consulting - Aidan Saunders; Stevel; Systopia - Björn Endres; Tech To
The People - Xavier Dutoit; Victor Huang; Web Access - Kurund Jalmi

## <a name="feedback"></a>Feedback

These release notes are edited by Andrew Hunt.  If you'd like to provide
feedback on them, please login to https://chat.civicrm.org/civicrm and contact
`@agh1`.
