# CiviCRM 5.35.0

Released March 3, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Improve activity import to support updates (Work Towards
  [dev/core#2308](https://lab.civicrm.org/dev/core/-/issues/2308):
  [19439](https://github.com/civicrm/civicrm-core/pull/19439))**

  Ensures when importing activities, activity fields are not required if the
  activity id is present, so that one can update existing activities via import.

- **Proposal - make 5.33 the last CiviCRM version to support php 7.1 (agreed)
  and mysql 5.6 (deferred) (& equivalent MariaDB version) (Work Towards
  [dev/core#2204](https://lab.civicrm.org/dev/core/-/issues/2204):
  [126](https://github.com/civicrm/civicrm-backdrop/pull/126),
  [637](https://github.com/civicrm/civicrm-drupal/pull/637),
  [238](https://github.com/civicrm/civicrm-wordpress/pull/238) and
  [19390](https://github.com/civicrm/civicrm-core/pull/19390))**

  Update the minimum php install version to be 7.2.

- **Add explicit box-sizing to crm-flex-box style
  ([19325](https://github.com/civicrm/civicrm-core/pull/19325))**

  Ensures consistent box sizing when using the new `crm-flex-box` css class,
  for consistency with or without Bootstrap 3.

- **Search-kit - better user experience for bulk updates
  ([dev/core#2310](https://lab.civicrm.org/dev/core/-/issues/2310):
  [19425](https://github.com/civicrm/civicrm-core/pull/19425))**

  Adds a batch system to search kit. This avoids server timeouts, and improves
  the user experience.

- **Searchkit - separate calls for results & count
  ([dev/core#2312](https://lab.civicrm.org/dev/core/-/issues/2312):
  [19426](https://github.com/civicrm/civicrm-core/pull/19426))**

  Improves SearchKit results loading time in the admin UI.

- **Searchkit - activity record type not intuitive
  ([dev/core#2313](https://lab.civicrm.org/dev/core/-/issues/2313):
  [19429](https://github.com/civicrm/civicrm-core/pull/19429))**

  Makes joins in SearchKit more intuitive by automatically adding commonly-used
  default conditions.

- **SearchKit: Add support for multi-record custom field groups
  ([19452](https://github.com/civicrm/civicrm-core/pull/19452))**

  Adds support in SearchKit for multi-record custom field group pseudo-entities
  to be added to the search as joins.

- **Modifying lists of Country/StateProvince/County (Work Towards
  [dev/core#2329](https://lab.civicrm.org/dev/core/-/issues/2329):
  [19448](https://github.com/civicrm/civicrm-core/pull/19448))**

  Adds an `is_active` field to Country, StateProvince and County elements so
  that they can be disabled.

- **APIv4 - Enable getFields to find fields across implicit FK joins
  ([19516](https://github.com/civicrm/civicrm-core/pull/19516))**

  Makes it possible to return fields from other entities using APIv4.

- **Add v4 pledge api
  ([19297](https://github.com/civicrm/civicrm-core/pull/19297))**

  Adds the Pledge entity to APIv4.

- **Add pledge payment api
  ([19436](https://github.com/civicrm/civicrm-core/pull/19436))**

  Adds the Pledge Payment entity to APIv4.

- **Payment API - Add description of `order_reference` parameter
  ([19449](https://github.com/civicrm/civicrm-core/pull/19449))**

  Adds a spec for the `Payment.order_reference` parameter so that is shows up in
  the API explorer and is a little more discoverable.

- **API Explorer - Fix URL encoding in REST examples
  ([19450](https://github.com/civicrm/civicrm-core/pull/19450))**

  Improves the REST examples generated in "Support => Developer => Api Explorer
  v3".

- **Search Builder - Enhance UI with Select2 and EntityRef
  ([19471](https://github.com/civicrm/civicrm-core/pull/19471))**

  Improves the UI of Search Builder (the classic one in core, not the new Search
  Kit extension) by using Select2 dropdowns for selecting options &
  autocompleting contacts, events, etc instead of needing to enter numeric ids.

- **Add "label_field" metadata to entities
  ([19504](https://github.com/civicrm/civicrm-core/pull/19504) and
  [19546](https://github.com/civicrm/civicrm-core/pull/19546))**

  Adds a "label_field" metadata to the schema for entities so that one can know
  how a entity should be displayed by looking at the metadata.

- **Select2 - Improve styles for disabled, loading elements
  ([19430](https://github.com/civicrm/civicrm-core/pull/19430))**

  Improves Select2 user experience in Greenwich.

- **Tabbed interface for organizing afforms by type
  ([19395](https://github.com/civicrm/civicrm-core/pull/19395))**

  Creates afform types and a tabbed interface in the Admin section, and adds
  support for embedding search displays into afform fieldsets.

- **Add setting default to speed up cache flush
  ([19383](https://github.com/civicrm/civicrm-core/pull/19383))**

  Adds a define to civicrm.settings.php that speeds up cache flushes

- **Add pseudoconstant for Relationship.relationship_type_id
  ([19278](https://github.com/civicrm/civicrm-core/pull/19278))**

  Updates the relationship schema to add a pseudoconstant to the
  relationship_type_id field.

### CiviContribute

- **Unhide contributioncancelactions core extension
  ([19500](https://github.com/civicrm/civicrm-core/pull/19500))**

  Makes the Contributioncancelactions extension visible and disabling it
  supported.

### CiviMail

- **Support tracking URLs with tokens in query strings
  ([dev/mail#81](https://lab.civicrm.org/dev/mail/-/issues/81):
  [19386](https://github.com/civicrm/civicrm-core/pull/19386))**

  When delivering a mail-blast, Flexmailer replaces most URLs with trackable
  URLs. This expands tracking support for URLs that include tokens.

### Drupal Integration

- **allow filtering by empty event end, registration start, registration end
  dates ([634](https://github.com/civicrm/civicrm-drupal/pull/634))**

  Makes it possible to filter by empty event date fields in views.

- **Advice in failure message is out of date
  ([633](https://github.com/civicrm/civicrm-drupal/pull/633))**

  Improves error message when unable to load CRM/Core/Config.php.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **search on relationship and case
  ([18779](https://github.com/civicrm/civicrm-core/pull/18779))**

  Ensures Advanced search filters correctly when displaying related contacts and
  searching with case parameters.

- **Don't check for .git in the isDevelopment() function
  ([dev/core#2241](https://lab.civicrm.org/dev/core/-/issues/2241):
  [19361](https://github.com/civicrm/civicrm-core/pull/19361))**

  Deprecates direct calls to `isDevelopment()`.

- **Adding Contacts to a New Group via Manage Groups Page Failure
  ([dev/core#2333](https://lab.civicrm.org/dev/core/-/issues/2333):
  [19472](https://github.com/civicrm/civicrm-core/pull/19472))**

  Fixes an issue when creating a group from a letter page of search results.

- **Oauth Redirect URL reporterror_civicrm_handler
  ([dev/core#2350](https://lab.civicrm.org/dev/core/-/issues/2350):
  [19492](https://github.com/civicrm/civicrm-core/pull/19492))**

  Ensures when using the Oauth extension, setting a fatalErrorHandler does not
  override the redirect url.

- **Search Kit: Search kit, contribution search - financial type field is odd
  ([dev/core#2349](https://lab.civicrm.org/dev/core/-/issues/2349) and
  [dev/core#2347](https://lab.civicrm.org/dev/core/-/issues/2347):
  [19489](https://github.com/civicrm/civicrm-core/pull/19489))**

  Fixes two SearchKit bugs:

    - Contribution Search, financial type return empty
    - Preview button on table display form not working

- **Afform - Misc tweaks, validation & bug fixes
  ([19496](https://github.com/civicrm/civicrm-core/pull/19496))**

  Adds basic validation to server_route in the Afform GUI, only permitting
  paths beginning with "civicrm/". Also re-labels the menu item and page
  title to "Form Builder" and resets server_route and is_dashlet when cloning.
  And fixes several bugs in Afform & Search Kit.

- **Afform - Fix form submit button
  ([19460](https://github.com/civicrm/civicrm-core/pull/19460))**

  Ensures clicking Submit on an afform actually submits the form.

- **Afform GUI enhancements & Search Kit integration
  ([19455](https://github.com/civicrm/civicrm-core/pull/19455))**

  Fixes errors in afform GUI when creating a new block from the admin screen and
  when clicking "Save as Block"

- **Afform - Drop directive support for attribute, only support elements as
  afforms ([19438](https://github.com/civicrm/civicrm-core/pull/19438) and
  [19670](https://github.com/civicrm/civicrm-core/pull/19670))**

  Afform no longer responds to attributes set for standard HTML elements; you
  must use a special element to invoke an Afform.

- **Greenwich - fix list margin added by some CMS themes
  ([19423](https://github.com/civicrm/civicrm-core/pull/19423))**

  Fixes a style conflict between some CMS themes and Greenwich, causing tabs to
  shift to the right.

- **Flag that Embedded Activity Revisions setting is unsupported and deprecated
  ([19422](https://github.com/civicrm/civicrm-core/pull/19422))**

  Adds more documentation to the 'Enable Embedded Activity Revisions' setting to
  make it explicit that it is deprecated.

- **Use php to require an array
  ([19370](https://github.com/civicrm/civicrm-core/pull/19370))**

  Removes is_array check in favor of php strict typing.

- **Fix rendering of Dashlet placeholder
  ([dev/core#2306](https://lab.civicrm.org/dev/core/-/issues/2306):
  [19413](https://github.com/civicrm/civicrm-core/pull/19413))**

  Prevents panel jumping when dragging dashlets.

- **Dashboard: Improve status messages when moving/deleting dashlets
  ([19358](https://github.com/civicrm/civicrm-core/pull/19358))**

  Ensures a in-progress message is displayed when moving/deleting dashlets.

- **Using %1%2 in ts() generates confusing output in transifex
  ([dev/translation#64](https://lab.civicrm.org/dev/translation/-/issues/64):
  [19453](https://github.com/civicrm/civicrm-core/pull/19453))**

- **Upgrader (5.34) - Handle unsavable characters in decoded SMTP password
  ([19711](https://github.com/civicrm/civicrm-core/pull/19711))**

  This resolves upgrade problems as older sites upgrade through 5.34.0, have
  encrypted SMTP credentials, and have 8-bit characters.

- **Issue with importing to checkbox type fields where label is the same as
  database value (may affect other types too)
  ([dev/core#866](https://lab.civicrm.org/dev/core/-/issues/866) and
  [dev/core#1318](https://lab.civicrm.org/dev/core/-/issues/1318):
  [19111](https://github.com/civicrm/civicrm-core/pull/19111))**

- **Logging tables shown as 'different' incorrectly after upgrading to MariaDB
  10.4.x ([dev/core#2305](https://lab.civicrm.org/dev/core/-/issues/2305):
  [19412](https://github.com/civicrm/civicrm-core/pull/19412))**

- **Mapping a contact gives invalid argument supplied.
  ([dev/core#2307](https://lab.civicrm.org/dev/core/-/issues/2307):
  [19414](https://github.com/civicrm/civicrm-core/pull/19414))**

- **Inconsistent line breaks on custom field edit page for description text
  ([dev/core#2328](https://lab.civicrm.org/dev/core/-/issues/2328):
  [19444](https://github.com/civicrm/civicrm-core/pull/19444))**

- **Creating an afform without civicrm/ in the url breaks the site
  ([dev/core#2340](https://lab.civicrm.org/dev/core/-/issues/2340):
  [19464](https://github.com/civicrm/civicrm-core/pull/19464))**

- **Afform api explorer: has_local, has_base do not present as bool
  ([dev/core#2341](https://lab.civicrm.org/dev/core/-/issues/2341):
  [19465](https://github.com/civicrm/civicrm-core/pull/19465))**

- **APIv4 - Fix bug when using relative date filters in ON clause of a join
  ([19514](https://github.com/civicrm/civicrm-core/pull/19514))**

- **Search Kit - Fix display pager and improve error handling
  ([19479](https://github.com/civicrm/civicrm-core/pull/19479))**

- **Afform - delete unused, nonfunctional apis
  ([19432](https://github.com/civicrm/civicrm-core/pull/19432))**

- **Afform GUI - Fix errors when creating & saving blocks
  ([19519](https://github.com/civicrm/civicrm-core/pull/19519))**

- **Greenwich: Fix BS3 conflict with html5 search clear button
  ([19461](https://github.com/civicrm/civicrm-core/pull/19461))**

- **Move require once in api kernel to support edge cases
  ([19513](https://github.com/civicrm/civicrm-core/pull/19513))**

- **Token Processor: fix PHP syntax for purifyHTML
  ([19490](https://github.com/civicrm/civicrm-core/pull/19490))**

- **Do not set source_contact_id in summary function
  ([19456](https://github.com/civicrm/civicrm-core/pull/19456))**

- **Fix missing translate tag
  ([19451](https://github.com/civicrm/civicrm-core/pull/19451))**

- **composer.json - Ignore unused variants of Monaco ("dev"/"esm")
  ([19433](https://github.com/civicrm/civicrm-core/pull/19433))**

- **"Admin => Misc" - Fix validation of "Maximum File Size"
  ([19382](https://github.com/civicrm/civicrm-core/pull/19382))**

- **Fix Redis deprecated warning
  ([19593](https://github.com/civicrm/civicrm-core/pull/19593))**

- **SearchKit : use of rows in query cause mysql errors
  ([dev/core#2360](https://lab.civicrm.org/dev/core/-/issues/2360):
  [19653](https://github.com/civicrm/civicrm-core/pull/19653))

- **Decimal Separator - Incorrect format in some views and editions
  ([dev/core#2394](https://lab.civicrm.org/dev/core/-/issues/2394):
  [19685](https://github.com/civicrm/civicrm-core/pull/19685) and
  [19692](https://github.com/civicrm/civicrm-core/pull/19692))**

- **Account IIF Export Amount Format improper
  ([dev/financial#166](https://lab.civicrm.org/dev/financial/-/issues/166):
  [19680](https://github.com/civicrm/civicrm-core/pull/19680))**

  This resolves inconsistency in the money formatting where the currency symbol
  would be added inappropriately.

- **Some Multi-Select Custom Fields cannot be saved
  ([dev/core#2423](https://lab.civicrm.org/dev/core/-/issues/2423):
  [19698](https://github.com/civicrm/civicrm-core/pull/19698))**

  This resolves the problem that multi-select fields with integer, number, or
  money data types could not have data stored in them.

- **Dashboard Query failed to detect existing record for contact
  ([dev/core#2426](https://lab.civicrm.org/dev/core/-/issues/2426):
  [19694](https://github.com/civicrm/civicrm-core/pull/19694))**

  This resolves a crash on the CiviCRM dashboard if a user lacks the permission
  to view their own contact.

### CiviCase

- **Custom Field of type Integer that uses Radio Buttons as Input Type in
  combination with search range scrambles Case Report Search
  ([dev/core#2288](https://lab.civicrm.org/dev/core/-/issues/2288):
  [19339](https://github.com/civicrm/civicrm-core/pull/19339))**

- **Upgrading an old site with spaces in the case type names and external xml
  files leads to difficult to resolve status messages
  ([dev/core#2326](https://lab.civicrm.org/dev/core/-/issues/2326):
  [19441](https://github.com/civicrm/civicrm-core/pull/19441))**

- **Sample xml casetype configuration files have label instead of name in the
  name ([dev/core#2327](https://lab.civicrm.org/dev/core/-/issues/2327):
  [19442](https://github.com/civicrm/civicrm-core/pull/19442))**

- **Use exceptions when enabling case component / checking for 'CREATE VIEW'
  permissions ([19503](https://github.com/civicrm/civicrm-core/pull/19503))**

### CiviContribute

- **Fix pledge action on failed/ cancelled contribution
  ([dev/core#2206](https://lab.civicrm.org/dev/core/-/issues/2206):
  [19289](https://github.com/civicrm/civicrm-core/pull/19289))**

  Ensures that Pledge payments are correctly updated when a contribution is
  cancelled or fails.

- **Undefined index when putting in a contribution thank-you date without a time
  ([dev/core#2297](https://lab.civicrm.org/dev/core/-/issues/2297):
  [19388](https://github.com/civicrm/civicrm-core/pull/19388))**

- **Cannot edit contribution with revenue recognition date in a past year
  ([dev/financial#164](https://lab.civicrm.org/dev/financial/-/issues/164):
  [19454](https://github.com/civicrm/civicrm-core/pull/19454))**

- **Notice: Undefined property: CRM_Core_DAO::$_context in
  CRM_Utils_PagerAToZ::createLinks() on contribution page listing
  ([dev/core#2355](https://lab.civicrm.org/dev/core/-/issues/2355):
  [19515](https://github.com/civicrm/civicrm-core/pull/19515))**

- **Set contribution_page_id from template contribution
  ([19362](https://github.com/civicrm/civicrm-core/pull/19362))**

- **Fix pledge to not use pass-by-reference
  ([19400](https://github.com/civicrm/civicrm-core/pull/19400))**

### CiviMail

- **Update permissions for "CiviCRM Admin Menu -> Mailings -> Message Templates"
  nav item ([19342](https://github.com/civicrm/civicrm-core/pull/19342))**

  Updates the permissions for the "CiviCRM Admin Menu -> Mailings -> Message
  Templates" navigation item so that if the user has any of the following
  permissions they can view it:

  - edit user-driven message templates
  - edit system workflow message templates
  - edit message templates

- **When two contacts, Contact A and Contact B have the same email address, if
  Contact A is deleted then Contact B is incorrectly excluded from mailings,
  does not receive emails
  ([19360](https://github.com/civicrm/civicrm-core/pull/19360))**

### CiviMembership

- **Show disabled membership types on contact tab
  ([19431](https://github.com/civicrm/civicrm-core/pull/19431) and
  [19594](https://github.com/civicrm/civicrm-core/pull/19594))**

- **Fix PHP notice if membershipBlock is not defined
  ([19447](https://github.com/civicrm/civicrm-core/pull/19447))**

### Backdrop Integration

- **UF Settings page for Views CiviCRM integration should not have backticks for
  Backdrop ([dev/core#2352](https://lab.civicrm.org/dev/core/-/issues/2352):
  [19491](https://github.com/civicrm/civicrm-core/pull/19491))**

### Drupal Integration

- **Override the DrupalBase getUserObject function with a Drupal8/9 compatible
  version ([19517](https://github.com/civicrm/civicrm-core/pull/19517))**

  Fixes an error when using the APIv3 `User` entity on Drupal 9.

- **Drupal7: civicrm_rules - Add/Remove contact from CiviCRM Group works with
  deprecated method on removal
  ([dev/drupal#65](https://lab.civicrm.org/dev/drupal/-/issues/65):
  [580](https://github.com/civicrm/civicrm-drupal/pull/580))**

- **Drupal9: system_get_info() not available. CiviReport crash.**
  ([dev/drupal#156](https://lab.civicrm.org/dev/drupal/-/issues/156): [#19725](https://github.com/civicrm/civicrm-core/pull/19725))

- **Fix deceased date format
  ([607](https://github.com/civicrm/civicrm-drupal/pull/607))**

### WordPress Integration

- **List of groups in search form and create new contact screen not respecting
  ACLs ([dev/wordpress#86](https://lab.civicrm.org/dev/wordpress/-/issues/86):
  [19372](https://github.com/civicrm/civicrm-core/pull/19372))**

## <a name="misc"></a>Miscellany

- **Bump socket.io from 2.3.0 to 2.4.1
  ([19427](https://github.com/civicrm/civicrm-core/pull/19427))**

- **Afform - code refactoring for angular best practices
  ([19352](https://github.com/civicrm/civicrm-core/pull/19352))**

- **Token plan - what is it (Code Cleanup for
  [dev/core#2303](https://lab.civicrm.org/dev/core/-/issues/2303):
  [19409](https://github.com/civicrm/civicrm-core/pull/19409))**

- **Deprecate BaseIPN functions validateData & LoadObject
  ([dev/financial#148](https://lab.civicrm.org/dev/financial/-/issues/148):
  [19416](https://github.com/civicrm/civicrm-core/pull/19416))**

- **Comment intent to remove call to transition components
  ([19507](https://github.com/civicrm/civicrm-core/pull/19507))**

- **CRM_Core_BAO_MessageTemplate::sendReminder() is not used anywhere
  ([19502](https://github.com/civicrm/civicrm-core/pull/19502))**

- **Move another deprecated utils function
  ([19365](https://github.com/civicrm/civicrm-core/pull/19365))**

- **Deprecate Pledge::add() function
  ([19411](https://github.com/civicrm/civicrm-core/pull/19411))**

- **Cleanup a couple of unnecessary references
  ([19420](https://github.com/civicrm/civicrm-core/pull/19420))**

- **Update contributor-key.yml
  ([19459](https://github.com/civicrm/civicrm-core/pull/19459))**

- **update contributor-key.yml and CONTRIBUTORS.txt file
  ([19446](https://github.com/civicrm/civicrm-core/pull/19446))**

- **Remove unnecessary call to error_reporting in drupal 7 integration code
  ([19445](https://github.com/civicrm/civicrm-core/pull/19445))**

- **Remove call to loadRelatedObjects
  ([19407](https://github.com/civicrm/civicrm-core/pull/19407))**

- **Remove always true if
  ([19499](https://github.com/civicrm/civicrm-core/pull/19499))**

- **Remove another use of loadRelatedObjects() function
  ([19505](https://github.com/civicrm/civicrm-core/pull/19505))**

- **Test framework - API4 DateTest::testRelativeDateRanges will fail on the last
  day of Jan, Mar, May, Aug, Oct
  ([dev/core#2339](https://lab.civicrm.org/dev/core/-/issues/2339):
  [19462](https://github.com/civicrm/civicrm-core/pull/19462))**

- **[Test framework] Prevent intermittently failing relationship test
  ([19424](https://github.com/civicrm/civicrm-core/pull/19424))**

- **[Test] Extend new membership form to cover multi-line renew + minor cleanup
  ([19404](https://github.com/civicrm/civicrm-core/pull/19404))**

- **[REF] Remove some of those old php4 &s
  ([19419](https://github.com/civicrm/civicrm-core/pull/19419))**

- **REF Move buildMembershipBlock function from ContributionPage to
  Main/Confirm/Thankyou page
  ([19467](https://github.com/civicrm/civicrm-core/pull/19467))**

- **REF Permit installing of replacement extensions during upgrade for ob…
  ([19391](https://github.com/civicrm/civicrm-core/pull/19391))**

- **[REF] Remove objects var from PaypalProIPN
  ([19440](https://github.com/civicrm/civicrm-core/pull/19440))**

- **[REF] Remove seemingly unreachable attempt to format activity_date_time
  ([19437](https://github.com/civicrm/civicrm-core/pull/19437))**

- **[REF] Move related code to be together
  ([19418](https://github.com/civicrm/civicrm-core/pull/19418))**

- **[REF] Simplify activity import validation
  ([19373](https://github.com/civicrm/civicrm-core/pull/19373))**

- **[#REF] Cleanup recently added code fixing dev/core#2307 for the fact …
  ([19415](https://github.com/civicrm/civicrm-core/pull/19415))**

- **[REF] Move instantiation of Order class to earlier in function
  ([19402](https://github.com/civicrm/civicrm-core/pull/19402))**

- **[REF] Remove copy & paste code from Activity mapping form
  ([19488](https://github.com/civicrm/civicrm-core/pull/19488))**

- **[REF] Fix Order class to not reload if already loaded
  ([19403](https://github.com/civicrm/civicrm-core/pull/19403))**

- **[REF] Move code closer to where it is used
  ([19410](https://github.com/civicrm/civicrm-core/pull/19410))**

- **[REF] Param simplification
  ([19406](https://github.com/civicrm/civicrm-core/pull/19406))**

- **[REF] Minor cleanup on emailReceipt
  ([19405](https://github.com/civicrm/civicrm-core/pull/19405))**

- **REF Ensure that when doing RLIKE BINARY the field is cast as BINARY t…
  ([19399](https://github.com/civicrm/civicrm-core/pull/19399))**

- **[REF] Remove function that is the same as parent
  ([19369](https://github.com/civicrm/civicrm-core/pull/19369))**

- **[REF] Standardise methods of determining isTest
  ([19417](https://github.com/civicrm/civicrm-core/pull/19417))**

- **REF Update CiviCRM default PEAR Error handling to be exception rather…
  ([19323](https://github.com/civicrm/civicrm-core/pull/19323))**

- **[REF] Extract logical functions from sendTemplate
  ([19510](https://github.com/civicrm/civicrm-core/pull/19510) and
  [19563](https://github.com/civicrm/civicrm-core/pull/19563))**

- **[REF] Move sendNotification out of recur, remove unused related_contact
  ([19443](https://github.com/civicrm/civicrm-core/pull/19443))**

- **[REF] Remove invalid attempt to load contriution id from invoiceID
  ([19511](https://github.com/civicrm/civicrm-core/pull/19511))**

- **[REF] Stop passing contributionPageID to isEmailReceipt
  ([19498](https://github.com/civicrm/civicrm-core/pull/19498))**

- **[NFC] Fix PHP 7.4 Syntax issue in Afform HTML Extension
  ([19477](https://github.com/civicrm/civicrm-core/pull/19477))**

- **[NFC] Update composer.lock
  ([19485](https://github.com/civicrm/civicrm-core/pull/19485))**

- **[NFC] Whitespace fix up
  ([19408](https://github.com/civicrm/civicrm-core/pull/19408))**

- **[NFC] Preliminary cleanup
  ([19401](https://github.com/civicrm/civicrm-core/pull/19401))**

- **NFC Minor code cleanup to contribution pages
  ([19468](https://github.com/civicrm/civicrm-core/pull/19468))**

- **[NFC] minor code cleanups
  ([19366](https://github.com/civicrm/civicrm-core/pull/19366))**

- **[NFC] Update contributor-key.yml with Ahed
  ([19378](https://github.com/civicrm/civicrm-core/pull/19378))**

- **[NFC] Minor code cleanup
  ([19367](https://github.com/civicrm/civicrm-core/pull/19367))**

- **[NFC] Move Upgrade for navgation from 5.34.alpha1 to 5.35.alpha1 as t…
  ([19364](https://github.com/civicrm/civicrm-core/pull/19364))**

- **(NFC) Regenerate civicrm_generated.mysql
  ([19363](https://github.com/civicrm/civicrm-core/pull/19363))**

- **[NFC] - Remove literally empty if block
  ([632](https://github.com/civicrm/civicrm-drupal/pull/632))**

- **[NFC] Update Schema Handler to use the standard create table syntax of using
  `ROW_FORMAT=dynamic`
  ([19705](https://github.com/civicrm/civicrm-core/pull/19705))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
Christian Wach; CiviCoop - Jaap Jansma, Klaas Eikelboom; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp - Ahed Eid; Coop
SymbioTIC - Mathieu Lutfy; Dave D; ECOPLAN - Torben Bertram;  Freeform
Solutions - Herb van den Dool; iXiam - Vangelis Pantazis; JMA Consulting -
Seamus Lee; John Kingsnorth; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; Skvare - Sunil Pawar; Stephen Palmstrom; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; Blackfly Solutions - Alan
Dixon; Fuzion - Jitendra Purohit; JMA Consulting - Monish Deb; MJCO - Mikey
O'Toole; StijnVanhandsaeme; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
