<?php
use CRM_Grant_ExtensionUtil as E;

return [
  [
    'name' => 'Navigation_Grants',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('Grants'),
        'name' => 'Grants',
        'url' => NULL,
        'icon' => 'crm-i fa-money',
        'permission' => 'access CiviGrant',
        'permission_operator' => '',
        'is_active' => TRUE,
        'weight' => 90,
        'parent_id' => NULL,
        'has_separator' => NULL,
        'domain_id' => 'current_domain',
      ],
    ],
  ],
  [
    'name' => 'Navigation_Grants_Navigation_Dashboard',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('Dashboard'),
        'name' => 'Dashboard',
        'url' => 'civicrm/grant?reset=1',
        'icon' => NULL,
        'permission' => 'access CiviGrant',
        'permission_operator' => '',
        'parent_id.name' => 'Grants',
        'is_active' => TRUE,
        'has_separator' => NULL,
        'domain_id' => 'current_domain',
      ],
    ],
  ],
  [
    'name' => 'Navigation_Grants_Navigation_New_Grant',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('New Grant'),
        'name' => 'New Grant',
        'url' => 'civicrm/grant/add?reset=1&action=add&context=standalone',
        'icon' => NULL,
        'permission' => 'access CiviGrant,edit grants',
        'permission_operator' => 'AND',
        'parent_id.name' => 'Grants',
        'is_active' => TRUE,
        'has_separator' => NULL,
        'domain_id' => 'current_domain',
      ],
    ],
  ],
  [
    'name' => 'Navigation_Grants_Navigation_Find_Grants',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('Find Grants'),
        'name' => 'Find Grants',
        'url' => 'civicrm/grant/search?reset=1',
        'icon' => NULL,
        'permission' => 'access CiviGrant',
        'permission_operator' => '',
        'parent_id.name' => 'Grants',
        'is_active' => TRUE,
        'has_separator' => '1',
        'domain_id' => 'current_domain',
      ],
    ],
  ],
  [
    'name' => 'Navigation_CiviGrant',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('CiviGrant'),
        'name' => 'CiviGrant',
        'url' => NULL,
        'icon' => NULL,
        'permission' => 'access CiviGrant,administer CiviCRM',
        'permission_operator' => 'AND',
        'parent_id.name' => 'Administer',
        'is_active' => TRUE,
        'weight' => 13,
        'has_separator' => NULL,
        'domain_id' => 'current_domain',
      ],
    ],
  ],
  [
    'name' => 'Navigation_CiviGrant_Navigation_Grant_Types',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('Grant Types'),
        'name' => 'Grant Types',
        'url' => 'civicrm/admin/options/grant_type?reset=1',
        'icon' => NULL,
        'permission' => 'access CiviGrant,administer CiviCRM',
        'permission_operator' => 'AND',
        'parent_id.name' => 'CiviGrant',
        'is_active' => TRUE,
        'weight' => 1,
        'has_separator' => NULL,
        'domain_id' => 'current_domain',
      ],
    ],
  ],
  [
    'name' => 'Navigation_CiviGrant_Navigation_Grant_Status',
    'entity' => 'Navigation',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'label' => E::ts('Grant Status'),
        'name' => 'Grant Status',
        'url' => 'civicrm/admin/options/grant_status?reset=1',
        'icon' => NULL,
        'permission' => 'access CiviGrant,administer CiviCRM',
        'permission_operator' => 'AND',
        'parent_id.name' => 'CiviGrant',
        'is_active' => TRUE,
        'weight' => 2,
        'has_separator' => NULL,
        'domain_id' => 'current_domain',
      ],
    ],
  ],
];
