<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2018
 *
 * Generated from xml/schema/CRM/Contribute/Premium.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:86a5118380bd35cee851da735f699ac2)
 */

/**
 * Database access object for the Premium entity.
 */
class CRM_Contribute_DAO_Premium extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_premiums';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = TRUE;

  /**
   * @var int unsigned
   */
  public $id;

  /**
   * Joins these premium settings to another object. Always civicrm_contribution_page for now.
   *
   * @var string
   */
  public $entity_table;

  /**
   * @var int unsigned
   */
  public $entity_id;

  /**
   * Is the Premiums feature enabled for this page?
   *
   * @var boolean
   */
  public $premiums_active;

  /**
   * Title for Premiums section.
   *
   * @var string
   */
  public $premiums_intro_title;

  /**
   * Displayed in <div> at top of Premiums section of page. Text and HTML allowed.
   *
   * @var text
   */
  public $premiums_intro_text;

  /**
   * This email address is included in receipts if it is populated and a premium has been selected.
   *
   * @var string
   */
  public $premiums_contact_email;

  /**
   * This phone number is included in receipts if it is populated and a premium has been selected.
   *
   * @var string
   */
  public $premiums_contact_phone;

  /**
   * Boolean. Should we automatically display minimum contribution amount text after the premium descriptions.
   *
   * @var boolean
   */
  public $premiums_display_min_contribution;

  /**
   * Label displayed for No Thank-you option in premiums block (e.g. No thank you)
   *
   * @var string
   */
  public $premiums_nothankyou_label;

  /**
   * @var int unsigned
   */
  public $premiums_nothankyou_position;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_premiums';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Dynamic(self::getTableName(), 'entity_id', NULL, 'id', 'entity_table');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Premium ID'),
          'required' => TRUE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'entity_table' => [
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Premium Entity'),
          'description' => 'Joins these premium settings to another object. Always civicrm_contribution_page for now.',
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'entity_id' => [
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Premium entity ID'),
          'required' => TRUE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'premiums_active' => [
          'name' => 'premiums_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Premium Active?'),
          'description' => 'Is the Premiums feature enabled for this page?',
          'required' => TRUE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'premiums_intro_title' => [
          'name' => 'premiums_intro_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Title for Premiums section'),
          'description' => 'Title for Premiums section.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 1,
        ],
        'premiums_intro_text' => [
          'name' => 'premiums_intro_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Premium Introductory Text'),
          'description' => 'Displayed in <div> at top of Premiums section of page. Text and HTML allowed.',
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 1,
        ],
        'premiums_contact_email' => [
          'name' => 'premiums_contact_email',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Premium Contact Email'),
          'description' => 'This email address is included in receipts if it is populated and a premium has been selected.',
          'maxlength' => 100,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'premiums_contact_phone' => [
          'name' => 'premiums_contact_phone',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Premiums Contact Phone'),
          'description' => 'This phone number is included in receipts if it is populated and a premium has been selected.',
          'maxlength' => 50,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'premiums_display_min_contribution' => [
          'name' => 'premiums_display_min_contribution',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Display Minimum Contribution?'),
          'description' => 'Boolean. Should we automatically display minimum contribution amount text after the premium descriptions.',
          'required' => TRUE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
        'premiums_nothankyou_label' => [
          'name' => 'premiums_nothankyou_label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('No Thank-you Text'),
          'description' => 'Label displayed for No Thank-you option in premiums block (e.g. No thank you)',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 1,
        ],
        'premiums_nothankyou_position' => [
          'name' => 'premiums_nothankyou_position',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('No Thank-you Position'),
          'default' => '1',
          'table_name' => 'civicrm_premiums',
          'entity' => 'Premium',
          'bao' => 'CRM_Contribute_BAO_Premium',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'premiums', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'premiums', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
