<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2020
 *
 * Settings metadata file
 */

return [
  'cvv_backoffice_required' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'cvv_backoffice_required',
    'type' => 'Boolean',
    'html_type' => 'radio',
    'quick_form_type' => 'YesNo',
    'default' => '1',
    'add' => '4.1',
    'title' => ts('CVV required for backoffice?'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Is the CVV code required for back office credit card transactions'),
    'help_text' => 'If set it back-office credit card transactions will required a cvv code. Leave as required unless you have a very strong reason to change',
    'settings_pages' => ['contribute' => ['weight' => 10]],
  ],
  'contribution_invoice_settings' => [
    // @todo our standard is to have a setting per item not to hide settings in an array with
    // no useful metadata. Undo this setting.
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'contribution_invoice_settings',
    'type' => 'Array',
    'add' => '4.7',
    'title' => ts('Deprecated, virtualized setting'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
  ],
  'invoicing' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'invoicing',
    'type' => 'Boolean',
    'html_type' => 'checkbox',
    'quick_form_type' => 'Element',
    'default' => 0,
    'add' => '4.7',
    'title' => ts('Enable Tax and Invoicing'),
    'is_domain' => 1,
    'is_contact' => 0,
    'on_change' => [
      'CRM_Invoicing_Utils::onToggle',
    ],
    'settings_pages' => ['contribute' => ['weight' => 90]],
  ],
  'invoice_prefix' => [
    'default' => 'INV_',
    'html_type' => 'text',
    'name' => 'invoice_prefix',
    'add' => '5.23',
    'type' => CRM_Utils_Type::T_STRING,
    'title' => ts('Invoice Prefix'),
    'description' => ts('Enter prefix to be be preprended when creating an invoice number'),
    'is_domain' => 1,
    'is_contact' => 0,
  ],
  'invoice_due_date' => [
    'default' => '10',
    'name' => 'invoice_due_date',
    'html_type' => 'text',
    'title' => ts('Due Date'),
    'add' => '5.23',
    'type' => CRM_Utils_Type::T_INT,
    'is_domain' => 1,
    'is_contact' => 0,
  ],
  'invoice_due_date_period' => [
    'default' => 'days',
    'html_type' => 'select',
    'name' => 'invoice_due_date_period',
    'title' => ts('For transmission'),
    'weight' => 4,
    'add' => '5.23',
    'type' => CRM_Utils_Type::T_STRING,
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Select the interval for due date.'),
    'options' => [
      'select' => ts('- select -'),
      'days' => ts('Days'),
      'months' => ts('Months'),
      'years' => ts('Years'),
    ],
  ],
  'invoice_notes' => [
    'default' => '',
    'name' => 'invoice_notes',
    'html_type' => 'wysiwyg',
    'title' => ts('Notes or Standard Terms'),
    'type' => CRM_Utils_Type::T_STRING,
    'add' => '5.23',
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Enter note or message to be displayed on PDF invoice or credit notes '),
    'attributes' => ['rows' => 2, 'cols' => 40],
  ],
  'invoice_is_email_pdf' => [
    'name' => 'invoice_is_email_pdf',
    'html_type' => 'checkbox',
    'add' => '5.23',
    'type' => CRM_Utils_Type::T_BOOLEAN,
    'is_domain' => 1,
    'is_contact' => 0,
    'title' => ts('Automatically email invoice when user purchases online'),
    'description' => ts('Should a pdf invoice be emailed automatically?'),
  ],
  'tax_term' => [
    'default' => 'Sales Tax',
    'name' => 'tax_term',
    'html_type' => 'text',
    'add' => '5.23',
    'title' => ts('Tax Term'),
    'type' => CRM_Utils_Type::T_STRING,
    'is_domain' => 1,
    'is_contact' => 0,
  ],
  'tax_display_settings' => [
    'default' => 'Inclusive',
    'html_type' => 'select',
    'name' => 'tax_display_settings',
    'type' => CRM_Utils_Type::T_STRING,
    'add' => '5.23',
    'title' => ts('Tax Display Settings'),
    'is_domain' => 1,
    'is_contact' => 0,
    'pseudoconstant' => ['callback' => 'CRM_Core_SelectValues::taxDisplayOptions'],
  ],
  'acl_financial_type' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'acl_financial_type',
    'type' => 'Boolean',
    'html_type' => 'checkbox',
    'quick_form_type' => 'Element',
    'default' => 0,
    'add' => '4.7',
    'title' => ts('Enable Access Control by Financial Type'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'help' => ['id' => 'acl_financial_type'],
    'settings_pages' => ['contribute' => ['weight' => 30]],
  ],
  'deferred_revenue_enabled' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'deferred_revenue_enabled',
    'type' => 'Boolean',
    'html_type' => 'checkbox',
    'quick_form_type' => 'Element',
    'default' => 0,
    'add' => '4.7',
    'title' => ts('Enable Deferred Revenue'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'settings_pages' => ['contribute' => ['weight' => 50]],
  ],
  'default_invoice_page' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'default_invoice_page',
    'type' => 'Integer',
    'quick_form_type' => 'Select',
    'default' => NULL,
    'pseudoconstant' => [
      'table' => 'civicrm_contribution_page',
      'keyColumn' => 'id',
      'labelColumn' => 'title',
    ],
    'html_type' => 'select',
    'add' => '4.7',
    'title' => ts('Default invoice payment page'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'settings_pages' => ['contribute' => ['weight' => 70]],
  ],
  'always_post_to_accounts_receivable' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'always_post_to_accounts_receivable',
    'type' => 'Boolean',
    'html_type' => 'checkbox',
    'quick_form_type' => 'Element',
    'default' => 0,
    'add' => '4.7',
    'title' => ts('Always post to Accounts Receivable?'),
    'is_domain' => 1,
    'is_contact' => 0,
    'help_text' => NULL,
    'settings_pages' => ['contribute' => ['weight' => 40]],
  ],
  'update_contribution_on_membership_type_change' => [
    'group_name' => 'Contribute Preferences',
    'group' => 'contribute',
    'name' => 'update_contribution_on_membership_type_change',
    'type' => 'Boolean',
    'html_type' => 'checkbox',
    'quick_form_type' => 'Element',
    'default' => 0,
    'add' => '4.7',
    'title' => ts('Automatically update related contributions when Membership Type is changed'),
    'is_domain' => 1,
    'is_contact' => 0,
    'description' => ts('Enabling this setting will update related contribution of membership(s) except if the membership is paid for with a recurring contribution.'),
    'help_text' => NULL,
    'settings_pages' => ['contribute' => ['weight' => 20]],
  ],
];
