<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2019
 *
 * Generated from xml/schema/CRM/Contact/Contact.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:ee3bf9f2d1faed5a4de439ecf0537ac6)
 */

/**
 * Database access object for the Contact entity.
 */
class CRM_Contact_DAO_Contact extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_contact';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Unique Contact ID
   *
   * @var int
   */
  public $id;

  /**
   * Type of Contact.
   *
   * @var string
   */
  public $contact_type;

  /**
   * May be used to over-ride contact view and edit templates.
   *
   * @var string
   */
  public $contact_sub_type;

  /**
   * @var bool
   */
  public $do_not_email;

  /**
   * @var bool
   */
  public $do_not_phone;

  /**
   * @var bool
   */
  public $do_not_mail;

  /**
   * @var bool
   */
  public $do_not_sms;

  /**
   * @var bool
   */
  public $do_not_trade;

  /**
   * Has the contact opted out from receiving all bulk email from the organization or site domain?
   *
   * @var bool
   */
  public $is_opt_out;

  /**
   * May be used for SSN, EIN/TIN, Household ID (census) or other applicable unique legal/government ID.
   *
   * @var string
   */
  public $legal_identifier;

  /**
   * Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.
   *
   * @var string
   */
  public $external_identifier;

  /**
   * Name used for sorting different contact types
   *
   * @var string
   */
  public $sort_name;

  /**
   * Formatted name representing preferred format for display/print/other output.
   *
   * @var string
   */
  public $display_name;

  /**
   * Nickname.
   *
   * @var string
   */
  public $nick_name;

  /**
   * Legal Name.
   *
   * @var string
   */
  public $legal_name;

  /**
   * optional URL for preferred image (photo, logo, etc.) to display for this contact.
   *
   * @var text
   */
  public $image_URL;

  /**
   * What is the preferred mode of communication.
   *
   * @var string
   */
  public $preferred_communication_method;

  /**
   * Which language is preferred for communication. FK to languages in civicrm_option_value.
   *
   * @var string
   */
  public $preferred_language;

  /**
   * What is the preferred mode of sending an email.
   *
   * @var string
   */
  public $preferred_mail_format;

  /**
   * Key for validating requests related to this contact.
   *
   * @var string
   */
  public $hash;

  /**
   * API Key for validating requests related to this contact.
   *
   * @var string
   */
  public $api_key;

  /**
   * where contact come from, e.g. import, donate module insert...
   *
   * @var string
   */
  public $source;

  /**
   * First Name.
   *
   * @var string
   */
  public $first_name;

  /**
   * Middle Name.
   *
   * @var string
   */
  public $middle_name;

  /**
   * Last Name.
   *
   * @var string
   */
  public $last_name;

  /**
   * Prefix or Title for name (Ms, Mr...). FK to prefix ID
   *
   * @var int
   */
  public $prefix_id;

  /**
   * Suffix for name (Jr, Sr...). FK to suffix ID
   *
   * @var int
   */
  public $suffix_id;

  /**
   * Formal (academic or similar) title in front of name. (Prof., Dr. etc.)
   *
   * @var string
   */
  public $formal_title;

  /**
   * Communication style (e.g. formal vs. familiar) to use with this contact. FK to communication styles in civicrm_option_value.
   *
   * @var int
   */
  public $communication_style_id;

  /**
   * FK to civicrm_option_value.id, that has to be valid registered Email Greeting.
   *
   * @var int
   */
  public $email_greeting_id;

  /**
   * Custom Email Greeting.
   *
   * @var string
   */
  public $email_greeting_custom;

  /**
   * Cache Email Greeting.
   *
   * @var string
   */
  public $email_greeting_display;

  /**
   * FK to civicrm_option_value.id, that has to be valid registered Postal Greeting.
   *
   * @var int
   */
  public $postal_greeting_id;

  /**
   * Custom Postal greeting.
   *
   * @var string
   */
  public $postal_greeting_custom;

  /**
   * Cache Postal greeting.
   *
   * @var string
   */
  public $postal_greeting_display;

  /**
   * FK to civicrm_option_value.id, that has to be valid registered Addressee.
   *
   * @var int
   */
  public $addressee_id;

  /**
   * Custom Addressee.
   *
   * @var string
   */
  public $addressee_custom;

  /**
   * Cache Addressee.
   *
   * @var string
   */
  public $addressee_display;

  /**
   * Job Title
   *
   * @var string
   */
  public $job_title;

  /**
   * FK to gender ID
   *
   * @var int
   */
  public $gender_id;

  /**
   * Date of birth
   *
   * @var date
   */
  public $birth_date;

  /**
   * @var bool
   */
  public $is_deceased;

  /**
   * Date of deceased
   *
   * @var date
   */
  public $deceased_date;

  /**
   * Household Name.
   *
   * @var string
   */
  public $household_name;

  /**
   * Optional FK to Primary Contact for this household.
   *
   * @var int
   */
  public $primary_contact_id;

  /**
   * Organization Name.
   *
   * @var string
   */
  public $organization_name;

  /**
   * Standard Industry Classification Code.
   *
   * @var string
   */
  public $sic_code;

  /**
   * the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM
   *
   * @var string
   */
  public $user_unique_id;

  /**
   * OPTIONAL FK to civicrm_contact record.
   *
   * @var int
   */
  public $employer_id;

  /**
   * @var bool
   */
  public $is_deleted;

  /**
   * When was the contact was created.
   *
   * @var timestamp
   */
  public $created_date;

  /**
   * When was the contact (or closely related entity) was created or modified or deleted.
   *
   * @var timestamp
   */
  public $modified_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_contact';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'primary_contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'employer_id', 'civicrm_contact', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID'),
          'description' => ts('Unique Contact ID'),
          'required' => TRUE,
          'import' => TRUE,
          'where' => 'civicrm_contact.id',
          'headerPattern' => '/internal|contact?|id$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
        ],
        'contact_type' => [
          'name' => 'contact_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Type'),
          'description' => ts('Type of Contact.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'where' => 'civicrm_contact.contact_type',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NULL',
          ],
        ],
        'contact_sub_type' => [
          'name' => 'contact_sub_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Subtype'),
          'description' => ts('May be used to over-ride contact view and edit templates.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_contact.contact_sub_type',
          'headerPattern' => '/C(ontact )?(subtype|sub-type|sub type)/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NOT NULL',
          ],
        ],
        'do_not_email' => [
          'name' => 'do_not_email',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Email'),
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_email',
          'headerPattern' => '/d(o )?(not )?(email)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'do_not_phone' => [
          'name' => 'do_not_phone',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Phone'),
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_phone',
          'headerPattern' => '/d(o )?(not )?(call|phone)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'do_not_mail' => [
          'name' => 'do_not_mail',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Mail'),
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_mail',
          'headerPattern' => '/^(d(o\s)?n(ot\s)?mail)|(\w*)?bulk\s?(\w*)$/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'do_not_sms' => [
          'name' => 'do_not_sms',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Sms'),
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_sms',
          'headerPattern' => '/d(o )?(not )?(sms)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'do_not_trade' => [
          'name' => 'do_not_trade',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Trade'),
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_trade',
          'headerPattern' => '/d(o )?(not )?(trade)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'is_opt_out' => [
          'name' => 'is_opt_out',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('No Bulk Emails (User Opt Out)'),
          'description' => ts('Has the contact opted out from receiving all bulk email from the organization or site domain?'),
          'required' => TRUE,
          'import' => TRUE,
          'where' => 'civicrm_contact.is_opt_out',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'legal_identifier' => [
          'name' => 'legal_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Legal Identifier'),
          'description' => ts('May be used for SSN, EIN/TIN, Household ID (census) or other applicable unique legal/government ID.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'import' => TRUE,
          'where' => 'civicrm_contact.legal_identifier',
          'headerPattern' => '/legal\s?id/i',
          'dataPattern' => '/\w+?\d{5,}/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'external_identifier' => [
          'name' => 'external_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('External Identifier'),
          'description' => ts('Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.'),
          'maxlength' => 64,
          'size' => 8,
          'import' => TRUE,
          'where' => 'civicrm_contact.external_identifier',
          'headerPattern' => '/external\s?id/i',
          'dataPattern' => '/^\d{11,}$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'sort_name' => [
          'name' => 'sort_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Sort Name'),
          'description' => ts('Name used for sorting different contact types'),
          'maxlength' => 128,
          'size' => 30,
          'where' => 'civicrm_contact.sort_name',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'display_name' => [
          'name' => 'display_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Display Name'),
          'description' => ts('Formatted name representing preferred format for display/print/other output.'),
          'maxlength' => 128,
          'size' => 30,
          'where' => 'civicrm_contact.display_name',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'nick_name' => [
          'name' => 'nick_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Nickname'),
          'description' => ts('Nickname.'),
          'maxlength' => 128,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.nick_name',
          'headerPattern' => '/n(ick\s)name|nick$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'legal_name' => [
          'name' => 'legal_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Legal Name'),
          'description' => ts('Legal Name.'),
          'maxlength' => 128,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.legal_name',
          'headerPattern' => '/^legal|(l(egal\s)?name)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'image_URL' => [
          'name' => 'image_URL',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Image Url'),
          'description' => ts('optional URL for preferred image (photo, logo, etc.) to display for this contact.'),
          'import' => TRUE,
          'where' => 'civicrm_contact.image_URL',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'File',
          ],
        ],
        'preferred_communication_method' => [
          'name' => 'preferred_communication_method',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Preferred Communication Method'),
          'description' => ts('What is the preferred mode of communication.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_contact.preferred_communication_method',
          'headerPattern' => '/^p(ref\w*\s)?c(omm\w*)|( meth\w*)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'preferred_communication_method',
            'optionEditPath' => 'civicrm/admin/options/preferred_communication_method',
          ],
        ],
        'preferred_language' => [
          'name' => 'preferred_language',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Preferred Language'),
          'description' => ts('Which language is preferred for communication. FK to languages in civicrm_option_value.'),
          'maxlength' => 5,
          'size' => CRM_Utils_Type::SIX,
          'import' => TRUE,
          'where' => 'civicrm_contact.preferred_language',
          'headerPattern' => '/^lang/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'languages',
            'keyColumn' => 'name',
            'optionEditPath' => 'civicrm/admin/options/languages',
          ],
        ],
        'preferred_mail_format' => [
          'name' => 'preferred_mail_format',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Preferred Mail Format'),
          'description' => ts('What is the preferred mode of sending an email.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'import' => TRUE,
          'where' => 'civicrm_contact.preferred_mail_format',
          'headerPattern' => '/^p(ref\w*\s)?m(ail\s)?f(orm\w*)$/i',
          'export' => TRUE,
          'default' => 'Both',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::pmf',
          ],
        ],
        'hash' => [
          'name' => 'hash',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Hash'),
          'description' => ts('Key for validating requests related to this contact.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'where' => 'civicrm_contact.hash',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
        ],
        'api_key' => [
          'name' => 'api_key',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Api Key'),
          'description' => ts('API Key for validating requests related to this contact.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'where' => 'civicrm_contact.api_key',
          'permission' => [
            [
              'administer CiviCRM',
              'edit api keys',
            ],
          ],
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
        ],
        'contact_source' => [
          'name' => 'source',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Source'),
          'description' => ts('where contact come from, e.g. import, donate module insert...'),
          'maxlength' => 255,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.source',
          'headerPattern' => '/(C(ontact\s)?Source)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'first_name' => [
          'name' => 'first_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('First Name'),
          'description' => ts('First Name.'),
          'maxlength' => 64,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.first_name',
          'headerPattern' => '/^first|(f(irst\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'middle_name' => [
          'name' => 'middle_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Middle Name'),
          'description' => ts('Middle Name.'),
          'maxlength' => 64,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.middle_name',
          'headerPattern' => '/^middle|(m(iddle\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'last_name' => [
          'name' => 'last_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Last Name'),
          'description' => ts('Last Name.'),
          'maxlength' => 64,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.last_name',
          'headerPattern' => '/^last|(l(ast\s)?name)$/i',
          'dataPattern' => '/^\w+(\s\w+)?+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'prefix_id' => [
          'name' => 'prefix_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Individual Prefix'),
          'description' => ts('Prefix or Title for name (Ms, Mr...). FK to prefix ID'),
          'import' => TRUE,
          'where' => 'civicrm_contact.prefix_id',
          'headerPattern' => '/^(prefix|title)/i',
          'dataPattern' => '/^(mr|ms|mrs|sir|dr)\.?$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'individual_prefix',
            'optionEditPath' => 'civicrm/admin/options/individual_prefix',
          ],
        ],
        'suffix_id' => [
          'name' => 'suffix_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Individual Suffix'),
          'description' => ts('Suffix for name (Jr, Sr...). FK to suffix ID'),
          'import' => TRUE,
          'where' => 'civicrm_contact.suffix_id',
          'headerPattern' => '/^suffix$/i',
          'dataPattern' => '/^(sr|jr)\.?|i{2,}$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'individual_suffix',
            'optionEditPath' => 'civicrm/admin/options/individual_suffix',
          ],
        ],
        'formal_title' => [
          'name' => 'formal_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Formal Title'),
          'description' => ts('Formal (academic or similar) title in front of name. (Prof., Dr. etc.)'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'import' => TRUE,
          'where' => 'civicrm_contact.formal_title',
          'headerPattern' => '/^title/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'communication_style_id' => [
          'name' => 'communication_style_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Communication Style'),
          'description' => ts('Communication style (e.g. formal vs. familiar) to use with this contact. FK to communication styles in civicrm_option_value.'),
          'import' => TRUE,
          'where' => 'civicrm_contact.communication_style_id',
          'headerPattern' => '/style/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'communication_style',
            'optionEditPath' => 'civicrm/admin/options/communication_style',
          ],
        ],
        'email_greeting_id' => [
          'name' => 'email_greeting_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Email Greeting ID'),
          'description' => ts('FK to civicrm_option_value.id, that has to be valid registered Email Greeting.'),
          'where' => 'civicrm_contact.email_greeting_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'pseudoconstant' => [
            'optionGroupName' => 'email_greeting',
            'optionEditPath' => 'civicrm/admin/options/email_greeting',
          ],
        ],
        'email_greeting_custom' => [
          'name' => 'email_greeting_custom',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Email Greeting Custom'),
          'description' => ts('Custom Email Greeting.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_contact.email_greeting_custom',
          'export' => FALSE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'email_greeting_display' => [
          'name' => 'email_greeting_display',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Email Greeting'),
          'description' => ts('Cache Email Greeting.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact.email_greeting_display',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'postal_greeting_id' => [
          'name' => 'postal_greeting_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Postal Greeting ID'),
          'description' => ts('FK to civicrm_option_value.id, that has to be valid registered Postal Greeting.'),
          'where' => 'civicrm_contact.postal_greeting_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'postal_greeting',
            'optionEditPath' => 'civicrm/admin/options/postal_greeting',
          ],
        ],
        'postal_greeting_custom' => [
          'name' => 'postal_greeting_custom',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Postal Greeting Custom'),
          'description' => ts('Custom Postal greeting.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_contact.postal_greeting_custom',
          'export' => FALSE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'postal_greeting_display' => [
          'name' => 'postal_greeting_display',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Postal Greeting'),
          'description' => ts('Cache Postal greeting.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact.postal_greeting_display',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'addressee_id' => [
          'name' => 'addressee_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Addressee ID'),
          'description' => ts('FK to civicrm_option_value.id, that has to be valid registered Addressee.'),
          'where' => 'civicrm_contact.addressee_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'pseudoconstant' => [
            'optionGroupName' => 'addressee',
            'optionEditPath' => 'civicrm/admin/options/addressee',
          ],
        ],
        'addressee_custom' => [
          'name' => 'addressee_custom',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Addressee Custom'),
          'description' => ts('Custom Addressee.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_contact.addressee_custom',
          'export' => FALSE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'addressee_display' => [
          'name' => 'addressee_display',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Addressee'),
          'description' => ts('Cache Addressee.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_contact.addressee_display',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'job_title' => [
          'name' => 'job_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Title'),
          'description' => ts('Job Title'),
          'maxlength' => 255,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.job_title',
          'headerPattern' => '/^job|(j(ob\s)?title)$/i',
          'dataPattern' => '//',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'gender_id' => [
          'name' => 'gender_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Gender'),
          'description' => ts('FK to gender ID'),
          'import' => TRUE,
          'where' => 'civicrm_contact.gender_id',
          'headerPattern' => '/^gender$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'gender',
            'optionEditPath' => 'civicrm/admin/options/gender',
          ],
        ],
        'birth_date' => [
          'name' => 'birth_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Birth Date'),
          'description' => ts('Date of birth'),
          'import' => TRUE,
          'where' => 'civicrm_contact.birth_date',
          'headerPattern' => '/^birth|(b(irth\s)?date)|D(\W*)O(\W*)B(\W*)$/i',
          'dataPattern' => '/\d{4}-?\d{2}-?\d{2}/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'birth',
          ],
        ],
        'is_deceased' => [
          'name' => 'is_deceased',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Deceased'),
          'import' => TRUE,
          'where' => 'civicrm_contact.is_deceased',
          'headerPattern' => '/i(s\s)?d(eceased)$/i',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'deceased_date' => [
          'name' => 'deceased_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Deceased Date'),
          'description' => ts('Date of deceased'),
          'import' => TRUE,
          'where' => 'civicrm_contact.deceased_date',
          'headerPattern' => '/^deceased|(d(eceased\s)?date)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'birth',
          ],
        ],
        'household_name' => [
          'name' => 'household_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Household Name'),
          'description' => ts('Household Name.'),
          'maxlength' => 128,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.household_name',
          'headerPattern' => '/^household|(h(ousehold\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'primary_contact_id' => [
          'name' => 'primary_contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Household Primary Contact ID'),
          'description' => ts('Optional FK to Primary Contact for this household.'),
          'where' => 'civicrm_contact.primary_contact_id',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'type' => 'Select',
          ],
        ],
        'organization_name' => [
          'name' => 'organization_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Organization Name'),
          'description' => ts('Organization Name.'),
          'maxlength' => 128,
          'size' => 30,
          'import' => TRUE,
          'where' => 'civicrm_contact.organization_name',
          'headerPattern' => '/^organization|(o(rganization\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'sic_code' => [
          'name' => 'sic_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Sic Code'),
          'description' => ts('Standard Industry Classification Code.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'import' => TRUE,
          'where' => 'civicrm_contact.sic_code',
          'headerPattern' => '/^sic|(s(ic\s)?code)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'user_unique_id' => [
          'name' => 'user_unique_id',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Unique ID (OpenID)'),
          'description' => ts('the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => TRUE,
          'where' => 'civicrm_contact.user_unique_id',
          'headerPattern' => '/^Open\s?ID|u(niq\w*)?\s?ID/i',
          'dataPattern' => '/^[\w\/\:\.]+$/',
          'export' => TRUE,
          'rule' => 'url',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'current_employer_id' => [
          'name' => 'employer_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Current Employer'),
          'description' => ts('OPTIONAL FK to civicrm_contact record.'),
          'where' => 'civicrm_contact.employer_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'type' => 'EntityRef',
          ],
        ],
        'contact_is_deleted' => [
          'name' => 'is_deleted',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Contact is in Trash'),
          'required' => TRUE,
          'where' => 'civicrm_contact.is_deleted',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Created Date'),
          'description' => ts('When was the contact was created.'),
          'required' => FALSE,
          'where' => 'civicrm_contact.created_date',
          'export' => TRUE,
          'default' => 'NULL',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
        ],
        'modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Modified Date'),
          'description' => ts('When was the contact (or closely related entity) was created or modified or deleted.'),
          'required' => FALSE,
          'where' => 'civicrm_contact.modified_date',
          'export' => TRUE,
          'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'contact', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'contact', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_contact_type' => [
        'name' => 'index_contact_type',
        'field' => [
          0 => 'contact_type',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::contact_type',
      ],
      'index_contact_sub_type' => [
        'name' => 'index_contact_sub_type',
        'field' => [
          0 => 'contact_sub_type',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::contact_sub_type',
      ],
      'UI_external_identifier' => [
        'name' => 'UI_external_identifier',
        'field' => [
          0 => 'external_identifier',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_contact::1::external_identifier',
      ],
      'index_sort_name' => [
        'name' => 'index_sort_name',
        'field' => [
          0 => 'sort_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::sort_name',
      ],
      'index_preferred_communication_method' => [
        'name' => 'index_preferred_communication_method',
        'field' => [
          0 => 'preferred_communication_method',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::preferred_communication_method',
      ],
      'index_hash' => [
        'name' => 'index_hash',
        'field' => [
          0 => 'hash',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::hash',
      ],
      'index_api_key' => [
        'name' => 'index_api_key',
        'field' => [
          0 => 'api_key',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::api_key',
      ],
      'index_first_name' => [
        'name' => 'index_first_name',
        'field' => [
          0 => 'first_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::first_name',
      ],
      'index_last_name' => [
        'name' => 'index_last_name',
        'field' => [
          0 => 'last_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::last_name',
      ],
      'UI_prefix' => [
        'name' => 'UI_prefix',
        'field' => [
          0 => 'prefix_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::prefix_id',
      ],
      'UI_suffix' => [
        'name' => 'UI_suffix',
        'field' => [
          0 => 'suffix_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::suffix_id',
      ],
      'index_communication_style_id' => [
        'name' => 'index_communication_style_id',
        'field' => [
          0 => 'communication_style_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::communication_style_id',
      ],
      'UI_gender' => [
        'name' => 'UI_gender',
        'field' => [
          0 => 'gender_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::gender_id',
      ],
      'index_is_deceased' => [
        'name' => 'index_is_deceased',
        'field' => [
          0 => 'is_deceased',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::is_deceased',
      ],
      'index_household_name' => [
        'name' => 'index_household_name',
        'field' => [
          0 => 'household_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::household_name',
      ],
      'index_organization_name' => [
        'name' => 'index_organization_name',
        'field' => [
          0 => 'organization_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::organization_name',
      ],
      'index_is_deleted_sort_name' => [
        'name' => 'index_is_deleted_sort_name',
        'field' => [
          0 => 'is_deleted',
          1 => 'sort_name',
          2 => 'id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::is_deleted::sort_name::id',
      ],
      'index_created_date' => [
        'name' => 'index_created_date',
        'field' => [
          0 => 'created_date',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::created_date',
      ],
      'index_modified_date' => [
        'name' => 'index_modified_date',
        'field' => [
          0 => 'modified_date',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::modified_date',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
