<?php

/*
 +--------------------------------------------------------------------+
 | CiviCRM version 5                                                  |
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC (c) 2004-2019                                |
 +--------------------------------------------------------------------+
 | This file is a part of CiviCRM.                                    |
 |                                                                    |
 | CiviCRM is free software; you can copy, modify, and distribute it  |
 | under the terms of the GNU Affero General Public License           |
 | Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
 |                                                                    |
 | CiviCRM is distributed in the hope that it will be useful, but     |
 | WITHOUT ANY WARRANTY; without even the implied warranty of         |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
 | See the GNU Affero General Public License for more details.        |
 |                                                                    |
 | You should have received a copy of the GNU Affero General Public   |
 | License and the CiviCRM Licensing Exception along                  |
 | with this program; if not, contact CiviCRM LLC                     |
 | at info[AT]civicrm[DOT]org. If you have questions about the        |
 | GNU Affero General Public License or the licensing of CiviCRM,     |
 | see the CiviCRM license FAQ at http://civicrm.org/licensing        |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2019
 * $Id$
 *
 */
class CRM_Api4_Page_AJAX extends CRM_Core_Page {

  /**
   * Handler for api4 ajax requests
   */
  public function run() {
    $config = CRM_Core_Config::singleton();
    if (!$config->debug && (!array_key_exists('HTTP_X_REQUESTED_WITH', $_SERVER) ||
        $_SERVER['HTTP_X_REQUESTED_WITH'] != "XMLHttpRequest"
      )
    ) {
      $response = [
        'error_code' => 401,
        'error_message' => "SECURITY ALERT: Ajax requests can only be issued by javascript clients, eg. CRM.api4().",
      ];
      Civi::log()->debug("SECURITY ALERT: Ajax requests can only be issued by javascript clients, eg. CRM.api4().",
        [
          'IP' => $_SERVER['REMOTE_ADDR'],
          'level' => 'security',
          'referer' => $_SERVER['HTTP_REFERER'],
          'reason' => 'CSRF suspected',
        ]
      );
      CRM_Utils_System::setHttpHeader('Content-Type', 'application/json');
      echo json_encode($response);
      CRM_Utils_System::civiExit();
    }
    if ($_SERVER['REQUEST_METHOD'] == 'GET' &&
      strtolower(substr($this->urlPath[4], 0, 3)) != 'get') {
      $response = [
        'error_code' => 400,
        'error_message' => "SECURITY: All requests that modify the database must be http POST, not GET.",
      ];
      Civi::log()->debug("SECURITY: All requests that modify the database must be http POST, not GET.",
        [
          'IP' => $_SERVER['REMOTE_ADDR'],
          'level' => 'security',
          'referer' => $_SERVER['HTTP_REFERER'],
          'reason' => 'Destructive HTTP GET',
        ]
      );
      CRM_Utils_System::setHttpHeader('Content-Type', 'application/json');
      echo json_encode($response);
      CRM_Utils_System::civiExit();
    }
    try {
      // Call multiple
      if (empty($this->urlPath[3])) {
        $calls = CRM_Utils_Request::retrieve('calls', 'String', CRM_Core_DAO::$_nullObject, TRUE, NULL, 'POST', TRUE);
        $calls = json_decode($calls, TRUE);
        $response = [];
        foreach ($calls as $index => $call) {
          $response[$index] = call_user_func_array([$this, 'execute'], $call);
        }
      }
      // Call single
      else {
        $entity = $this->urlPath[3];
        $action = $this->urlPath[4];
        $params = CRM_Utils_Request::retrieve('params', 'String');
        $params = $params ? json_decode($params, TRUE) : [];
        $index = CRM_Utils_Request::retrieve('index', 'String');
        $response = $this->execute($entity, $action, $params, $index);
      }
    }
    catch (Exception $e) {
      http_response_code(500);
      $response = [
        'error_code' => $e->getCode(),
      ];
      if (CRM_Core_Permission::check('view debug output')) {
        $response['error_message'] = $e->getMessage();
        if (\Civi::settings()->get('backtrace')) {
          $response['backtrace'] = $e->getTrace();
        }
      }
    }
    CRM_Utils_System::setHttpHeader('Content-Type', 'application/json');
    echo json_encode($response);
    CRM_Utils_System::civiExit();
  }

  /**
   * Run api call & prepare result for json encoding
   *
   * @param string $entity
   * @param string $action
   * @param array $params
   * @param string $index
   * @return array
   */
  protected function execute($entity, $action, $params = [], $index = NULL) {
    $params['checkPermissions'] = TRUE;

    // Handle numeric indexes later so we can get the count
    $itemAt = CRM_Utils_Type::validate($index, 'Integer', FALSE);

    $result = civicrm_api4($entity, $action, $params, isset($itemAt) ? NULL : $index);

    // Convert arrayObject into something more suitable for json
    $vals = ['values' => isset($itemAt) ? $result->itemAt($itemAt) : (array) $result];
    foreach (get_class_vars(get_class($result)) as $key => $val) {
      $vals[$key] = $result->$key;
    }
    $vals['count'] = $result->count();
    return $vals;
  }

}
