<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2019
 *
 * Generated from xml/schema/CRM/Core/File.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:1ecf5010cac38b5778d7b448b50e7c01)
 */

/**
 * Database access object for the File entity.
 */
class CRM_Core_DAO_File extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_file';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Unique ID
   *
   * @var int
   */
  public $id;

  /**
   * Type of file (e.g. Transcript, Income Tax Return, etc). FK to civicrm_option_value.
   *
   * @var int
   */
  public $file_type_id;

  /**
   * mime type of the document
   *
   * @var string
   */
  public $mime_type;

  /**
   * uri of the file on disk
   *
   * @var string
   */
  public $uri;

  /**
   * contents of the document
   *
   * @var mediumblob
   */
  public $document;

  /**
   * Additional descriptive text regarding this attachment (optional).
   *
   * @var string
   */
  public $description;

  /**
   * Date and time that this attachment was uploaded or written to server.
   *
   * @var datetime
   */
  public $upload_date;

  /**
   * FK to civicrm_contact, who uploaded this file
   *
   * @var int
   */
  public $created_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_file';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'created_id', 'civicrm_contact', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('File ID'),
          'description' => ts('Unique ID'),
          'required' => TRUE,
          'where' => 'civicrm_file.id',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'file_type_id' => [
          'name' => 'file_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('File Type'),
          'description' => ts('Type of file (e.g. Transcript, Income Tax Return, etc). FK to civicrm_option_value.'),
          'where' => 'civicrm_file.file_type_id',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'mime_type' => [
          'name' => 'mime_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Mime Type'),
          'description' => ts('mime type of the document'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_file.mime_type',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'uri' => [
          'name' => 'uri',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Path'),
          'description' => ts('uri of the file on disk'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_file.uri',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'document' => [
          'name' => 'document',
          'type' => CRM_Utils_Type::T_MEDIUMBLOB,
          'title' => ts('File Contents'),
          'description' => ts('contents of the document'),
          'where' => 'civicrm_file.document',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('File Description'),
          'description' => ts('Additional descriptive text regarding this attachment (optional).'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_file.description',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'upload_date' => [
          'name' => 'upload_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('File Upload Date'),
          'description' => ts('Date and time that this attachment was uploaded or written to server.'),
          'where' => 'civicrm_file.upload_date',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to civicrm_contact, who uploaded this file'),
          'where' => 'civicrm_file.created_id',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'file', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'file', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
