<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Pledge/Pledge.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:02d420c23b3c72fc2687cd857cc7d178)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Pledge_DAO_Pledge constructor.
 */
class CRM_Pledge_DAO_Pledge extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_pledge';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Pledge ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Foreign key to civicrm_contact.id .
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * FK to Financial Type
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * The Contribution Page which triggered this contribution
   *
   * @var int unsigned
   */
  public $contribution_page_id;
  /**
   * Total pledged amount.
   *
   * @var float
   */
  public $amount;
  /**
   * Original amount for each of the installments.
   *
   * @var float
   */
  public $original_installment_amount;
  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string
   */
  public $currency;
  /**
   * Time units for recurrence of pledge payments.
   *
   * @var string
   */
  public $frequency_unit;
  /**
   * Number of time units for recurrence of pledge payments.
   *
   * @var int unsigned
   */
  public $frequency_interval;
  /**
   * Day in the period when the pledge payment is due e.g. 1st of month, 15th etc. Use this to set the scheduled dates for pledge payments.
   *
   * @var int unsigned
   */
  public $frequency_day;
  /**
   * Total number of payments to be made.
   *
   * @var int unsigned
   */
  public $installments;
  /**
   * The date the first scheduled pledge occurs.
   *
   * @var datetime
   */
  public $start_date;
  /**
   * When this pledge record was created.
   *
   * @var datetime
   */
  public $create_date;
  /**
   * When a pledge acknowledgement message was sent to the contributor.
   *
   * @var datetime
   */
  public $acknowledge_date;
  /**
   * Last updated date for this pledge record.
   *
   * @var datetime
   */
  public $modified_date;
  /**
   * Date this pledge was cancelled by contributor.
   *
   * @var datetime
   */
  public $cancel_date;
  /**
   * Date this pledge finished successfully (total pledge payments equal to or greater than pledged amount).
   *
   * @var datetime
   */
  public $end_date;
  /**
   * The maximum number of payment reminders to send for any given payment.
   *
   * @var int unsigned
   */
  public $max_reminders;
  /**
   * Send initial reminder this many days prior to the payment due date.
   *
   * @var int unsigned
   */
  public $initial_reminder_day;
  /**
   * Send additional reminder this many days after last one sent, up to maximum number of reminders.
   *
   * @var int unsigned
   */
  public $additional_reminder_day;
  /**
   * Implicit foreign key to civicrm_option_values in the pledge_status option group.
   *
   * @var int unsigned
   */
  public $status_id;
  /**
   *
   * @var boolean
   */
  public $is_test;
  /**
   * The campaign for which this pledge has been initiated.
   *
   * @var int unsigned
   */
  public $campaign_id;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_pledge';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'financial_type_id', 'civicrm_financial_type', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contribution_page_id', 'civicrm_contribution_page', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'campaign_id', 'civicrm_campaign', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'pledge_id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge ID') ,
          'description' => 'Pledge ID',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge.id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
        ) ,
        'pledge_contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID') ,
          'description' => 'Foreign key to civicrm_contact.id .',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge.contact_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => array(
            'type' => 'EntityRef',
          ) ,
        ) ,
        'pledge_financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Type') ,
          'description' => 'FK to Financial Type',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'pledge_contribution_page_id' => array(
          'name' => 'contribution_page_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Contribution Page') ,
          'description' => 'The Contribution Page which triggered this contribution',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contribute_DAO_ContributionPage',
        ) ,
        'pledge_amount' => array(
          'name' => 'amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Total Pledged') ,
          'description' => 'Total pledged amount.',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'import' => true,
          'where' => 'civicrm_pledge.amount',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'pledge_original_installment_amount' => array(
          'name' => 'original_installment_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Original Installment Amount') ,
          'description' => 'Original amount for each of the installments.',
          'required' => true,
          'precision' => array(
            20,
            2
          ) ,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'currency' => array(
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Pledge Currency') ,
          'description' => '3 character string, value from config setting or input via user.',
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'default' => 'NULL',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'name',
          )
        ) ,
        'pledge_frequency_unit' => array(
          'name' => 'frequency_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Pledge Frequency Unit') ,
          'description' => 'Time units for recurrence of pledge payments.',
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'default' => 'month',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'recur_frequency_units',
            'keyColumn' => 'name',
            'optionEditPath' => 'civicrm/admin/options/recur_frequency_units',
          )
        ) ,
        'pledge_frequency_interval' => array(
          'name' => 'frequency_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Frequency Interval') ,
          'description' => 'Number of time units for recurrence of pledge payments.',
          'required' => true,
          'default' => '1',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'frequency_day' => array(
          'name' => 'frequency_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge day') ,
          'description' => 'Day in the period when the pledge payment is due e.g. 1st of month, 15th etc. Use this to set the scheduled dates for pledge payments.',
          'required' => true,
          'default' => '3',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'installments' => array(
          'name' => 'installments',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Number of Installments') ,
          'description' => 'Total number of payments to be made.',
          'default' => '1',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'start_date' => array(
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Start Date') ,
          'description' => 'The date the first scheduled pledge occurs.',
          'required' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'pledge_create_date' => array(
          'name' => 'create_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Made') ,
          'description' => 'When this pledge record was created.',
          'required' => true,
          'import' => true,
          'where' => 'civicrm_pledge.create_date',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'acknowledge_date' => array(
          'name' => 'acknowledge_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Acknowledged') ,
          'description' => 'When a pledge acknowledgement message was sent to the contributor.',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'modified_date' => array(
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Modified Date') ,
          'description' => 'Last updated date for this pledge record.',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
        ) ,
        'cancel_date' => array(
          'name' => 'cancel_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge Cancelled Date') ,
          'description' => 'Date this pledge was cancelled by contributor.',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'end_date' => array(
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Pledge End Date') ,
          'description' => 'Date this pledge finished successfully (total pledge payments equal to or greater than pledged amount).',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select Date',
          ) ,
        ) ,
        'max_reminders' => array(
          'name' => 'max_reminders',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Maximum Number of Reminders') ,
          'description' => 'The maximum number of payment reminders to send for any given payment.',
          'default' => '1',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'initial_reminder_day' => array(
          'name' => 'initial_reminder_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Initial Reminder Day') ,
          'description' => 'Send initial reminder this many days prior to the payment due date.',
          'default' => '5',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Select',
          ) ,
        ) ,
        'additional_reminder_day' => array(
          'name' => 'additional_reminder_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Additional Reminder Days') ,
          'description' => 'Send additional reminder this many days after last one sent, up to maximum number of reminders.',
          'default' => '5',
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'pledge_status_id' => array(
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Pledge Status Id') ,
          'description' => 'Implicit foreign key to civicrm_option_values in the pledge_status option group.',
          'import' => true,
          'where' => 'civicrm_pledge.status_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => false,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'pseudoconstant' => array(
            'optionGroupName' => 'pledge_status',
            'optionEditPath' => 'civicrm/admin/options/pledge_status',
          )
        ) ,
        'pledge_is_test' => array(
          'name' => 'is_test',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Test') ,
          'import' => true,
          'where' => 'civicrm_pledge.is_test',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'pledge_campaign_id' => array(
          'name' => 'campaign_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign') ,
          'description' => 'The campaign for which this pledge has been initiated.',
          'import' => true,
          'where' => 'civicrm_pledge.campaign_id',
          'headerPattern' => '',
          'dataPattern' => '',
          'export' => true,
          'table_name' => 'civicrm_pledge',
          'entity' => 'Pledge',
          'bao' => 'CRM_Pledge_BAO_Pledge',
          'localizable' => 0,
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_campaign',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          )
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'pledge', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'pledge', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'index_status' => array(
        'name' => 'index_status',
        'field' => array(
          0 => 'status_id',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_pledge::0::status_id',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
