.PS
# Dini.m4
# This diagram can be produced using, e.g.
# m4 pdf.m4 Dini.m4 | dpic -d > Dini.pdf

threeD_init
NeedDpicTools
scale = 1.5

  viewazimuth = 0                 # View angles in degrees
  viewelevation = 20
  setview(viewazimuth,viewelevation,0)

  a = 1.5
  b = 0.25

define(`Dini',
`a*cos(`$1')*sin(`$2'),dnl
 a*sin(`$1')*sin(`$2'),dnl
 (a*(cos(`$2')+loge(tan((`$2')/2))) + b*(`$1'))')

 umin = 0; umax = 4*pi_
 vmin = 0.2; vmax = 2.0
 ugrid = 80; vgrid = 20

 ur = umax-umin
 vr = vmax-vmin
`define cu {umin+($1)/ugrid*ur}'
`define cv {vmin+($1)/vgrid*vr}'

#                           Generate points and sort
 n = -1
 for iu=0 to ugrid do {
   for iv=0 to vgrid do {
     n +=1
     ciu[n] = cu(iu)
     civ[n] = cv(iv)
     d[n] = dot3D(View3D,Dini(ciu[n],civ[n]))
     ix[n] = n
     }
   }
 dpquicksort(d,0,n,ix)

#                           Draw the facets
 linethick = 0.4
 du = ur/ugrid/2
 dv = vr/vgrid/2
 for i=0 to n do {
   NE: project(Dini(ciu[ix[i]]+du,civ[ix[i]]+dv))
   SE: project(Dini(ciu[ix[i]]+du,civ[ix[i]]-dv))
   SW: project(Dini(ciu[ix[i]]-du,civ[ix[i]]-dv))
   NW: project(Dini(ciu[ix[i]]-du,civ[ix[i]]+dv))
   f = (-cos(ciu[ix[i]])+1)/2
   g = ( sin(ciu[ix[i]])+1)/2
   line from NE to SE then to SW then to NW then to NE \
     outlined rgbstring(0,0.5,0) shaded rgbstring(f,g,0)
   }

.PE
