#include "cp_types.h"
#include "cp_proto.h"

/* ==================== welding calls ===============================
   code first created by Brock Williams, 1999, part of PhD thesis work
=================================================================*/

extern char buf[];
extern int handle_cmd(),add_between();

int weldcall(char *datastr)
/* Parse datastr and call weld(). Return 0 if error. */
{
        int pnum1,pnum2,v1,v2;
	char filename[NAME_MAX];
	struct p_data *p1,*p2;
	
	if (sscanf(datastr,"%d %d %d %d %s",&pnum1,&pnum2,&v1,&v2,filename)==5
		&& pnum1>=0 && pnum2>=0)
	 {
	   if (weld(pnum1,pnum2,v1,v2,filename))
	     {
               p1=&packdata[pnum1];p2=&packdata[pnum2];
	       complex_count(p1,0);complex_count(p2,0);
	       fillcurves(p1);fillcurves(p2);
	       facedraworder(p1,0);facedraworder(p2,0);
	       set_aim_default(p1);set_aim_default(p2);
	       p1->active_node=p1->beta; p2->active_node=p2->beta;
	       sprintf(msgbuf,"weld %d %d %d %d %s;",
	       pnum1,pnum2,v1,v2,filename);
	       msg();return 1;
	     }
	   else
	     {
	       strcpy(msgbuf,"Something went wrong with 'weld' routine.");
	       emsg();return 0;
	     }
	 }

	return 0;
} /* weldcall */

int weld(int pnum1,int pnum2,int v,int w,char *filename)
/* Might want to replace old V_LIST and E_LIST
in the new pack with the newly adjoined list.  Or better still add to
the end of the current list.  Then we could save the old and recover
or adjoin more than one part of the pack and not lose the old list
on subseqent calls */
{
        int count,v_next,w_next,v_orig=v,w_orig=w,*Oldnew;
        char command[64];
	FILE *weldfile;
	struct p_data *p,*q;
	struct K_data *pK_ptr,*qK_ptr;

	p=&packdata[pnum1];q=&packdata[pnum2];

	if( (v>p->nodecount) || (w>q->nodecount) || (v<1) || (w<1) ||
	    (!p->packK_ptr[v].bdry_flag) || (!q->packK_ptr[w].bdry_flag))
	  {
	         sprintf(msgbuf,"Vertices %d and %d cannot be used",v,w);
		 emsg();
		 return -1;
	  }

       
/* Should copy original packs to new packs p and q in case this bombs */

	if ( !p->status || !q->status || p->locks)
	  return 0;


/* Augment p and q */

	
	if( (weldfile=fopen(filename,"r"))==NULL)
	 {
	 	sprintf(msgbuf,"Error: Could not open %s.",filename);
	 	emsg();return(0);
	  }
	
	count= 0;

       pK_ptr=p->packK_ptr;
       qK_ptr=q->packK_ptr;
       v_next=pK_ptr[v].flower[pK_ptr[v].num];
       w_next=qK_ptr[w].flower[0];

	while( (fscanf(weldfile,"%63s",command)!=EOF) 
		&& (strcmp(command,"END")!=0) )
	 {
	        count=count+1;
	        if(strcmp(command,"V")==0) 
		  {
		         if( ((v==pK_ptr[v_orig].flower[pK_ptr[v_orig].num])
			      || (w==qK_ptr[w_orig].flower[0])) && (count>2)) 
			   {
			          sprintf(msgbuf,"Welding list "
					  "is longer than boundary");
				  emsg();
				  return -1;
			   }
			 v=v_next;
			 v_next=pK_ptr[v].flower[pK_ptr[v].num];
		  }
		else if (strcmp(command,"N")==0)
		  {
		         if(!add_between(p,v_next,v)) return (0);
			 v=pK_ptr[v].flower[pK_ptr[v].num];
			 /* v=newly added N vertex */
		  }
		else 
		  {  /* Odd stuff */
		         sprintf(msgbuf,"Error in weld file "
				 "format - first part");
			 emsg();
			 return -1;
		  }


		if((fscanf(weldfile,"%63s",command)==EOF) 
		|| (strcmp(command,"END")==0) )
		  {
		         sprintf(msgbuf,"Error in weld file "
				 "format - second part");
			 emsg();
			 return -1;
		  }
		
		if(strcmp(command,"v")==0)
		  {
 		       if((w==pK_ptr[w_orig].flower[0]) && (count>2)) 
			   {
			          sprintf(msgbuf,"Welding list is "
					  "longer than boundary");
				  emsg();
				  return -1;
			   }
			 w=w_next;
			 w_next=qK_ptr[w].flower[0];
		  }
		
		else if (strcmp(command,"n")==0)
		  {
		         add_between(q,w,w_next);
			 w=qK_ptr[w].flower[0];
		  }
		
		else
		   {  /* Odd stuff */
		         sprintf(msgbuf,"Error in weld file "
				 "format - first part");
			 emsg();
			 return -1;
		  }
	 }


sprintf(buf,"set_vlist -p%d b(%d,%d)",pnum1,v,v_orig);
handle_cmd(buf,&pnum1);


/* Adjoin p and q   Assumes pK_ptr[v].bdry_flag has been set*/
	
	if(!adjoin(p,q,v_orig,w_orig,count-1,&Oldnew)) return 0;

        return (1);


} /* weld */

int add_between(struct p_data *p,int v,int v_next)
/* Adds a new vert on boundary between v and v_next.
Assumes both v, v_next are on boundary and v_next=pK_ptr[v].flower[0].
Results in     v_next +++++ newvert +++++ v
		     ++	       +      ++
			++     +    ++
			   ++  u ++                               */
{
	int i,u,*f,n,j,ucount;
	struct K_data *pK_ptr;
	
	pK_ptr=p->packK_ptr;

/* Basic checks */
	if ( (!pK_ptr[v].bdry_flag)||(!pK_ptr[v_next].bdry_flag) ||
	     (pK_ptr[v].num<=1)||(pK_ptr[v_next].num<=1) )
	  return (0);

	alloc_pack_space(p,p->nodecount+1,1);/* 1 means add to p, not new one*/
	
	i=p->nodecount +1;
	p->nodecount=p->nodecount+1;
	
	
	u=pK_ptr[v].flower[1];
	
/* fix v and v_next */

	pK_ptr[v].flower[0]=i;
	pK_ptr[v_next].flower[pK_ptr[v_next].num]=i;
	
/* fix i */

	free(pK_ptr[i].flower);
	pK_ptr[i].flower= (int *)
	  calloc((size_t)4,sizeof(int));
	pK_ptr[i].flower[0]=v_next;
	pK_ptr[i].flower[1]=u;
	pK_ptr[i].flower[2]=v;
	pK_ptr[i].num=2;
	pK_ptr[i].bdry_flag=1;
	p->packR_ptr[i].rad=0.5;

/* fix u */

	f=pK_ptr[u].flower;
	pK_ptr[u].flower=(int *) 
	   calloc((size_t)(pK_ptr[u].num+2),sizeof(int));
	n=pK_ptr[u].num;
	pK_ptr[u].num++;
	
	if(f[0]==f[n])  /* u is an interior vertex */
	 {
	 	
		if(f[0]==v)	/* found insertion place already */
		 {
		        pK_ptr[u].flower[0]=v;
	 		pK_ptr[u].flower[1]=i;
	 	
	 		for(j=2;j<=n+1;j++)
	 	 	 {
	 	 		pK_ptr[u].flower[j]=f[j-1];
	 	 	 }
	   	 }
		else		/* find insertion place */
		 {
		 	ucount=0;
	 		for(j=0;j<=n;j++)
	 		 {
	 	 		if(f[j]==v)
	 	 		 {
	 	 	 		pK_ptr[u].flower[ucount]=v;
	 	 	 		pK_ptr[u].flower[ucount+1]=i;
	 	 	 		ucount=ucount+2;
	 	 	 	  }
	 	 		else
	 	 		 {
	 	 			pK_ptr[u].flower[ucount]=f[j];
	 	 			ucount=ucount+1;
	 	 		 }
	 	 	}
	  	 }
		
		free(f);
	 }
	else  /* u is also a boundary vertex */
	 {
	 	ucount=0;
	 	for(j=0;j<=n;j++)
	 	 {
	 	 	if((f[j]==v) && (f[j+1]==v_next)) /* add to L */
	 	 	 {
	 	 	 	pK_ptr[u].flower[j]=v;
	 	 	 	pK_ptr[u].flower[j+1]=i;
	 	 	 	ucount=j+1;
	 	 	 }
	 	 	else if((f[j]==v_next) && (f[j+1]==v)) /* add to U */
	 	 	 {
	 	 	 	pK_ptr[u].flower[j]=v_next;
	 	 	 	pK_ptr[u].flower[j+1]=i;
	 	 	 	ucount=j+1;
	 	 	  }
	 	 	 else
	 	 	  {
	 	 	  	pK_ptr[u].flower[ucount]=f[j];
	 	 	  	ucount=ucount+1;
	 	 	   }
	 	 } 
	 	
	       free(f);	 
	 }

      return (1);

} /* add_between */
