#include "cp_types.h"
#include "cp_proto.h"

/* slit complex along edge chain, which is
   created from list of vertices. Chain may start at
   bdry or int, continue while interior, shouldn't disconnect complex.
   Not very solid -- bad path may screw up complex. For interior cut,
   need at least two edges. Lose overlap data. */

int slit_complex(struct p_data *p,char *datastr)
{
  int ind,back,forward,new,k,v,w,next,num,wnum,u,hits;
  int *oldflower,*newflower;
  struct Vertlist *vertlist,*vtrace;
  struct Edgelist *edgelist,*trace;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;
  char *endptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
		 &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) == NULL )
    return 0; /* not valid list of vertices */
  free_overlaps(p); /* want to save overlaps, if possible */
  /* make up edgelist */
  vtrace=vertlist;
  v=vtrace->v;
  if (vtrace->next!=NULL && nghb(p,v,(w=vtrace->next->v))>=0)
    edgelist=(struct Edgelist *)calloc((size_t)1,
				       sizeof(struct Edgelist));
  else {vert_free(&vertlist);return 0;} /* no first edge */
  trace=edgelist;
  trace->v=v;
  trace->w=w;
  trace->next=NULL;
  v=w;
  vtrace=vtrace->next;
  while (vtrace->next!=NULL && nghb(p,v,(w=vtrace->next->v))>=0
	 && !pK_ptr[w].bdry_flag)
    /* stops if path disconnects or hits bdry */
    {
      trace->next=(struct Edgelist *)calloc((size_t)1,
					    sizeof(struct Edgelist));
      trace=trace->next;
      trace->v=v;
      trace->w=w;
      v=w;
      vtrace=vtrace->next;
    }
  vert_free(&vertlist);
  /* use it */
  trace=edgelist;
  v=trace->v;
  next=trace->w;
  if (pK_ptr[v].bdry_flag && open_edge(p,v,next)==0) 
    {edge_free(&edgelist);return 0;}  /* failed to open first edge */
  else if (!pK_ptr[v].bdry_flag) 	/* opening interior edge */
    {
      if ((trace=trace->next)==NULL) /* need at least two edges to start */ 
	{edge_free(&edgelist);return 0;} 
      w=next;
      next=trace->w;
      /* three verts are (in order) v,w,next, slitting towards next*/
      /* need one new vert (w splits into two) */
      new=p->nodecount+1;
      if (new>p->sizelimit-1 && !alloc_pack_space(p,new+1,1))
	{
	  sprintf(msgbuf,
		  "Space allocation problem with adding vertex.");
	  emsg();
	  return 0;
	}
      /* fix v */
      ind=nghb(p,v,w);
      newflower=(int *)calloc((size_t)(pK_ptr[v].num+1),
			      sizeof(int));
      for (k=1;k<=pK_ptr[v].num;k++)
	newflower[k]=pK_ptr[v].flower[(k+ind) % pK_ptr[v].num];
      free(pK_ptr[v].flower);
      pK_ptr[v].flower=newflower;
      pK_ptr[v].flower[0]=new;
      pK_ptr[v].bdry_flag=1;
      /* fix w */
      back=nghb(p,w,v);
      forward=nghb(p,w,next);
      num=(forward+pK_ptr[w].num-back) % (wnum=pK_ptr[w].num);
      oldflower=(int *)calloc((size_t)(pK_ptr[w].num+1),
			      sizeof(int));
      for (k=0;k<=pK_ptr[w].num;k++)
	oldflower[k]=pK_ptr[w].flower[k];
      newflower=(int *)calloc((size_t)(num+1),sizeof(int));
      for (k=0;k<=num;k++)
	newflower[k]=oldflower[(k+back) % wnum];
      free(pK_ptr[w].flower);
      pK_ptr[w].flower=newflower;
      pK_ptr[w].num=num;
      pK_ptr[w].bdry_flag=1;
      free(oldflower);
      /* fix next */
      ind=nghb(p,next,w);
      newflower=(int *)calloc((size_t)(pK_ptr[next].num+1),
			      sizeof(int));
      for (k=0;k<pK_ptr[next].num;k++)
	newflower[k]=pK_ptr[next].flower
	  [(k+ind) % pK_ptr[next].num];
      free(pK_ptr[next].flower);
      pK_ptr[next].flower=newflower;
      pK_ptr[next].flower[pK_ptr[next].num]=new;
      pK_ptr[next].bdry_flag=1;
      /* fix new */
      num=(back+wnum-forward) % wnum;
      pK_ptr[new].flower=(int *)calloc((size_t)(num+1),
				       sizeof(int));
      for (k=1;k<num;k++)
	pK_ptr[new].flower[k]=oldflower[(k+forward) % wnum];
      pK_ptr[new].flower[0]=next;
      pK_ptr[new].flower[num]=v;
      pK_ptr[new].num=num;
      pK_ptr[new].bdry_flag=1;
      for (k=1;k<num;k++)
	{
	  back=nghb(p,(u=pK_ptr[new].flower[k]),w);
	  pK_ptr[u].flower[back]=new;
	}
      pR_ptr[new].rad=pR_ptr[w].rad;
      pR_ptr[new].center=pR_ptr[w].center;
      p->nodecount++;
    } /* end of else */
  /* now, continue opening prescribed edges */
  while ((v=next) && (trace=trace->next)!=NULL
	 && open_edge(p,v,(next=trace->w)));
  complex_count(p,0);
  facedraworder(p,0);
  if (trace==NULL)
    {
      edge_free(&edgelist);
      return 1;
    }
  edge_free(&edgelist);
  return 0;
} /* slit_complex */
