#include "cp_types.h"
#include "cp_proto.h"

/* various changes in screen settings */

int set_screen(struct p_data *p,char *datastr)
{
  int i,v,count=0;
  double x,y,h,hh,factor,maxh,maxw,dist;
  char *nextpoint,next[BUFSIZE],buff[256];
  struct s_data *q;

  q=p->screen;
  nextpoint=datastr;
  if (!grab_next(&nextpoint,next) || next[0]!='-')
    return 0;
  do
    {
      if (next[0]!='-') return count;
      if (next[1]=='d' || (next[1]=='a' && p->hes<0)) /* default */
	{
	  x=(q->box.rx+q->box.lx)/2.0;
	  y=(q->box.ry+q->box.ly)/2.0; 
	  factor=((double)q->pix_box.rx)/((double)q->pix_box.ry);
	  /* same apperture, smallest size = 1.1 */
	  if (factor<=1) hh=1.1;
	  else hh=1.1*factor;
	  q->box.rx=hh;q->box.lx=-hh;
	  if (factor<=1) hh=1.1/factor;
	  else hh=1.1;
	  q->box.ry=hh;q->box.ly=-hh;
	  count++;
	}
      else if (next[1]=='c' || next[1]=='v') 
	/* center screen on x y coord or vert v */
	{
	  i=0;
	  if (next[1]=='v' && (v=grab_one_vert(p,&nextpoint)))
	    {
	      x=p->packR_ptr[v].center.re;
	      y=p->packR_ptr[v].center.im;
	      i=1;
	    }
	  else if (next[1]=='c' 
		   && grab_next(&nextpoint,next)
		   && sscanf(next,"%lf",&x)==1 
		   && grab_next(&nextpoint,next)
		   && sscanf(next,"%lf",&y)==1 )
	    {i=1;}
	  if (i)
	    {
	      if (p->hes>0)
		{
		  sprintf(buff,"0.0 0.0 %f",-x/M_PI);
		  sphere_view(q,buff);
		  sprintf(buff,"-i 0.0 %f 0.0",y/M_PI-.5);
		  sphere_view(q,buff);
		}
	      else
		{ 
		  h=(q->box.ry-q->box.ly)/2.0;
		  q->box.ry=y+h; q->box.ly=y-h;
		  hh=(q->box.rx-q->box.lx)/2.0;
		  q->box.rx=x+hh; q->box.lx=x-hh;
		}
	      count++;
	    }
	}
      else if (next[1]=='h') /* set height (and width) */
	{
	  if (grab_next(&nextpoint,next)
	      && sscanf(next,"%lf",&h)==1 
	      && h>0.0)
	    {
	      hh = h/2.0;
	      y=(q->box.ry+q->box.ly)/2.0;
	      q->box.ry=y+hh; q->box.ly=y-hh;
	      x=(q->box.rx+q->box.lx)/2.0;
	      hh=h*(q->pix_box.rx)/q->pix_box.ry/2.0;
	      q->box.rx=x+hh; q->box.lx=x-hh;
	      count++;
	    }
	}
      else if (next[1]=='f') /* mult height by factor*/
	{
	  if (grab_next(&nextpoint,next)
	      && sscanf(next,"%lf",&factor)==1
	      && factor > 0.01)
	    {
	      h=q->box.ry-q->box.ly;
	      hh = h*factor/2.0;
	      y=(q->box.ry+q->box.ly)/2.0;
	      q->box.ry=y+hh;q->box.ly=y-hh;
	      x=(q->box.rx+q->box.lx)/2.0;
	      hh=hh*(q->pix_box.rx)/q->pix_box.ry;
	      q->box.lx=x-hh;q->box.rx=x+hh;
	      count++;
	    }
	}
      else if (next[1]=='a' && p->hes==0)  
          /* for eucl packs, adjust size to show all circles */
	    {
	      x=(q->box.rx+q->box.lx)/2.0;
	      y=(q->box.ry+q->box.ly)/2.0;
	      maxw = fabs(fabs(p->packR_ptr[1].center.re)+
			  p->packR_ptr[1].rad-x);
	      maxh = fabs(fabs(p->packR_ptr[1].center.im)+
			  p->packR_ptr[1].rad-y);
	      for (i=2;i<=p->nodecount;i++)
		{
		  dist=fabs(fabs(p->packR_ptr[i].center.re)+
			  p->packR_ptr[i].rad-x);
		  if (dist>maxw) maxw=dist;
		  dist=fabs(fabs(p->packR_ptr[i].center.im)+
			  p->packR_ptr[i].rad-y);
		  if (dist>maxh) maxh=dist;
		}
	      if (maxh>okerr && maxw>okerr)
		{
		  factor=((double)q->pix_box.rx)/((double)q->pix_box.ry);
		  if (maxw/maxh>factor)
		    {
		      hh=(1.1)*maxw;
		      q->box.rx=x+hh;q->box.lx=x-hh;
		      hh = hh/factor;
		      q->box.ry=y+hh;q->box.ly=y-hh;
		      count++;
		    }    
		  else
		    {
		      hh=(1.1)*maxh;
		      q->box.ry=y+hh;q->box.ly=y-hh;
		      hh = hh*factor;
		      q->box.rx=x+hh;q->box.lx=x-hh;
		      count++; 
		    }
		}
	      else if (next[1]=='a') /* wrong geometry but
					not an error */
		count++;
	    }
    } /* end of do */
  while (nextpoint!=NULL && grab_next(&nextpoint,next) );
  return count;
} /* set_screen */
