#include "cp_head.h"

/* Report the ratio length/height of a eucl packing, presumably 
in form of a rectangle. Give the four corners in counterclockwise 
order, lower-left first. Return status:
  0: error
  1: okay
  -1: data giving lengths/heights aren't consistent with a 
     rectangle (off by > 5%).
*/

int rect_ratio(struct p_data *p,char *datastr,double *aspect)

{
  int i=0,corner[4],hits;
  char *endptr;
  double leng,leng2,high,high2;
  struct Vertlist *vertlist=NULL,*trace;
  struct R_data *pR_ptr;
	
  if ( (p->hes!=0) || !(vertlist=Node_link_parse(p,datastr,&endptr,&hits,
		       &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) )
    return 0;
  trace=vertlist;
  while (i<4 && trace) 
    {
      corner[i]=trace->v;
      i++;
      trace=trace->next;
    }
  if (i<4) {vert_free(&vertlist);return 0;}
  for (i=0;i<4;i++) 
    if (!(p->packK_ptr[corner[i]].bdry_flag))
      {vert_free(&vertlist);return 0;}
  /* note: first corner is assumed to be lower-left, rest ctrclkwise.*/
  vert_free(&vertlist);
  pR_ptr=p->packR_ptr;
  leng=cAbs(csub(pR_ptr[corner[0]].center,pR_ptr[corner[1]].center));
  high=cAbs(csub(pR_ptr[corner[1]].center,pR_ptr[corner[2]].center));
  leng2=cAbs(csub(pR_ptr[corner[2]].center,pR_ptr[corner[3]].center));
  high2=cAbs(csub(pR_ptr[corner[3]].center,pR_ptr[corner[0]].center));
  /* check for inconsistency with rectangle */
  if (leng<okerr || leng2<okerr || high<okerr || high2<okerr
      || fabs((leng-leng2)/leng)>.05 || fabs((high-high2)/high)>.05)
    return -1;
  *aspect=leng/high;
  return 1;
} /* rect_ratio */
