#include "cp_types.h"
#include "cp_proto.h"

/* find first instance in layout where 2 circles being used for 
plotting a third are NOT in correct position vis-a-vis one another -- 
inv_dist is wrong. */

int placement_err(struct p_data *p,double tolr)
{
  int nf=p->first_face,count,i,w,j,k,indx;
  double inv_err;

  for (i=1;i<=p->nodecount;i++) p->packK_ptr[i].util_flag=0;
  for (i=0;i<3;i++) p->packK_ptr[p->faces[nf].vert[i]].util_flag=1;
  count=3;
  sprintf(msgbuf,"Checking for placement errors:");
  msg();

  while ((nf=p->faces[nf].next_face) != p->first_face)
    {
      indx=p->faces[nf].index_flag;
      j=p->faces[nf].vert[indx];
      k=p->faces[nf].vert[(indx+1)%3];
      w=p->faces[nf].vert[(indx+2)%3];
      if (!p->packK_ptr[w].util_flag)
	{
	  if (!p->packK_ptr[j].util_flag || !p->packK_ptr[k].util_flag)
	    {
	      sprintf(msgbuf,"drawing order error: expect to use face %d to place %d, but other verts %d and %d not both yet placed.",
		      nf,w,j,k);
	      emsg();
	      return 0;
	    }
	  count++;
	  p->packK_ptr[w].util_flag=1;
	  if (fabs((inv_err=invdist_err(p,j,k)))>tolr)
	    {
	      sprintf(msgbuf,"   First placement error in trying "
		      "to place the %d circle, vertex %d, face %d:\n   "
		      "circles being used (%d and %d) have error "
		      "of %f in inv_distance.",
		      count,w,nf,j,k,inv_err);
	      msg();
	      return w;
	    }
	  if (fabs((inv_err=invdist_err(p,j,w)))>tolr)
	    {
	      sprintf(msgbuf,"   Placement error, circle %d, face %d:\n   "
		      "%d and %d have error %f in inv_distance.",
		      w,nf,w,j,inv_err);
	      msg();
	      return w;
	    }
	}
    } /* end of while */
  sprintf(msgbuf,"All placements seem to be within 1000*toler.");
  msg();
  return count;
} /* placement_err */
