#include "cp_types.h"
#include "cp_proto.h"

/* given a closed chain of faces, mark outer vertices as "poison" 
by seting util_flag; for use in computing face drawing order. 
facelist is unchanged. */

int outer_poison(struct p_data *p,struct Vertlist *facelist)
{
  int i,f,f1,f2,ind,count=0;
  struct Vertlist *trace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;
  if (facelist && facelist->next && facelist->next->next) 	
    {
      trace=facelist;
      while (trace->next->next!=NULL) trace=trace->next;
      f=trace->v; /* find last face */
      trace=facelist;
      while (trace->next!=NULL) /* cycle to end */
	{
	  f1=f;
	  f=trace->v;
	  f2=trace->next->v;
	  if ((ind=nghb_tri(p,f2,f))>=0)
	    {
	      pK_ptr[p->faces[f].vert[ind]].util_flag = -1;
	      count++;
	    }
	  else if (nghb_tri(p,f2,f1)>=0) /* f is blue;
					    meaning list goes "f1->f->f2".*/
	    {
	      for (i=0;i<3;i++) 
		pK_ptr[p->faces[f].vert[i]].util_flag =-1;
	      count += 2;
	    }
	  trace=trace->next;
	}
    }
  return count;
} /* outer_poison */


