#include "cp_types.h"
#include "cp_proto.h"

/* For marking and incremental measuring of generations of vertices of p
   from specified 'seed' verts. Set util_flag to show generation, the 
   seed verts as 1. Return various counts:
   'mark_count' specifies a num of generations and returns
   the number of verts through that generation;
   'min_gen' = first generation for which total count was at least 
   'target_size'. Return value is max generation reached.
   Return 0 on error. Note: seed_list will be emptied, util_flags of 
   p will be set. */

int incr_generations(struct p_data *p,struct Vertlist **seed_list,
		int *mark_count,int *min_gen,int target_size)
{
  int i,j,v,gen_count=2,hits=0,total=0,mark;
  struct Vertlist *genlist,*vertlist,*gtrace,*vtrace;
  struct K_data *pK_ptr;

  if (!p->status) return 0;
  pK_ptr=p->packK_ptr;
  mark=*mark_count;
  *mark_count=-1;
  *min_gen=-1;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=-1;
  genlist=*seed_list;
  seed_list=NULL;
  if (!genlist) /* use alpha vert (or 1) as default */
    {
      genlist=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      genlist->v=p->alpha;
      if ((genlist->v < 1) || (genlist->v > p->nodecount)) genlist->v=1;
    }
  if (target_size<0) target_size=p->nodecount; /* no bound */

  /* label first generation */
  gtrace=genlist;
  while(gtrace) 
    {
      pK_ptr[gtrace->v].util_flag=1;
      gtrace=gtrace->next;
      total++;
    }
  if (total==0 || total==p->nodecount)
    {
      vert_free(&genlist);
      return 0;
    }
  while (!hits && genlist)
    {
      hits=1;
      vertlist=genlist; /* process old list */
      genlist=gtrace=   /* create new list */
	(struct Vertlist *)calloc((size_t)1,sizeof(struct Vertlist));
      do
	{
	  v=vertlist->v;
	  for (i=0;i<=pK_ptr[v].num;i++)
	    if (pK_ptr[(j=pK_ptr[v].flower[i])].util_flag < 0)
	      {
		pK_ptr[j].util_flag=gen_count;
		gtrace->next=gtrace=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		gtrace->v=j;
		total++;
		hits=0;
	      }
	  vtrace=vertlist;
	  vertlist=vertlist->next;
	  free(vtrace);
	}
      while (vertlist);
      gtrace=genlist;
      genlist=genlist->next; /* first position was empty */
      free(gtrace);
      /* check for setting various counters */
      if (gen_count==mark) *mark_count=total;
      if (total>target_size && (*min_gen)<0) *min_gen=gen_count;
      gen_count++;
    }
  if (genlist) vert_free(&genlist);
  return (gen_count-1);
} /* incr_generations */

