#include "cp_types.h"
#include "cp_proto.h"

/* normalizes hyperbolic data of pack p by putting point c 
at origin and d on pos y-axis */

int h_norm_pack(struct p_data *p,complex c,complex d)
{
  int i,wflag=0;
  double abd;
  complex temp;
  struct R_data *pR_ptr;
  struct RedList *trace;

  pR_ptr=p->packR_ptr;
  if (cAbs(c)>=okerr) /* j vertex not origin */
    {
      for (i=1;i<=p->nodecount;i++)
	pR_ptr[i].center=mob_norm(pR_ptr[i].center,c,d);
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    trace->center=mob_norm(trace->center,c,d);
	    trace=trace->next;
	  }
    }
  else if (d.im>=okerr || d.im<=(-okerr) || d.re<=(-okerr))
    /* just a rotation is needed */
    {
      abd=1.0/cAbs(d);
      d.re *= abd;
      d.im *= abd;
      for (i=1;i<=p->nodecount;i++)
	pR_ptr[i].center=cdiv(pR_ptr[i].center,d);
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    trace->center=cdiv(trace->center,d);
	    trace=trace->next;
	  }
    }
  /* In either case, rotate another 90 degrees to put on 
     y-axis--- fixup? need to clean this up ?? */
  for (i=1;i<=p->nodecount;i++)
    {
      temp=pR_ptr[i].center;
      pR_ptr[i].center.re=(-temp.im);
      pR_ptr[i].center.im=temp.re;
    }
  wflag=0;
  if ((trace=p->redfaces))
    while (p->redfaces && (trace!=p->redfaces || !(wflag++)))
      {
	temp=trace->center;
	trace->center.re=(-temp.im);
	trace->center.im=temp.re;
	trace=trace->next;
      }
  return 1;
} /* h_norm_pack */




