#include "cp_types.h"
#include "cp_proto.h"

int gen_mark(struct p_data *p,char *datastr)
     /* mark generations, starting from given seeds as first generation.
util_flag's used to pass seed info to label_generations routine.
Command -m to set max generation; rest of input describes 'seed'
vertices. */
{
  int i,max=-1,*list,last_vert=0,hits,vert_count;
  char *nextpoint,*endptr;
  struct Vertlist *seedlist=NULL,*vtrace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  nextpoint=datastr;
  stripsp(datastr);
  /* is a max generation specified? */
  if (nextpoint[0]=='-' && nextpoint[1]=='m') 
    {
      nextpoint += 2;
      if (!sscanf(nextpoint,"%d",&max) || max<1)
	max=0;
    }
  /* get list of verts in generation 1; alpha is default */
  if (!(seedlist=Node_link_parse(p,nextpoint,&endptr,&hits,&Vlist,
				 &Elist,&Flist,&region,pathlist,pathlength)))
    {
      seedlist=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      seedlist->v=p->alpha;
    }
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;
  vtrace=seedlist;
  while (vtrace)
    {
      pK_ptr[vtrace->v].util_flag=1;
      vtrace=vtrace->next;
    }
  vert_free(&seedlist);
  
  if (!(list=label_generations(p,max,&last_vert,&vert_count)))
    return 0;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].mark=list[i];
  free(list);

  return last_vert;
} /* gen_mark */
