#include "cp_types.h"
#include "cp_proto.h"

/* Parse and carry out options for 'fix' and 'Fix'; that is, laying 
   out a packing based on radii, checking combinatorics, etc. */

int fix_call(struct p_data *p,char *datastr)
/* for "Fix" command and fix calls */
{
	int i,count=0,hits,v,w,n,flag=0,d;
	int errflag=0,dflag=0,opt=2;
	char ch,next[BUFSIZE];
	double crit;
	struct Vertlist *facelist=NULL;
	char *nextptr,*endptr;

	nextptr=datastr;
	if (!p->status) return 0; /* no packing */
	while (grab_next(&nextptr,next) && next[0]=='-') /* flags set */
	 {
		flag=1;
		switch(next[1])
		 {
		   case 'a': /* default aims */
		    {
			set_aim_default(p);
			count++;
			break;
		    }
		   case 'c': /* centers (with options) */
		    {
		      i=2;
		      while ((ch=next[i])!='\0')
			{
			  if (ch=='d') dflag=1;
			  else if (ch=='f') errflag=1;
			  else if (ch=='s') opt=1;
			  else if (ch=='c' && sscanf(nextptr,"%lf",&crit));
			  i++;
			}
		      comp_pack_centers(p,errflag,dflag,opt,crit);
		      count++;
		      break;
		    }
		   case 'd': /* layout by drawing order, report, return */
		    {
		      if (!(v=grab_one_vert(p,&nextptr)))
			return 0;
		      layout_report(p,v,1);
		      count++;
		      return count;
		    }			
		   case 'F': /* redo everything */
		    {
			complex_count(p,1);
			facedraworder(p,0);
			fillcurves(p);
			comp_pack_centers(p,errflag,dflag,opt,layout_th);
			set_aim_default(p);
			count++;
			return count;
		    }
		   case 'f': /* given face list */
		    {
			if ( (facelist=Face_link_parse(p,nextptr,&endptr,
			     &hits,&Vlist,&Elist,&Flist,&region,
			     pathlist,pathlength)) )
			  {
			    outer_poison(p,facelist);
			    count +=facedraworder(p,1);
			    vert_free(&facelist);
			  }
			return count; /* this has to be last flag */
		    }
		   case 'h': /* drawing order via hex_walk routine */
		    {
			if ( sscanf(nextptr,"%d %d %d",&v,&w,&n)!=3
			   || !(facelist=try_hex_pg(p,v,w,n,&d,&d,&d,&d)) ) 
				break;
			if (!facelist) /* some error */
			 {
				sprintf(msgbuf,"hex_walk failed.");
				emsg();
			 }
			else 
			  {
			    outer_poison(p,facelist);
			    count +=facedraworder(p,1);
			  }
			vert_free(&facelist);
			break;
		    }
		   case 'K': /* combinatorics */
		    {
			complex_count(p,0);
			facedraworder(p,0);
			count++;
			break;
		    }
		   case 'r': /* recompute centers along given facelist,
				but don't draw them */
		    {
			if ( (facelist=Face_link_parse(p,nextptr,&endptr,
			     &hits,&Vlist,&Elist,&Flist,&region,
			     pathlist,pathlength)) )
			count += layout_facelist(p,0,&facelist,1,0,NOSHOW);
			        /* just to recompute centers */
			break;
		    }
		 case 's': /* angle sums */
		     {
		       fillcurves(p);
		       count++;
		       break;
		     }
		 case 'l': /* suppress poorly placed circles 
			      (better to use -cf option above) */
		   {
		     count += comp_pack_centers(p,1,dflag,opt,layout_th);
		     if (count<(p->nodecount))
		       {
			 sprintf(msgbuf,"CAUTION: using 'fix -l', %d "
				 "circles were not reliably located "
				 "and will generally not be drawn.",
				 p->nodecount-count);
			 msg();
		       }
		   }
		  } /* end of switch */
	 } /* end of while */
	if (flag) return count; /* done if options were specified */
	/* else, default actions */
	fillcurves(p);
	comp_pack_centers(p,errflag,dflag,opt,layout_th);
	count++;
	return count;
} /* fix_call */

