#include "cp_types.h"
#include "cp_proto.h"

/* normalizes eucl data of pack p by putting point a at origin 
and g on pos y-axis */

int e_norm_pack(struct p_data *p,complex a,complex g)
{
  int i,wflag=0;
  complex I,z,w,y;
  struct R_data *pR_ptr;
  struct RedList *trace;

  pR_ptr=p->packR_ptr;
  w=csub(g,a);
  I.re=0; I.im=cAbs(w);
  z=cdiv(I,w);
  for (i=1;i<=p->nodecount;i++)
    {
      y=csub(pR_ptr[i].center,a);
      pR_ptr[i].center=cmult(z,y);
    }
  if ((trace=p->redfaces))
    while (trace!=p->redfaces || !(wflag++))
      {
	y=csub(trace->center,a);
	trace->center=cmult(z,y);
	trace=trace->next;
      }
  return 1;
} /* e_norm_pack */
