#include "cp_types.h"
#include "cp_proto.h"

int delete(struct p_data *p,int v)
     /* routine to remove vertex from pack. Assume flowers 
pointing to it already adjusted.  */
{
  int i,k;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  for (i=1;i<=p->nodecount;i++)
    if (i!=v) for (k=0;k<=pK_ptr[i].num;k++)
      if (pK_ptr[i].flower[k]>v) pK_ptr[i].flower[k]--;
  if (pK_ptr[v].flower) free(pK_ptr[v].flower);
  if (pK_ptr[v].overlaps) free(pK_ptr[v].overlaps);
  for (i=v;i<p->nodecount;i++)
    {
      pK_ptr[i]=pK_ptr[i+1];
      pR_ptr[i]=pR_ptr[i+1];
    }
  pK_ptr[p->nodecount].flower=NULL;
  p->nodecount--;
  if (p->active_node>=v) p->active_node--;
  if (p->alpha>v) p->alpha--;
  choose_alpha(p);
  if (p->gamma>v) p->gamma--;
  choose_gamma(p);
  if (p->beta>v) p->beta--;
  choose_beta(p);
  return 1;
} /* delete */

int puncture(struct p_data *p,int v)
     /* remove one interior vert; must have at 
least 2 generations of interior nbhs. lose edge data. */
{
  int k,j,w,*newflower=NULL,start,indx;
  double *newoverlaps=NULL;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  
  for (j=0;j<pK_ptr[v].num;j++) /* check suitability */
    {
      if (pK_ptr[w=pK_ptr[v].flower[j]].num<4) return 0;
      for (k=0;k<=pK_ptr[w].num;k++)
	if (pK_ptr[pK_ptr[w].flower[k]].bdry_flag) return 0;
    }
  
  /* adjust neighbors' flowers and overlaps */
  for (j=0;j<pK_ptr[v].num;j++)
    {
      w=pK_ptr[v].flower[j];
      if ((start=nghb(p,w,v))<0) return 0; /* data will be screwy */
      newflower=(int *)
	calloc((size_t)(pK_ptr[w].num-1),sizeof(int));
      if (pK_ptr[w].overlaps) 
	newoverlaps=(double *)
	  calloc((size_t)(pK_ptr[w].num-1),sizeof(double));
      for (k=0;k<pK_ptr[w].num-1;k++)
	{
	  indx=(start+1+k) % (pK_ptr[w].num);
	  newflower[k]=pK_ptr[w].flower[indx];
	  if (newoverlaps)
	    newoverlaps[k]=pK_ptr[w].overlaps[indx];
	}
      pK_ptr[w].num -= 2;
      pK_ptr[w].bdry_flag=1;
      free(pK_ptr[w].flower);
      p->packR_ptr[w].aim=-.1;
      pK_ptr[w].flower=newflower;
      if (newoverlaps)
	{
	  free(pK_ptr[w].overlaps);
	  pK_ptr[w].overlaps=newoverlaps;
	  newoverlaps=NULL;
	}
    }
  delete(p,v);
  return 1;
} /* puncture */

int remove_bdry_vert(struct p_data *p,int v)
     /* remove vert v from pack p; have verified 
that v is bdry vert, removal will not disconnect or leave a 
neighbor without any faces. */
{
  int i,j,num,w,*newflower,indx,start;
  double *newoverlaps;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  /* fix flowers of neighbors */
  for (i=0;i<=pK_ptr[v].num;i++)
    {
      w=pK_ptr[v].flower[i];
      num=pK_ptr[w].num;
      if (pK_ptr[w].bdry_flag)
	{
	  newflower=(int *)calloc((size_t)(pK_ptr[w].num),
				  sizeof(int));
	  if (pK_ptr[w].flower[0]==v) 
	    for (j=0;j<pK_ptr[w].num;j++) 
	      newflower[j]=pK_ptr[w].flower[j+1];
	  else if (pK_ptr[w].flower[pK_ptr[w].num]==v)
	    for (j=0;j<pK_ptr[w].num;j++)
	      newflower[j]=pK_ptr[w].flower[j];
	  if (pK_ptr[w].overlaps)
	    {
	      newoverlaps=(double *)
		calloc((size_t)(pK_ptr[w].num),
		       sizeof(double));
	      if (pK_ptr[w].flower[0]==v) 
		for (j=0;j<pK_ptr[w].num;j++) 
		  newoverlaps[j]=pK_ptr[w].overlaps[j+1];
	      else if (pK_ptr[w].flower[pK_ptr[w].num]==v)
		for (j=0;j<pK_ptr[w].num;j++)
		  newoverlaps[j]=pK_ptr[w].overlaps[j];
	      free(pK_ptr[w].overlaps);
	      pK_ptr[w].overlaps=newoverlaps;
	    }
	  free(pK_ptr[w].flower);
	  pK_ptr[w].flower=newflower;
	  pK_ptr[w].num--;
	}
      else
	{
	  indx=nghb(p,w,v);
	  newflower=(int *)
	    calloc((size_t)(pK_ptr[w].num-1),sizeof(int));
	  start=(indx+1)%pK_ptr[w].num;
	  for (j=0;j<pK_ptr[w].num-1;j++) newflower[j]=
	    pK_ptr[w].flower[(start+j)%pK_ptr[w].num];
	  if (pK_ptr[w].overlaps)
	    {
	      newoverlaps=(double *)
		calloc((size_t)(pK_ptr[w].num-1),sizeof(double));
	      start=(indx+1)%pK_ptr[w].num;
	      for (j=0;j<pK_ptr[w].num-1;j++) newoverlaps[j]=
		pK_ptr[w].overlaps[(start+j)%pK_ptr[w].num];
	      free(pK_ptr[w].overlaps);
	      pK_ptr[w].overlaps=newoverlaps;
	    }
	  free(pK_ptr[w].flower);
	  pK_ptr[w].flower=newflower;
	  pK_ptr[w].num=num-2;
	  pK_ptr[w].bdry_flag=1;
			
	}
    } /* done removing references to v */
  delete(p,v);
  return 1;
} /* remove_bdry_vert */

int remove_tri_vert(struct p_data *p,int v)
     /* remove a trivalent, interior vert. Already checked that v qualifies. */
{
  int j,k,w,indx,*newflower;
  double *newoverlaps;
  struct K_data *pK_ptr;
	
  pK_ptr=p->packK_ptr;
  /* adjust nghbs */
  for (k=0;k<3;k++)
    {
      w=pK_ptr[v].flower[k];
      indx=nghb(p,w,v);
      newflower=(int *)calloc((size_t)(pK_ptr[w].num),
			      sizeof(int));
      for (j=0;j<indx;j++) newflower[j]=pK_ptr[w].flower[j];
      for (j=indx;j<pK_ptr[w].num;j++)
	{
	  newflower[j]=pK_ptr[w].flower[j+1];
	}
      free(pK_ptr[w].flower);
      pK_ptr[w].flower=newflower;
      if (pK_ptr[w].overlaps)
	{
	  newoverlaps=(double *)calloc((size_t)(pK_ptr[w].num),
				       sizeof(double));
	  for (j=0;j<indx;j++) 
	    newoverlaps[j]=pK_ptr[w].overlaps[j];
	  for (j=indx;j<pK_ptr[w].num;j++)
	    {
	      newoverlaps[j]=pK_ptr[w].overlaps[j+1];
	    }
	  free(pK_ptr[w].overlaps);
	  pK_ptr[w].overlaps=newoverlaps;
	}
      pK_ptr[w].num--;
      if (indx==0 && !pK_ptr[w].bdry_flag)
	{
	  pK_ptr[w].flower[pK_ptr[w].num]=
	    pK_ptr[w].flower[0];
	  if (pK_ptr[w].overlaps)
	    pK_ptr[w].overlaps[pK_ptr[w].num]=
	      pK_ptr[w].overlaps[0];
	}
    }
  delete(p,v);
  return 1;
} /* remove_tri_vert */

int remove_quad_vert(struct p_data *p,char *datastr)
     /* remove 4-deg interior vert v, but put 
in edge between w and the opposite vert z. Only does one vert now,
and overlaps are discarded. */
{
  int v,w,z,j,x,indx,hits,*newflower;
  double *newol;
  struct K_data *pK_ptr;
  struct Vertlist *vertlist;
  char *endptr;
	
  pK_ptr=p->packK_ptr;
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
       &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) == NULL 
     || vertlist->next==NULL)
    return 0;
  v=vertlist->v;
  w=vertlist->next->v;
  vert_free(&vertlist); /* only do one vert for now */	
  if (pK_ptr[v].bdry_flag || pK_ptr[v].num!=4
      || (indx=nghb(p,w,v))<0) return 0;
  z=pK_ptr[v].flower[(nghb(p,v,w)+2)%pK_ptr[v].num]; 
  /* fix data for w and z*/
  if (indx==0)
    {
      pK_ptr[w].flower[0]=pK_ptr[w].flower[pK_ptr[w].num]=z;
      if (p->overlap_status)
	pK_ptr[w].overlaps[0]=pK_ptr[w].overlaps[pK_ptr[w].num]=1.0;
    }
  else 
    {
      pK_ptr[w].flower[indx]=z;
      if (p->overlap_status)
	pK_ptr[w].overlaps[indx]=1.0;
    }
  if ((indx=nghb(p,z,v))==0)
    {
      pK_ptr[z].flower[0]=pK_ptr[z].flower[pK_ptr[z].num]=w;
      if (p->overlap_status) 
	pK_ptr[z].overlaps[0]=pK_ptr[z].overlaps[pK_ptr[z].num]=1.0;
    }
  else
    {
      pK_ptr[z].flower[indx]=w;
      if (p->overlap_status)
	pK_ptr[z].overlaps[indx]=1.0;
    }
  /* remove v from others */
  x=pK_ptr[v].flower[(nghb(p,v,w)+1)%pK_ptr[v].num];
  indx=nghb(p,x,v);
  newflower=(int *)calloc((size_t)(pK_ptr[x].num),sizeof(int));
  for (j=0;j<indx;j++) newflower[j]=pK_ptr[x].flower[j];
  for (j=indx;j<pK_ptr[x].num;j++)
    newflower[j]=pK_ptr[x].flower[j+1];
  free(pK_ptr[x].flower);
  pK_ptr[x].flower=newflower;
  if (p->overlap_status)
    {
      newol=(double *)calloc((size_t)(pK_ptr[x].num),sizeof(double));
      for (j=0;j<indx;j++) newol[j]=pK_ptr[x].overlaps[j];
      for (j=indx;j<pK_ptr[x].num;j++)
	newol[j]=pK_ptr[x].overlaps[j+1];
      free(pK_ptr[x].overlaps);
      pK_ptr[x].overlaps=newol;
    }
  pK_ptr[x].num--;
  x=pK_ptr[v].flower[(nghb(p,v,z)+1)%pK_ptr[v].num];
  indx=nghb(p,x,v);
  newflower=(int *)calloc((size_t)(pK_ptr[x].num),sizeof(int));
  for (j=0;j<indx;j++) newflower[j]=pK_ptr[x].flower[j];
  for (j=indx;j<pK_ptr[x].num;j++)
    newflower[j]=pK_ptr[x].flower[j+1];
  free(pK_ptr[x].flower);
  pK_ptr[x].flower=newflower;
  if (p->overlap_status)
    {
      newol=(double *)calloc((size_t)(pK_ptr[x].num),sizeof(double));
      for (j=0;j<indx;j++) newol[j]=pK_ptr[x].overlaps[j];
      for (j=indx;j<pK_ptr[x].num;j++)
	newol[j]=pK_ptr[x].overlaps[j+1];
      free(pK_ptr[x].overlaps);
      pK_ptr[x].overlaps=newol;
    }
  pK_ptr[x].num--;
  delete(p,v);
  complex_count(p,0);
  facedraworder(p,0);
  fillcurves(p);
  return 1;
} /* remove_quad_vert */
	
int remove_circle(struct p_data *p,char *datastr)
     /* remove one trivalent or bdry vert */
{
  int i,v,w,flag,count=0,hits;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;
  struct Vertlist *vertlist,*trace,*newtrace;
  char *endptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
       &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) == NULL )
    return 0;
  trace=vertlist;
  while (trace!=NULL)
    {
      if((v=trace->v)==0) 
	{trace=trace->next;continue;}
      flag=0;
      if (!pK_ptr[v].bdry_flag)
	{
	  if (pK_ptr[v].num!=3) flag++;
	  else for (i=0;i<3;i++)
	    {
	      w=pK_ptr[v].flower[i];
	      if ((!pK_ptr[w].bdry_flag && pK_ptr[w].num<=3)
		  || (pK_ptr[w].bdry_flag && pK_ptr[w].num<2))
		flag++;
	    }
	}
      else if (pK_ptr[v].bdry_flag)
	{
	  if (pK_ptr[pK_ptr[v].flower[0]].num<2
	      || pK_ptr[pK_ptr[v].flower[pK_ptr[v].num]].num<2)
	    flag++;
	  for (i=1;i<pK_ptr[v].num;i++) 
	    if (pK_ptr[pK_ptr[v].flower[i]].bdry_flag) flag++;
	}
      if (flag) {trace=trace->next;continue;} 
      /* vert doesn't qualify */
      if (pK_ptr[v].bdry_flag)
	{
	  for (i=0;i<=pK_ptr[v].num;i++) 
	    pR_ptr[pK_ptr[v].flower[i]].aim=-.1;
	  count += remove_bdry_vert(p,v);
	}
      else  count += remove_tri_vert(p,v);
      newtrace=trace->next;
      while (newtrace!=NULL) /* fix remainder of list */
	{
	  if (newtrace->v==v) newtrace->v=0;
	  else if (newtrace->v>v) newtrace->v--;
	  newtrace=newtrace->next;
	}
      trace=trace->next;
    }
  if (!count) 
    {
      sprintf(msgbuf,"no vertices qualified for deletion.");
      emsg();
      return 0;
    }
  vert_free(&vertlist);
  complex_count(p,0);
  facedraworder(p,0);
  fillcurves(p);
  return 1;
} /* remove_circle */








