#include "cp_types.h"
#include "cp_proto.h"

/* Copy p1 into p2. The rational for moving stuff instead of
recomputing some of it is time and assumption that data (eg.
drawing order) may have been modified for some specific purpose. */

int copy_pack(struct p_data *p1,struct p_data *p2)
{
  int i,j,size,wflag;
  struct K_data *pK_ptr1,*pK_ptr2;
  struct R_data *pR_ptr1,*pR_ptr2;
  struct s_data *screen;
  struct Edgelist *trace,*new_trace;
  struct RedList *rtrace,*here;
  struct EdgePair *ehold;

  /* throw out old stuff */
  if (!alloc_pack_space(p2,(p1->nodecount + 1),0))
    {
      sprintf(msgbuf,"Error allocating pack space.");
      emsg();
      return 0;
    }
  pK_ptr1=p1->packK_ptr;pR_ptr1=p1->packR_ptr;
  pK_ptr2=p2->packK_ptr;pR_ptr2=p2->packR_ptr;
  size=p2->sizelimit;
  ehold=p2->edge_pair;
  screen=p2->screen;

  /* copy whole hog */
  *p2=*p1;

  /* reset some data and pointers */
  p2->screen=screen;
  p2->sizelimit=size;
  p2->edge_pair=ehold;
  p2->packK_ptr=pK_ptr2; 
  p2->packR_ptr=pR_ptr2;
  p2->faces=NULL;
  p2->redfaces=NULL;
  p2->vertex_map=NULL;
  p2->rwb_flags=NULL;
  p2->f_util=NULL;
  p2->vlist=NULL;
  p2->elist=NULL;
  p2->flist=NULL;
  p2->overlap_status=0;

  /* move data over */
  for (i=1;i<=p1->nodecount;i++)
    {
      pK_ptr2[i]=pK_ptr1[i];
      pR_ptr2[i]=pR_ptr1[i];
      pK_ptr2[i].flower=(int *)
	calloc((size_t)(pK_ptr2[i].num+1),sizeof(int));
      for (j=0;j<=pK_ptr2[i].num;j++)
	pK_ptr2[i].flower[j]=pK_ptr1[i].flower[j];
    }
  if (!alloc_faces_space(p2))
    {
      sprintf(msgbuf,"Error allocating face data space.");
      emsg();
      return 0;
    }
  /* get the drawing order stuff */
  for (i=1;i<=p1->facecount;i++) p2->faces[i]=p1->faces[i]; 
  if (p1->rwb_flags)
    {
      p2->rwb_flags=(int *)calloc((size_t)(p2->facecount+1),sizeof(int));
      for (i=1;i<=p1->facecount;i++) p2->rwb_flags[i]=p1->rwb_flags[i];
    }
  if ((trace=p1->vertex_map))
    {
      p2->vertex_map=new_trace=(struct Edgelist *)
	calloc((size_t)1,sizeof(struct Edgelist));
      p2->vertex_map->v=p1->vertex_map->v;
      p2->vertex_map->w=p1->vertex_map->w;
      while ((trace=trace->next))
	{
	  new_trace=new_trace->next=(struct Edgelist *)
	    calloc((size_t)1,sizeof(struct Edgelist));
	  new_trace->v=trace->v;
	  new_trace->w=trace->w;
	}
    }
  /* copy/create redlist stuff */
  if ((here=p1->redfaces))
    {
      p2->redfaces=rtrace=(struct RedList *)
	calloc((size_t)1,sizeof(struct RedList));
      rtrace->face=here->face;
      rtrace->next=p2->redfaces;
      while (here->next!=p1->redfaces)
	{
	  here=here->next;
	  rtrace->next=(struct RedList *)
	    calloc((size_t)1,sizeof(struct RedList));
	  rtrace->next->face=here->face;
	  rtrace->next->prev=rtrace;
	  rtrace->next->next=p2->redfaces;
	  rtrace=rtrace->next;
	}
      p2->redfaces->prev=rtrace;
      redface_comb_info(p2,p2->redfaces,p2->edge_pair);

      /* copy the bdry rad/center data */
      wflag=0;
      here=p1->redfaces;
      rtrace=p2->redfaces;
      while ((here!=p1->redfaces) || !(wflag++))
	{
	  if ((here->face==rtrace->face) 
	      && (here->v_flag==rtrace->v_flag))
	    {
	      rtrace->next->rad=here->rad;
	      rtrace->next->center=here->center;
	    }
	  else here=p1->redfaces->prev; /* to bust out of while */
	  here=here->next;
	  rtrace=rtrace->next;
	}
    }
  if (p1->overlap_status && alloc_overlaps(p2))
    for (i=1;i<=p1->nodecount;i++)
      for (j=0;j<=pK_ptr1[i].num;j++)
	pK_ptr2[i].overlaps[j]=pK_ptr1[i].overlaps[j];
  p2->locks=0;
  return 1;
} /* copy_pack */
