#include "cp_types.h"
#include "cp_proto.h"

int consume_one_index(struct Vertlist **vptr)
     /* read/remove first index from vertlist */
{
  int n;
  struct Vertlist *clobber;

  if (!(*vptr)) return 0;
  n=(*vptr)->v;
  clobber=*vptr;
  *vptr=(*vptr)->next;
  free(clobber);
  return n;
} /* consume_one_index */

int consume_one_edge(struct Edgelist **eptr,int *v1,int *v2)
     /* read/remove one edge from edgelist */
{
  struct Edgelist *clobber;

  if (!(*eptr)) return 0;
  *v1=(*eptr)->v;
  *v2=(*eptr)->w;
  clobber=*eptr;
  *eptr=(*eptr)->next;
  free(clobber);
  return 1;
} /* consume_one_edge */
