#include "cp_types.h"
#include "cp_proto.h"

int nghb(struct p_data *p,int v,int w)
     /* return -1 if w is not neighbor of v, else returns index of
w in flower of v. */
{
  int j;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (v<1 || v>p->nodecount || w<1 || w>p->nodecount) return -1;
  for (j=0;j<=pK_ptr[v].num;j++)
    if (pK_ptr[v].flower[j]==w) return j;
  return (-1);
} /* nghb */

int find_index(struct p_data *p,int f,int v)
     /* return -1 if v not in face f; else return index of v
in vertices of f. */
{
  int m=0;

  while (m<3) 
    {if (p->faces[f].vert[m]==v) return m; m++;}
  return -1;
} /* find_index */

int nghb_tri(struct p_data *p,int m,int n)
     /* -1 if face n doesn't share edge e with m; else gives 
index of begin vertex of e in data of n. */
{
  int nj,mj,v1,v2;

  if (m<1 || m > p->facecount || n<1 || n > p->facecount || m==n) 
    return -1;
  for (nj=0;nj<=2;nj++)
    {
      v1=p->faces[n].vert[nj];
      v2=p->faces[n].vert[(nj+1)%3];
      for (mj=0;mj<=2;mj++)
	if ( (v1==p->faces[m].vert[mj]) && 
	     (v2==p->faces[m].vert[(mj+2)%3]) )
	  return nj;
    }
  return -1;
} /* nghb_tri */

int red_share_vert(struct p_data *p,struct RedList *redlist)
     /* return outside vert shared by redlist face and its
	successor face. Return 0 on error. */
{
  int cface,nface,indx;

  if (!redlist || !(cface=redlist->face)
      || !(nface=redlist->next->face))
    return 0;
  if ((indx=nghb_tri(p,nface,cface))<0) 
    return 0;
  return p->faces[cface].vert[indx];
} /* red_share_vert */

int check_face(struct p_data *p,int f,int v,int w)
     /* Return -1 if ordered edge <v,w> not in face f. 
Else, return index of v in verts of f. */
{
  int m=0;

  while (m<3)
    {if (p->faces[f].vert[m]==v && p->faces[f].vert[(m+1)%3]==w)
      return m; m++;}
  return -1;
} /* check_face */

int what_face(struct p_data *p,int a,int b,int c)
     /* return face num if <a,b,c> is face, else 0. */
{
  int f,j,count=p->nodecount;
  f_data *faces;

  faces=p->faces;
  if (!p->status || a<0 || b<0 || c<0 
      || a>count || a>count || c>count) return 0;
  for (f=1;f<=p->facecount;f++)
    for (j=0;j<3;j++)
      if (p->faces[f].vert[j]==a 
	  && (p->faces[f].vert[(j+1)%3]==b || p->faces[f].vert[(j+1)%3]==c) 
	  && (p->faces[f].vert[(j+2)%3]==b || p->faces[f].vert[(j+2)%3]==c))
	return f;
  return 0;
} /* what_face */

int cross_edge_vert(struct p_data *p,int v,int k)
     /* Return vert across edge from v. Edge is that 
from flower[k] to flower[k+1]. Return 0 on failure. */
{
  int N,ind,w;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (v<1 || v>p->nodecount || k<0 || k>(N=pK_ptr[v].num)
      || (k==N && pK_ptr[v].bdry_flag) ) return 0;
  w=pK_ptr[v].flower[k];
  ind=nghb(p,w,v);
  if (pK_ptr[w].bdry_flag)
    {
      if (ind<2) return 0;
      else return (pK_ptr[w].flower[ind-2]);
    }
  return (pK_ptr[w].flower[(ind+pK_ptr[w].num-2)%(pK_ptr[w].num)]);
} /* cross_edge_vert */

int left_face(struct p_data *p,int v,int w,int *u)
     /* return face to left of edge v w. Return 0 if no face. 
u is third vert of face. */
{
  int f,i;

  for (f=1;f<=p->facecount;f++)
    {if (check_face(p,f,v,w)>=0) break;}
  if (f>p->facecount) return 0; /* no face */
  for (i=0;i<3;i++) if ((*u=p->faces[f].vert[i])!=v && (*u)!=w) return f;
  return 0;
} /* left_face */

int index_of_paired_edge(struct p_data *p,int n)
     /* check whether index n bdry edge segment is a paired segment. 
Return edge index of mate, if found, else 0. */
{
  int i;

  for (i=1;p->edge_pair[i].edge;i++)
    {
      if (p->edge_pair[i].mate==p->edge_pair[n].edge
	  && p->edge_pair[i].mate_indx==p->edge_pair[n].edge_indx)
	return i;
    }
  return 0;
} /* index_of_paired_edge */

int hex_proj(struct p_data *p,int v,int w)
     /* If v is interior and hex, w is petal, return
petal u opposite w. If v bdry, 3 faces, w bdry, return petal
on bdry opposite w. Return 0 on failure. */
{
  if (v==w || (p->packK_ptr[v].bdry_flag && p->packK_ptr[v].num!=3)
      || (!p->packK_ptr[v].bdry_flag && p->packK_ptr[v].num!=6))
    return 0;
  if (p->packK_ptr[v].bdry_flag)
    {
      if (p->packK_ptr[v].flower[0]==w) 
	return p->packK_ptr[v].flower[3];
      if (p->packK_ptr[v].flower[3]==w)
	return p->packK_ptr[v].flower[0];
      return 0;
    }
  return p->packK_ptr[v].flower[(nghb(p,v,w)+3)%6];
} /* hex_proj */ 

int hex_extend(struct p_data *p,int v,int w,int lgth)
     /* Check for a hex-extended edge from v to w of lenght no more
	than 'lgth'. Return index in flower of v of direction to w,
	or -1 on failure. */
{
  int i,dir,next,current,last;
  struct K_data *pK_ptr=p->packK_ptr;

  if (v==w || lgth<1) return -1;
  for (dir=0;dir<pK_ptr[v].num+pK_ptr[v].bdry_flag;dir++)
    {
      last=v;
      current=pK_ptr[v].flower[dir];
      i=1;
      while (current!=w && i<lgth && (next=hex_proj(p,current,last)) )
	{
	  last=current;
	  current=next;
	  i++;
	}
      if (current==w) return dir; /* found it */
    }
  return -1;
} /* hex_extend */

int bdry_comp_count(struct p_data *p,int v)
/* retrn count of edges in bdry component of v. 0 if v not bdry 
or some comb error. */
{
  int next,count=1,maxcount;

  if (!p->packK_ptr[v].bdry_flag) return 0;
  maxcount=p->nodecount-p->intnode;
  next=v;
  while ((next=p->packK_ptr[next].flower[0])!=v 
	 && count<= maxcount) count++;
  if (count>maxcount) return 0;
  return count;
} /* bdry_comp_count */

int red_fan(struct p_data *p,struct RedList *redlist,int v,int *n1,int *n)
/* v must be vert of redlist->face which is on outside of red chain. 
Find fan of faces for v which don't cross red chain, namely, return 
first index and number of faces. */
{
  int face,f,cf;
  struct RedList *rtrace;

  face=cf=redlist->face;
  rtrace=redlist;
  while ((f=rtrace->next->face)!=face 
	 && v==p->faces[f].vert[(nghb_tri(p,cf,f)+1)%3])
    {
      rtrace=rtrace->next;
      cf=rtrace->face;
    }
  *n1=nghb(p,v,p->faces[cf].vert[(find_index(p,cf,v)+1)% 3]);
  *n=1;
  while (((f=rtrace->prev->face)!=cf) 
	 && v==p->faces[f].vert[nghb_tri(p,rtrace->face,f)])
    {
      (*n)++;
      rtrace=rtrace->prev;
    }
  return 1;
} /* red_fan */

int common_nghbs(struct p_data *p,int v,int w)
/* Find common nghbs to v and w. If there are none, return -1. Otherwise,
return index in flower of v of vert which is on left as one looks from
v to w. */
{
  int i;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  for (i=0;i<pK_ptr[v].num;i++)
      if (nghb(p,pK_ptr[v].flower[i],w)>=0 
	  && nghb(p,pK_ptr[v].flower[i+1],w)>=0)
	return i;
  return -1;
} /* common_nghbs */
