#include "cp_types.h"
#include "cp_proto.h"

/* If hyperbolic, apply a Mobius trans of disc putting ctr at 
origin. If euclidean, translate. */

int center_point(struct p_data *p,complex ctr)
{
  int i,wflag=0;
  complex z1,z2,z3,zz;
  double radius;
  struct R_data *pR_ptr;
  struct RedList *trace;
	
  pR_ptr=p->packR_ptr;
  if (p->hes<0)
    {
      if ( (ctr.re*ctr.re+ctr.im*ctr.im)>(1.0-m_toler) )
	{
	  sprintf(msgbuf," centering: chosen point is too "
		  "close to ideal boundary.");
	  emsg();
	  return 0;
	}
      for (i=1;i<=p->nodecount;i++) 
	{
	  radius=(-pR_ptr[i].rad);
	  if (radius>0) /* for horocycle */
	    {
	      z1=pR_ptr[i].center;
	      z2.re=(1-2*radius)*z1.re;
	      z2.im=(1-2*radius)*z1.im;
	      z3.re=(1-radius)*z1.re-radius*z1.im;
	      z3.im=(1-radius)*z1.im+radius*z1.re; 
	      z1=mob_trans(z1,ctr);
	      z2=mob_trans(z2,ctr);
	      z3=mob_trans(z3,ctr);
	      circle_3(z1,z2,z3,&zz,&radius);
	      pR_ptr[i].rad=(-radius);
	    }
	  pR_ptr[i].center=mob_trans(pR_ptr[i].center,ctr);
	  pR_ptr[i].center.re *= (-1.0);
	  pR_ptr[i].center.im *= (-1.0);
	}
      if ((trace=p->redfaces)) /* adjust centers in red list */
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    radius=(-(trace->rad));
	    if (radius>0) /* for horocycle */
	      {
		z1=pR_ptr[i].center;
		z2.re=(1-2*radius)*z1.re;
		z2.im=(1-2*radius)*z1.im;
		z3.re=(1-radius)*z1.re-radius*z1.im;
		z3.im=(1-radius)*z1.im+radius*z1.re; 
		z1=mob_trans(z1,ctr);
		z2=mob_trans(z2,ctr);
		z3=mob_trans(z3,ctr);
		circle_3(z1,z2,z3,&zz,&radius);
		trace->rad=(-radius);
	      }
	    trace->center=mob_trans(trace->center,ctr);
	    trace->center.re *= (-1.0);
	    trace->center.im *= (-1.0);
	    trace=trace->next;
	  }
      if (p->edge_pair[2].edge)
	/* fix side-pairing mobius transforms also */
	update_pair_mob(p);
      return 1;
    }
  else if (p->hes==0) /* eucl */
    {
      for (i=1;i<=p->nodecount;i++) 
	pR_ptr[i].center=csub(pR_ptr[i].center,ctr);
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    trace->center=csub(trace->center,ctr);
	    trace=trace->next;
	  }
      if (p->edge_pair[2].edge)
	/* fix side-pairing mobius transforms also */
	update_pair_mob(p);
      return 1;
    }
  /* fixup: sph not handled yet */
  return 0;
} /* center_point */


