#include "cp_types.h"
#include "cp_proto.h"

/* Build red chain and fdo (face draw order) from seed, 
remaining cognizant of any poison verts. Must have stored catalog 
of faces before this routine. */

struct RedList *build_redchain(struct p_data *p,int seed,
			       struct Vertlist *fdo)
{
  int i,f,num,loop_count=0,hit_flag,stop,looplimit,*face_ptr;
  int debug=0,tripflag=0,sph_flag=0;
  f_data *faces;
  struct RedList *redlist,*temp,*rtrace,*stop_ptr;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  faces=p->faces;
  p->f_util=(int *)calloc((size_t)(p->facecount+1),sizeof(int));

  /* start with faces about seed (assuming seed not poison) */

  face_ptr=face_org[seed]+1;
  num=pK_ptr[seed].num;
  redlist=temp=(struct RedList *)calloc((size_t)1,sizeof(struct RedList));
  redlist->face=f=*(face_ptr); /* first face */
  fdo->v=f;
  faces[f].index_flag=find_index(p,f,seed);
  for (i=1;i<num;i++)
    {
      f=*(face_ptr+i);
      redlist->next=(struct RedList *)
	calloc((size_t)1,sizeof(struct RedList));
      rtrace=redlist;
      redlist=redlist->next;
      redlist->prev=rtrace;
      redlist->face=f;
      fdo=fdo->next=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      fdo->v=f;
      faces[f].index_flag=find_index(p,f,seed);
    }
  fdo->next=NULL;
  if (!pK_ptr[seed].bdry_flag) redlist->next=temp;
  else /* backtrack to get closed list */
    {
      for (i=num-2;i>0;i--)
	{
	  f=*(face_ptr+i);
	  redlist->next=(struct RedList *)
	    calloc((size_t)1,sizeof(struct RedList));
	  rtrace=redlist;
	  redlist=redlist->next;
	  redlist->prev=rtrace;
	  redlist->face=f;
	}
      redlist->next=temp;
    }
  temp->prev=redlist;

  /* ----------- main loop for the rest of the faces ---------------- */

  looplimit=(100)*p->nodecount; /* emergency limit */
  stop=0;
  hit_flag=1;
  while (hit_flag && !stop && loop_count<looplimit)
    {
      hit_flag=0;
      stop_ptr=redlist;
      /* one pass to get started */
      if (!loop_vert(p,&redlist,&fdo,&stop_ptr,&tripflag,0,&hit_flag))
	stop=1; /* redchain a closed flower */
      if (debug) 
	{if (hit_flag) record_redlist(redlist,p->facecount);
	ck_list(redlist);}
      /* multiple passes for loop-overs only */
      while (!stop && (tripflag<2) && loop_count<looplimit
	     && (sph_flag=loop_vert(p,&redlist,&fdo,
				    &stop_ptr,&tripflag,0,&hit_flag)))
	{
	  loop_count++;
	  while (p->f_util[redlist->face]
		 && tripflag<2) /* move on */
	    {
	      if (redlist==stop_ptr) 
		tripflag++;
	      redlist=redlist->next;
	    }
	  if (debug) 
	    {if (hit_flag) record_redlist(redlist,p->facecount);
	    ck_list(redlist);} 
	}
      if (loop_count==looplimit || !sph_flag) stop=1;
      tripflag=0;	   
      stop_ptr=redlist;
      /* multiple passes, allowing blues also */
      while (!stop && (tripflag<3) && loop_count<looplimit
	     && (sph_flag=loop_vert(p,&redlist,&fdo,
				    &stop_ptr,&tripflag,1,&hit_flag)))
	{
	  loop_count++;
	  while (p->f_util[redlist->face]
		 && tripflag<2) /* move on */
	    {
	      if (redlist==stop_ptr) 
		tripflag++;
	      redlist=redlist->next;
	    }
	  if (debug) 
	    {if (hit_flag) record_redlist(redlist,p->facecount);
	    ck_list(redlist);} 
	}
      /* a couple more passes, just to make sure */
      if (sph_flag) 
	for (i=1;i<3;i++) 
	  {
	    if (!loop_vert(p,&redlist,&fdo,&stop_ptr,
			   &tripflag,1,&hit_flag))
	      stop=1;
	    if (debug) 
	      {if (hit_flag) record_redlist(redlist,p->facecount);
	      ck_list(redlist);} 
	    loop_count++;
	  }
      else stop=1;
    } /* end of main while */

  if (loop_count==looplimit)
    {
      sprintf(msgbuf,"emergency exit in build_redchain.");
      emsg();
    }
  
  free(p->f_util);
  p->f_util=NULL;
  return redlist;
} /* build_redchain */
