/* cp_head.h  include file of global variables for the program CirclePack */

#ifndef CP_HEAD_H
#define CP_HEAD_H

#include "cp_types.h"
#include "cp_proto.h"
#include <sys/types.h>
#define NUM_PACKS 3		/* number of packs and canvases allowed */
#include "xv_head.h"

/* ================ color stuff (eventually depends on GUI) === */

	unsigned long *colors,*color; /* color table and ptr to my colors. */

/* ============= global variables for CirclePack ===================== */
/* (see cp_types.h for global variables needed by the cp library) */

FILE *post_fp;		/* file for canvas postscript output */
FILE *custom_fp;	/* file for "custom" postscript output */
FILE *script_fp;	/* file for command scripts */
FILE *log_fp;           /* file for log in cmd mode */

char CPVersion[64];     /* CirclePack Version number */
char CPHelp[256];       /* location of help file */
char rgb_file[NAME_MAX]; /* name of file of rbg colors */
char user_name[64];     /* store for use in postscript output */
char script_name[NAME_MAX]; /* name of script file */
char packing_dir_name[NAME_MAX]; /* directory for packings */
char print_cmd[NAME_MAX]; /* cmd for printing */
char ps_file_name[NAME_MAX]; /* custom postscript output */
char print_file_name[NAME_MAX]; /* printing postscript file */
char *home_dir;		/* store user home directory */
char *working_dir;	/* store current working directory */
char *ftn_keys[12];     /* cmd strings for ftn keys 1--10 (see .packrc) */
char packlabels[NUM_PACKS][64]; /* pack panel button labels */
char cmd_history[BUFSIZE]; /* stores last command for reuse */
char path[NAME_MAX];	/* path name for packing directory */
char *emsgbuf,*msgbuf;	/* error message/message buffers (overlap) */
char buf[BUFSIZE];	/* general purpose utility buffer */
char *next_script_cmd;	/* pts to next command from script file */

int cmd_mode;           /* set if in command-line mode */
int current_p;		/* index to current screen and pack */
int totalpasses;	/* number of passes in riffle */
int canv_size;          /* opening size of canvases */
int cmd_search_depth;	/* prevent looping of cmd search */
int draw_speed;		/* 0 = disp screen after all objects drawn */
int ScrX,ScrY;		/* x,y of main panel */
int live_node[NUM_PACKS]; /* last circle plotted in 'projection' mode */
int live_face[NUM_PACKS]; /* last face plotted in 'projection' mode */
int editYN;		/* enable flag for editing script file */
int init_shmem;         /* flag: shared memory initialized? */
int list_ready;         /* 'v' pressed in canvas makes it sensitive to 
			   left or middle mouse: add vert/face to 
			   vlist/flist */

double inc_factor,eucl_factor; /* default adjustment factors */

struct Edgelist *b_flip,*r_flip; /* ptrs to edges for Whitehead moves */

Mobius Mob;		/* currently specified Mobius transform */


/* =====================  procedure prototypes ======================= */

#include "CP_proto.h"

#endif




