# +==========================================================================+
# || CipUX::Object                                                          ||
# ||                                                                        ||
# || CipUX Object Layer Class                                               ||
# ||                                                                        ||
# || Copyright (C) 2007 - 2009 by Christian Kuelker. All rights reserved!   ||
# ||                                                                        ||
# || License: GNU General Public License - GNU GPL version 2                ||
# ||          or (at your opinion) any later version.                       ||
# ||                                                                        ||
# +==========================================================================+
# $Id: Action.pm 2747 2008-09-27 11:31:15Z palik-guest $
# $Revision: 2747 $
# $HeadURL$
# $Date: 2008-09-27 13:31:15 +0200 (Sa, 27 Sep 2008) $
# $Source$

package CipUX::Object;

use 5.008001;
use strict;
use warnings;

use Carp;
use Class::Std;
use Data::Dumper;
use Log::Log4perl qw(:easy);
use Readonly;

{    # BEGIN CLASS

    use version; our $VERSION = qv('3.4.0.0');
    use re 'taint';    # Keep data captured by parens tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safe

    # +======================================================================+
    # || CONSTANTS                                                          ||
    # +======================================================================+
    Readonly::Scalar my $EMPTY_STRING => q{};

    sub capabilities {

        # +------------------------------------------------------------------+
        # | API
        my $self = shift;
        my $msg  = shift;

        # +------------------------------------------------------------------+
        # | API
        return;

    } ## end sub out
}    # END INSIDE-OUT CLASS

1;

__END__

=pod


=head1 NAME

CipUX::Object - Object layer class for CipUX


=head1 VERSION

version 3.4.0.0


=head1 SYNOPSIS

  use CipUX::Object;

  my $obj = CipUX::Object->new();

=head1 DESCRIPTION

Provides capabilities of Object layer

=head1 SUBROUTINES/METHODS

The following functions will be exported by CipUX::Object

=head2 capabilities

TODO

=head1 DIAGNOSTICS

TODO

=head1 CONFIGURATION AND ENVIRONMENT

TODO

=head1 DEPENDENCIES

Carp
Class:Std
CipUX
CipUX::Storage


=head1 INCOMPATIBILITIES

Not known.


=head1 BUGS AND LIMITATIONS

Not known.


=head1 SEE ALSO

See the CipUX web page and the manual at L<http://www.cipux.org>

See the mailing list L<http://sympa.cipworx.org/wws/info/cipux-devel>

=head1 AUTHOR

Christian Kuelker  E<lt>christian.kuelker@cipworx.orgE<gt>

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2007 - 2009 by Christian Kuelker

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA

=cut

